/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.web.SummaryRenderer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.stat.RateSummaryListener;
import net.i2p.util.Log;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdMemoryBackendFactory;
import org.jrobin.core.Sample;

class SummaryListener
implements RateSummaryListener {
    private I2PAppContext _context = I2PAppContext.getGlobalContext();
    private Log _log;
    private Rate _rate;
    private String _name;
    private String _eventName;
    private RrdDb _db;
    private Sample _sample;
    private RrdMemoryBackendFactory _factory;
    private SummaryRenderer _renderer;
    static final int PERIODS = 1440;

    public SummaryListener(Rate r) {
        this._rate = r;
        this._log = this._context.logManager().getLog(SummaryListener.class);
    }

    public void add(double totalValue, long eventCount, double totalEventTime, long period) {
        block4: {
            long now = this.now();
            long when = now / 1000L;
            if (this._db != null) {
                try {
                    this._sample.setTime(when);
                    double val = eventCount > 0L ? totalValue / (double)eventCount : 0.0;
                    this._sample.setValue(this._name, val);
                    this._sample.setValue(this._eventName, (double)eventCount);
                    this._sample.update();
                }
                catch (IOException ioe) {
                    this._log.error("Error adding", ioe);
                }
                catch (RrdException re) {
                    if (!this._log.shouldLog(30)) break block4;
                    this._log.warn("Error adding", re);
                }
            }
        }
    }

    static String createName(I2PAppContext ctx, String wanted) {
        return ctx.sha().calculateHash(DataHelper.getUTF8(wanted)).toBase64().substring(0, 20);
    }

    public Rate getRate() {
        return this._rate;
    }

    public void startListening() {
        RateStat rs = this._rate.getRateStat();
        long period = this._rate.getPeriod();
        String baseName = rs.getName() + "." + period;
        this._name = SummaryListener.createName(this._context, baseName);
        this._eventName = SummaryListener.createName(this._context, baseName + ".events");
        try {
            RrdDef def = new RrdDef(this._name, this.now() / 1000L, period / 1000L);
            long heartbeat = period * 10L / 1000L;
            def.addDatasource(this._name, "GAUGE", heartbeat, Double.NaN, Double.NaN);
            def.addDatasource(this._eventName, "GAUGE", heartbeat, 0.0, Double.NaN);
            double xff = 0.9;
            int steps = 1;
            int rows = 1440;
            def.addArchive("AVERAGE", xff, steps, rows);
            this._factory = (RrdMemoryBackendFactory)RrdBackendFactory.getDefaultFactory();
            this._db = new RrdDb(def, (RrdBackendFactory)this._factory);
            this._sample = this._db.createSample();
            this._renderer = new SummaryRenderer(this._context, this);
            this._rate.setSummaryListener(this);
        }
        catch (RrdException re) {
            this._log.error("Error starting", re);
        }
        catch (IOException ioe) {
            this._log.error("Error starting", ioe);
        }
    }

    public void stopListening() {
        if (this._db == null) {
            return;
        }
        try {
            this._db.close();
        }
        catch (IOException ioe) {
            this._log.error("Error closing", ioe);
        }
        this._rate.setSummaryListener(null);
        this._factory.delete(this._db.getPath());
        this._db = null;
    }

    public void renderPng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, boolean showCredit) throws IOException {
        this._renderer.render(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, showCredit);
    }

    public void renderPng(OutputStream out) throws IOException {
        this._renderer.render(out);
    }

    String getName() {
        return this._name;
    }

    String getEventName() {
        return this._eventName;
    }

    RrdDb getData() {
        return this._db;
    }

    long now() {
        return this._context.clock().now();
    }

    public boolean equals(Object obj) {
        return obj instanceof SummaryListener && ((SummaryListener)obj)._rate.equals(this._rate);
    }

    public int hashCode() {
        return this._rate.hashCode();
    }

    static {
        try {
            RrdBackendFactory.setDefaultFactory("MEMORY");
        }
        catch (RrdException re) {
            re.printStackTrace();
        }
    }
}

