/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterAddress;
import net.i2p.router.Router;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.ntcp.NTCPAddress;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.NewsFetcher;
import net.i2p.router.web.SummaryBarRenderer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

public class SummaryHelper
extends HelperBase {
    private String _action;
    private String _consoleNonce;
    private String _updateNonce;
    private String _requestURI;

    public String getIdent() {
        if (this._context == null) {
            return "[no router]";
        }
        if (this._context.routerHash() != null) {
            return this._context.routerHash().toBase64().substring(0, 4);
        }
        return "[unknown]";
    }

    public String getVersion() {
        return "0.8.1-0";
    }

    public String getUptime() {
        if (this._context == null) {
            return "[no router]";
        }
        Router router = this._context.router();
        if (router == null) {
            return "[not up]";
        }
        return DataHelper.formatDuration(router.getUptime());
    }

    public boolean allowReseed() {
        return this._context.netDb().isInitialized() && (this._context.netDb().getKnownRouters() < 30 || Boolean.valueOf(this._context.getProperty("i2p.alwaysAllowReseed")) != false);
    }

    public int getAllPeers() {
        return Math.max(this._context.netDb().getKnownRouters() - 1, 0);
    }

    public String getReachability() {
        return this.reachability();
    }

    private String reachability() {
        if (this._context.router().getUptime() > 60000L && !this._context.router().gracefulShutdownInProgress() && !this._context.clientManager().isAlive()) {
            return this._("ERR-Client Manager I2CP Error - check logs");
        }
        long skew = this._context.commSystem().getFramedAveragePeerClockSkew(33);
        if (Math.abs(skew) > 30000L) {
            return this._("ERR-Clock Skew of {0}", DataHelper.formatDuration(Math.abs(skew)));
        }
        if (this._context.router().isHidden()) {
            return this._("Hidden");
        }
        short status = this._context.commSystem().getReachabilityStatus();
        switch (status) {
            case 0: {
                RouterAddress ra = this._context.router().getRouterInfo().getTargetAddress("NTCP");
                if (ra == null || new NTCPAddress(ra).isPubliclyRoutable()) {
                    return this._("OK");
                }
                return this._("ERR-Private TCP Address");
            }
            case 1: {
                return this._("ERR-SymmetricNAT");
            }
            case 2: {
                if (this._context.router().getRouterInfo().getTargetAddress("NTCP") != null) {
                    return this._("WARN-Firewalled with Inbound TCP Enabled");
                }
                if (((FloodfillNetworkDatabaseFacade)this._context.netDb()).floodfillEnabled()) {
                    return this._("WARN-Firewalled and Floodfill");
                }
                if (this._context.router().getRouterInfo().getCapabilities().indexOf(79) >= 0) {
                    return this._("WARN-Firewalled and Fast");
                }
                return this._("Firewalled");
            }
            case 3: {
                return this._("ERR-UDP Port In Use - Set i2np.udp.internalPort=xxxx in advanced config and restart");
            }
        }
        RouterAddress ra = this._context.router().getRouterInfo().getTargetAddress("SSU");
        if (ra == null && this._context.router().getUptime() > 300000L) {
            if (this.getActivePeers() <= 0) {
                return this._("ERR-No Active Peers, Check Network Connection and Firewall");
            }
            if (this._context.getProperty("i2np.ntcp.hostname") == null || this._context.getProperty("i2np.ntcp.port") == null) {
                return this._("ERR-UDP Disabled and Inbound TCP host/port not set");
            }
            return this._("WARN-Firewalled with UDP Disabled");
        }
        return this._("Testing");
    }

    public int getActivePeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.commSystem().countActivePeers();
    }

    public boolean showFirewallWarning() {
        return this._context != null && this._context.netDb().isInitialized() && this._context.router().getUptime() > 120000L && this._context.commSystem().countActivePeers() <= 0 && this._context.netDb().getKnownRouters() > 5;
    }

    public int getActiveProfiles() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countActivePeers();
    }

    public int getFastPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countFastPeers();
    }

    public int getHighCapacityPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countHighCapacityPeers();
    }

    public int getWellIntegratedPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countWellIntegratedPeers();
    }

    public String getSecondKBps() {
        if (this._context == null) {
            return "0 / 0";
        }
        return SummaryHelper.formatPair(this._context.bandwidthLimiter().getReceiveBps(), this._context.bandwidthLimiter().getSendBps());
    }

    public String getFiveMinuteKBps() {
        Rate r;
        Rate r2;
        if (this._context == null) {
            return "0 / 0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.recvRate");
        double in = 0.0;
        if (receiveRate != null && (r2 = receiveRate.getRate(300000L)) != null) {
            in = r2.getAverageValue();
        }
        RateStat sendRate = this._context.statManager().getRate("bw.sendRate");
        double out = 0.0;
        if (sendRate != null && (r = sendRate.getRate(300000L)) != null) {
            out = r.getAverageValue();
        }
        return SummaryHelper.formatPair(in, out);
    }

    public String getLifetimeKBps() {
        if (this._context == null) {
            return "0 / 0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.recvRate");
        double in = receiveRate == null ? 0.0 : receiveRate.getLifetimeAverageValue();
        RateStat sendRate = this._context.statManager().getRate("bw.sendRate");
        double out = sendRate == null ? 0.0 : sendRate.getLifetimeAverageValue();
        return SummaryHelper.formatPair(in, out);
    }

    private static String formatPair(double in, double out) {
        boolean mega;
        boolean bl = mega = in >= 1048576.0 || out >= 1048576.0;
        if (mega) {
            in /= 1048576.0;
            out /= 1048576.0;
        } else {
            in /= 1024.0;
            out /= 1024.0;
        }
        DecimalFormat fmt = in >= 1000.0 || out >= 1000.0 ? new DecimalFormat("#0") : (in >= 100.0 || out >= 100.0 ? new DecimalFormat("#0.0") : new DecimalFormat("#0.00"));
        return fmt.format(in) + " / " + fmt.format(out) + (mega ? (char)'M' : 'K');
    }

    public String getInboundTransferred() {
        if (this._context == null) {
            return "0";
        }
        long received = this._context.bandwidthLimiter().getTotalAllocatedInboundBytes();
        return DataHelper.formatSize(received) + 'B';
    }

    public String getOutboundTransferred() {
        if (this._context == null) {
            return "0";
        }
        long sent = this._context.bandwidthLimiter().getTotalAllocatedOutboundBytes();
        return DataHelper.formatSize(sent) + 'B';
    }

    public String getDestinations() {
        ArrayList<Destination> clients = new ArrayList<Destination>(this._context.clientManager().listClients());
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/i2ptunnel/index.jsp\" target=\"_blank\" title=\"").append(this._("Add/remove/edit &amp; control your client and server tunnels")).append("\">").append(this._("Local Destinations")).append("</a></h3><hr><div class=\"tunnels\">");
        if (!clients.isEmpty()) {
            Collections.sort(clients, new AlphaComparator());
            buf.append("<table>");
            for (Destination client : clients) {
                String name = this.getName(client);
                Hash h = client.calculateHash();
                buf.append("<tr><td align=\"right\"><img src=\"/themes/console/images/");
                if (this._context.clientManager().shouldPublishLeaseSet(h)) {
                    buf.append("server.png\" alt=\"Server\" title=\"" + this._("Server") + "\">");
                } else {
                    buf.append("client.png\" alt=\"Client\" title=\"" + this._("Client") + "\">");
                }
                buf.append("</td><td align=\"left\"><b><a href=\"tunnels.jsp#").append(h.toBase64().substring(0, 4));
                buf.append("\" target=\"_top\" title=\"" + this._("Show tunnels") + "\">");
                if (name.length() < 16) {
                    buf.append(name);
                } else {
                    buf.append(name.substring(0, 15)).append("&hellip;");
                }
                buf.append("</a></b></td>\n");
                LeaseSet ls = this._context.netDb().lookupLeaseSetLocally(h);
                if (ls != null && this._context.tunnelManager().getOutboundClientTunnelCount(h) > 0) {
                    long timeToExpire = ls.getEarliestLeaseDate() - this._context.clock().now();
                    if (timeToExpire < 0L) {
                        buf.append("<td><img src=\"/themes/console/images/local_inprogress.png\" alt=\"").append(this._("Rebuilding")).append("&hellip;\" title=\"").append(this._("Leases expired")).append(" ").append(DataHelper.formatDuration(0L - timeToExpire));
                        buf.append(" ").append(this._("ago")).append(". ").append(this._("Rebuilding")).append("&hellip;\"></td></tr>\n");
                        continue;
                    }
                    buf.append("<td><img src=\"/themes/console/images/local_up.png\" alt=\"Ready\" title=\"").append(this._("Ready")).append("\"></td></tr>\n");
                    continue;
                }
                buf.append("<td><img src=\"/themes/console/images/local_inprogress.png\" alt=\"").append(this._("Building")).append("&hellip;\" title=\"").append(this._("Building tunnels")).append("&hellip;\"></td></tr>\n");
            }
            buf.append("</table>");
        } else {
            buf.append("<center><i>").append(this._("none")).append("</i></center>");
        }
        buf.append("</div><hr>\n");
        return buf.toString();
    }

    private String getName(Destination d) {
        String name;
        TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(d.calculateHash());
        String string = name = in != null ? in.getDestinationNickname() : null;
        if (name == null) {
            TunnelPoolSettings out = this._context.tunnelManager().getOutboundSettings(d.calculateHash());
            String string2 = name = out != null ? out.getDestinationNickname() : null;
            name = name == null ? d.calculateHash().toBase64().substring(0, 6) : this._(name);
        } else {
            name = this._(name);
        }
        return name;
    }

    public int getInboundTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getFreeTunnelCount();
    }

    public int getOutboundTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getOutboundTunnelCount();
    }

    public int getInboundClientTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getInboundClientTunnelCount();
    }

    public int getOutboundClientTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getOutboundClientTunnelCount();
    }

    public int getParticipatingTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getParticipatingCount();
    }

    public String getShareRatio() {
        if (this._context == null) {
            return "0";
        }
        double sr = this._context.tunnelManager().getShareRatio();
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(sr);
    }

    public String getJobLag() {
        if (this._context == null) {
            return "0ms";
        }
        Rate lagRate = this._context.statManager().getRate("jobQueue.jobLag").getRate(60000L);
        return (int)lagRate.getAverageValue() + "ms";
    }

    public String getMessageDelay() {
        if (this._context == null) {
            return "0ms";
        }
        return this._context.throttle().getMessageDelay() + "ms";
    }

    public String getTunnelLag() {
        if (this._context == null) {
            return "0ms";
        }
        return this._context.throttle().getTunnelLag() + "ms";
    }

    public String getTunnelStatus() {
        if (this._context == null) {
            return "";
        }
        return this._context.throttle().getTunnelStatus();
    }

    public String getInboundBacklog() {
        if (this._context == null) {
            return "0";
        }
        return String.valueOf(this._context.tunnelManager().getInboundBuildQueueSize());
    }

    public boolean updateAvailable() {
        return NewsFetcher.getInstance(this._context).updateAvailable();
    }

    public boolean unsignedUpdateAvailable() {
        return NewsFetcher.getInstance(this._context).unsignedUpdateAvailable();
    }

    public String getUpdateVersion() {
        return NewsFetcher.getInstance(this._context).updateVersion();
    }

    public String getUnsignedUpdateVersion() {
        return NewsFetcher.getInstance(this._context).unsignedUpdateVersion();
    }

    public void renderSummaryBar() throws IOException {
        SummaryBarRenderer renderer = new SummaryBarRenderer(this._context, this);
        renderer.renderSummaryHTML(this._out);
    }

    public void setAction(String s) {
        this._action = s;
    }

    public String getAction() {
        return this._action;
    }

    public void setConsoleNonce(String s) {
        this._consoleNonce = s;
    }

    public String getConsoleNonce() {
        return this._consoleNonce;
    }

    public void setUpdateNonce(String s) {
        this._updateNonce = s;
    }

    public String getUpdateNonce() {
        return this._updateNonce;
    }

    public void setRequestURI(String s) {
        this._requestURI = s;
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AlphaComparator
    implements Comparator<Destination> {
        private AlphaComparator() {
        }

        @Override
        public int compare(Destination lhs, Destination rhs) {
            String lname = SummaryHelper.this.getName(lhs);
            String rname = SummaryHelper.this.getName(rhs);
            String xsc = SummaryHelper.this._("shared clients");
            if (lname.equals(xsc)) {
                return -1;
            }
            if (rname.equals(xsc)) {
                return 1;
            }
            return Collator.getInstance().compare(lname, rname);
        }
    }
}

