/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigRestartBean;
import net.i2p.router.web.ContentHelper;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NavHelper;
import net.i2p.router.web.SummaryHelper;
import net.i2p.router.web.UpdateHandler;

public class SummaryBarRenderer {
    private RouterContext _context;
    private SummaryHelper _helper;

    public SummaryBarRenderer(RouterContext context, SummaryHelper helper) {
        this._context = context;
        this._helper = helper;
    }

    public void renderSummaryHTML(Writer out) throws IOException {
        String reseedErrorMessage;
        StringBuilder buf = new StringBuilder(8192);
        String theme = this._context.getProperty("routerconsole.theme", "light");
        buf.append("<a href=\"/index.jsp\" target=\"_top\"><img src=\"").append("/themes/console/").append(theme).append("/images/i2plogo.png\" alt=\"").append(this._("I2P Router Console")).append("\" title=\"").append(this._("I2P Router Console")).append("\"></a><hr>").append("<h3><a href=\"/help.jsp\" target=\"_top\" title=\"").append(this._("I2P Router Help &amp; FAQ")).append("\">").append(this._("Help &amp; FAQ")).append("</a></h3><hr>");
        File lpath = new File(this._context.getBaseDir(), "docs/toolbar.html");
        if (lpath.exists()) {
            ContentHelper linkhelper = new ContentHelper();
            linkhelper.setPage(lpath.getAbsolutePath());
            linkhelper.setMaxLines("100");
            buf.append(linkhelper.getContent());
        } else {
            buf.append("<h3><a href=\"/configclients.jsp\" target=\"_top\" title=\"").append(this._("Configure startup of clients and webapps (services); manually start dormant services")).append("\">").append(this._("I2P Services")).append("</a></h3>\n<hr><table><tr><td><a href=\"/susidns/index.jsp\" target=\"_blank\" title=\"").append(this._("Manage your I2P hosts file here (I2P domain name resolution)")).append("\">").append(this._("Addressbook")).append("</a>\n<a href=\"/i2psnark/\" target=\"_blank\" title=\"").append(this._("Built-in anonymous BitTorrent Client")).append("\">").append(this._("Torrents")).append("</a>\n<a href=\"/susimail/susimail\" target=\"blank\" title=\"").append(this._("Anonymous webmail client")).append("\">").append(this._("Webmail")).append("</a>\n<a href=\"http://127.0.0.1:7658/\" target=\"_blank\" title=\"").append(this._("Anonymous resident webserver")).append("\">").append(this._("Webserver")).append("</a>").append(NavHelper.getClientAppLinks(this._context)).append("</td></tr></table>\n<hr><h3><a href=\"/config.jsp\" target=\"_top\" title=\"").append(this._("Configure I2P Router")).append("\">").append(this._("I2P Internals")).append("</a></h3><hr>\n<table><tr><td>\n<a href=\"/tunnels.jsp\" target=\"_top\" title=\"").append(this._("View existing tunnels and tunnel build status")).append("\">").append(this._("Tunnels")).append("</a>\n<a href=\"/peers.jsp\" target=\"_top\" title=\"").append(this._("Show all current peer connections")).append("\">").append(this._("Peers")).append("</a>\n<a href=\"/profiles.jsp\" target=\"_top\" title=\"").append(this._("Show recent peer performance profiles")).append("\">").append(this._("Profiles")).append("</a>\n<a href=\"/netdb.jsp\" target=\"_top\" title=\"").append(this._("Show list of all known I2P routers")).append("\">").append(this._("NetDB")).append("</a>\n<a href=\"/logs.jsp\" target=\"_top\" title=\"").append(this._("Health Report")).append("\">").append(this._("Logs")).append("</a>\n<a href=\"/graphs.jsp\" target=\"_top\" title=\"").append(this._("Graph router performance")).append("\">").append(this._("Graphs")).append("</a>\n<a href=\"/stats.jsp\" target=\"_top\" title=\"").append(this._("Textual router performance statistics")).append("\">").append(this._("Stats")).append("</a>\n<a href=\"/i2ptunnel/index.jsp\" target=\"_blank\" title=\"").append(this._("Local Destinations")).append("\">").append(this._("I2PTunnel")).append("</a></td></tr></table>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        buf.append("<hr><h3><a href=\"/help.jsp\" target=\"_top\" title=\"").append(this._("I2P Router Help")).append("\">").append(this._("General")).append("</a></h3><hr>\n<table><tr><td align=\"left\"><b>").append(this._("Local Identity")).append(":</b></td><td align=\"right\"><a title=\"").append(this._("Your unique I2P router identity is")).append(' ').append(this._helper.getIdent()).append(", ").append(this._("never reveal it to anyone")).append("\" href=\"/netdb.jsp?r=.\" target=\"_top\">").append(this._("show")).append("</a></td></tr>\n<tr><td align=\"left\"><b>").append(this._("Version")).append(":</b></td><td align=\"right\">").append(this._helper.getVersion()).append("</td></tr>\n<tr title=\"").append(this._("How long we've been running for this session")).append("\"><td align=\"left\"><b>").append(this._("Uptime")).append(":</b></td><td align=\"right\">").append(this._helper.getUptime()).append("</td></tr></table>\n<hr><h4><a href=\"/config.jsp#help\" target=\"_top\" title=\"").append(this._("Help with configuring your firewall and router for optimal I2P performance")).append("\">").append(this._("Network")).append(": ").append(this._helper.getReachability()).append("</a></h4><hr>\n");
        buf.append(UpdateHandler.getStatus());
        if ((this._helper.updateAvailable() || this._helper.unsignedUpdateAvailable()) && !"true".equals(System.getProperty("net.i2p.router.web.UpdateHandler.updateInProgress")) && this._helper.getAction() == null && this._helper.getUpdateNonce() == null && ConfigRestartBean.getRestartTimeRemaining() > 720000L) {
            long nonce = this._context.random().nextLong();
            String prev = System.getProperty("net.i2p.router.web.UpdateHandler.nonce");
            if (prev != null) {
                System.setProperty("net.i2p.router.web.UpdateHandler.noncePrev", prev);
            }
            System.setProperty("net.i2p.router.web.UpdateHandler.nonce", nonce + "");
            String uri = this._helper.getRequestURI();
            buf.append("<p><form action=\"").append(uri).append("\" method=\"GET\">\n");
            buf.append("<input type=\"hidden\" name=\"updateNonce\" value=\"").append(nonce).append("\" >\n");
            if (this._helper.updateAvailable()) {
                buf.append("<button type=\"submit\" name=\"updateAction\" value=\"signed\" >").append(this._("Download")).append(' ').append(this._helper.getUpdateVersion()).append(' ').append(this._("Update")).append("</button>\n");
            }
            if (this._helper.unsignedUpdateAvailable()) {
                buf.append("<button type=\"submit\" name=\"updateAction\" value=\"Unsigned\" >").append(this._("Download Unsigned")).append("<br>").append(this._("Update")).append(' ').append(this._helper.getUnsignedUpdateVersion()).append("</button>\n");
            }
            buf.append("</form>\n");
        }
        buf.append("<p>").append(ConfigRestartBean.renderStatus(this._helper.getRequestURI(), this._helper.getAction(), this._helper.getConsoleNonce())).append("</p><hr><h3><a href=\"/peers.jsp\" target=\"_top\" title=\"").append(this._("Show all current peer connections")).append("\">").append(this._("Peers")).append("</a></h3><hr>\n<table>\n<tr><td align=\"left\"><b>").append(this._("Active")).append(":</b></td><td align=\"right\">").append(this._helper.getActivePeers()).append(" / ").append(this._helper.getActiveProfiles()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("Fast")).append(":</b></td><td align=\"right\">").append(this._helper.getFastPeers()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("High capacity")).append(":</b></td><td align=\"right\">").append(this._helper.getHighCapacityPeers()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("Integrated")).append(":</b></td><td align=\"right\">").append(this._helper.getWellIntegratedPeers()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("Known")).append(":</b></td><td align=\"right\">").append(this._helper.getAllPeers()).append("</td></tr>\n</table><hr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        boolean anotherLine = false;
        if (this._helper.showFirewallWarning()) {
            buf.append("<h4><a href=\"/config.jsp\" target=\"_top\" title=\"").append(this._("Help with firewall configuration")).append("\">").append(this._("Check NAT/firewall")).append("</a></h4>");
            anotherLine = true;
        }
        boolean reseedInProgress = Boolean.valueOf(System.getProperty("net.i2p.router.web.ReseedHandler.reseedInProgress"));
        if (this._helper.allowReseed()) {
            if (reseedInProgress) {
                buf.append("<i>").append(System.getProperty("net.i2p.router.web.ReseedHandler.statusMessage", "")).append("</i><br>");
            } else {
                long nonce = this._context.random().nextLong();
                String prev = System.getProperty("net.i2p.router.web.ReseedHandler.nonce");
                if (prev != null) {
                    System.setProperty("net.i2p.router.web.ReseedHandler.noncePrev", prev);
                }
                System.setProperty("net.i2p.router.web.ReseedHandler.nonce", nonce + "");
                String uri = this._helper.getRequestURI();
                buf.append("<p><form action=\"").append(uri).append("\" method=\"GET\">\n");
                buf.append("<input type=\"hidden\" name=\"reseedNonce\" value=\"").append(nonce).append("\" >\n");
                buf.append("<button type=\"submit\" value=\"Reseed\" >").append(this._("Reseed")).append("</button></form></p>\n");
            }
            anotherLine = true;
        }
        if (!reseedInProgress && (reseedErrorMessage = System.getProperty("net.i2p.router.web.ReseedHandler.errorMessage", "")).length() > 0) {
            buf.append("<i>").append(reseedErrorMessage).append("</i><br>");
            anotherLine = true;
        }
        if (anotherLine) {
            buf.append("<hr>");
        }
        buf.append("<h3><a href=\"/config.jsp\" title=\"").append(this._("Configure router bandwidth allocation")).append("\" target=\"_top\">").append(this._("Bandwidth in/out")).append("</a></h3><hr><table>\n<tr><td align=\"left\"><b>1s:</b></td><td align=\"right\">").append(this._helper.getSecondKBps()).append("Bps</td></tr>\n");
        if (this._context.router().getUptime() > 360000L) {
            buf.append("<tr><td align=\"left\"><b>5m:</b></td><td align=\"right\">").append(this._helper.getFiveMinuteKBps()).append("Bps</td></tr>\n");
        }
        if (this._context.router().getUptime() > 120000L) {
            buf.append("<tr><td align=\"left\"><b>").append(this._("Total")).append(":</b></td><td align=\"right\">").append(this._helper.getLifetimeKBps()).append("Bps</td></tr>\n");
        }
        buf.append("<tr><td align=\"left\"><b>").append(this._("Used")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundTransferred()).append(" / ").append(this._helper.getOutboundTransferred()).append("</td></tr></table>\n<hr><h3><a href=\"/tunnels.jsp\" target=\"_top\" title=\"").append(this._("View existing tunnels and tunnel build status")).append("\">").append(this._("Tunnels")).append("</a></h3><hr><table>\n<tr><td align=\"left\"><b>").append(this._("Exploratory")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundTunnels() + this._helper.getOutboundTunnels()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("Client")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundClientTunnels() + this._helper.getOutboundClientTunnels()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("Participating")).append(":</b></td><td align=\"right\">").append(this._helper.getParticipatingTunnels()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("Share ratio")).append(":</b></td><td align=\"right\">").append(this._helper.getShareRatio()).append("</td></tr>\n</table><hr><h3><a href=\"/jobs.jsp\" target=\"_top\" title=\"").append(this._("What's in the router's job queue?")).append("\">").append(this._("Congestion")).append("</a></h3><hr><table>\n<tr><td align=\"left\"><b>").append(this._("Job lag")).append(":</b></td><td align=\"right\">").append(this._helper.getJobLag()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("Message delay")).append(":</b></td><td align=\"right\">").append(this._helper.getMessageDelay()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("Tunnel lag")).append(":</b></td><td align=\"right\">").append(this._helper.getTunnelLag()).append("</td></tr>\n<tr><td align=\"left\"><b>").append(this._("Backlog")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundBacklog()).append("</td></tr>\n</table><hr><h4>").append(this._(this._helper.getTunnelStatus())).append("</h4><hr>\n").append(this._helper.getDestinations());
        out.write(buf.toString());
    }

    private String _(String s) {
        return Messages.getString(s, this._context);
    }
}

