/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.stat.Frequency;
import net.i2p.stat.FrequencyStat;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class StatsGenerator {
    private Log _log;
    private RouterContext _context;
    private static final DecimalFormat _fmt = new DecimalFormat("###,##0.00");
    private static final DecimalFormat _pct = new DecimalFormat("#0.00%");

    public StatsGenerator(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(StatsGenerator.class);
    }

    public void generateStatsPage(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(16384);
        buf.append("<div class=\"joblog\"><form action=\"/stats.jsp\">");
        buf.append("<select name=\"go\" onChange='location.href=this.value'>");
        out.write(buf.toString());
        buf.setLength(0);
        Map groups = this._context.statManager().getStatsByGroup();
        for (Map.Entry entry : groups.entrySet()) {
            String group = (String)entry.getKey();
            buf.append("<option value=\"/stats.jsp#").append(group).append("\">");
            buf.append(this._(group)).append("</option>\n");
        }
        buf.append("</select> <input type=\"submit\" value=\"").append(this._("GO")).append("\" />");
        buf.append("</form>");
        buf.append(this._("Statistics gathered during this router's uptime")).append(" (");
        long uptime = this._context.router().getUptime();
        buf.append(DataHelper.formatDuration(uptime));
        buf.append(").  ").append(this._("The data gathered is quantized over a 1 minute period, so should just be used as an estimate."));
        out.write(buf.toString());
        buf.setLength(0);
        for (String group : groups.keySet()) {
            Set stats = (Set)groups.get(group);
            buf.append("<h3><a name=\"");
            buf.append(group);
            buf.append("\">");
            buf.append(this._(group));
            buf.append("</a></h3>");
            buf.append("<ul>");
            out.write(buf.toString());
            buf.setLength(0);
            for (String stat : stats) {
                buf.append("<li><b><a name=\"");
                buf.append(stat);
                buf.append("\">");
                buf.append(stat);
                buf.append("</a></b><br>");
                if (this._context.statManager().isFrequency(stat)) {
                    this.renderFrequency(stat, buf);
                } else {
                    this.renderRate(stat, buf);
                }
                out.write(buf.toString());
                buf.setLength(0);
            }
            out.write("</ul><br>\n");
        }
        out.flush();
    }

    private void renderFrequency(String name, StringBuilder buf) {
        FrequencyStat freq = this._context.statManager().getFrequency(name);
        buf.append("<i>");
        buf.append(freq.getDescription());
        buf.append("</i><br>");
        long uptime = this._context.router().getUptime();
        long[] periods = freq.getPeriods();
        Arrays.sort(periods);
        for (int i = 0; i < periods.length && periods[i] <= uptime; ++i) {
            StatsGenerator.renderPeriod(buf, periods[i], this._("frequency"));
            Frequency curFreq = freq.getFrequency(periods[i]);
            buf.append(" <i>avg per period:</i> (");
            buf.append(StatsGenerator.num(curFreq.getAverageEventsPerPeriod()));
            buf.append(", max ");
            buf.append(StatsGenerator.num(curFreq.getMaxAverageEventsPerPeriod()));
            if (curFreq.getMaxAverageEventsPerPeriod() > 0.0 && curFreq.getAverageEventsPerPeriod() > 0.0) {
                buf.append(", current is ");
                buf.append(StatsGenerator.pct(curFreq.getAverageEventsPerPeriod() / curFreq.getMaxAverageEventsPerPeriod()));
                buf.append(" of max");
            }
            buf.append(")");
            buf.append(" <i>strict average per period:</i> ");
            buf.append(StatsGenerator.num(curFreq.getStrictAverageEventsPerPeriod()));
            buf.append(" events (averaged ");
            buf.append(" using the lifetime of ");
            buf.append(curFreq.getEventCount());
            buf.append(" events)");
            buf.append("<br>\n");
        }
        buf.append("<br>\n");
    }

    private void renderRate(String name, StringBuilder buf) {
        Rate curRate;
        RateStat rate = this._context.statManager().getRate(name);
        String d = rate.getDescription();
        if (!"".equals(d)) {
            buf.append("<i>");
            buf.append(d);
            buf.append("</i><br>");
        }
        if (rate.getLifetimeEventCount() <= 0L) {
            buf.append(this._("No lifetime events")).append("<br>\n");
            return;
        }
        long now = this._context.clock().now();
        long[] periods = rate.getPeriods();
        Arrays.sort(periods);
        buf.append("<ul>");
        for (int i = 0; i < periods.length && (curRate = rate.getRate(periods[i])).getLastCoalesceDate() > curRate.getCreationDate(); ++i) {
            buf.append("<li>");
            StatsGenerator.renderPeriod(buf, periods[i], this._("rate"));
            if (curRate.getLastEventCount() > 0L) {
                buf.append("<i>").append(this._("avg value")).append(":</i> (");
                buf.append(StatsGenerator.num(curRate.getAverageValue()));
                buf.append(" peak ");
                buf.append(StatsGenerator.num(curRate.getExtremeAverageValue()));
                buf.append(", [");
                buf.append(StatsGenerator.pct(curRate.getPercentageOfExtremeValue()));
                buf.append(" of max");
                buf.append(", and ");
                buf.append(StatsGenerator.pct(curRate.getPercentageOfLifetimeValue()));
                buf.append(" of lifetime average]");
                buf.append(")");
                buf.append(" <i>highest total period value:</i> (");
                buf.append(StatsGenerator.num(curRate.getExtremeTotalValue()));
                buf.append(")");
                if (curRate.getLifetimeTotalEventTime() > 0L) {
                    buf.append(" <i>saturation:</i> (");
                    buf.append(StatsGenerator.pct(curRate.getLastEventSaturation()));
                    buf.append(")");
                    buf.append(" <i>saturated limit:</i> (");
                    buf.append(StatsGenerator.num(curRate.getLastSaturationLimit()));
                    buf.append(")");
                    buf.append(" <i>peak saturation:</i> (");
                    buf.append(StatsGenerator.pct(curRate.getExtremeEventSaturation()));
                    buf.append(")");
                    buf.append(" <i>peak saturated limit:</i> (");
                    buf.append(StatsGenerator.num(curRate.getExtremeSaturationLimit()));
                    buf.append(")");
                }
                buf.append(" <i>").append(this._("events")).append(":</i> ");
                buf.append(curRate.getLastEventCount());
                buf.append(" <i>in this period which ended:</i> ");
                buf.append(DataHelper.formatDuration(now - curRate.getLastCoalesceDate()));
                buf.append(" ago ");
            } else {
                buf.append(" <i>").append(this._("No events")).append("</i> ");
            }
            long numPeriods = curRate.getLifetimePeriods();
            if (numPeriods > 0L) {
                double avgFrequency = (double)curRate.getLifetimeEventCount() / (double)numPeriods;
                double peakFrequency = curRate.getExtremeEventCount();
                buf.append(" (").append(this._("lifetime average")).append(": ");
                buf.append(StatsGenerator.num(avgFrequency));
                buf.append(", ").append(this._("peak average")).append(": ");
                buf.append(curRate.getExtremeEventCount());
                buf.append(")");
            }
            if (curRate.getSummaryListener() != null) {
                buf.append(" <a href=\"viewstat.jsp?stat=").append(name);
                buf.append("&amp;period=").append(periods[i]);
                buf.append("\" title=\"Render summarized data\">render</a>");
                buf.append(" <a href=\"viewstat.jsp?stat=").append(name);
                buf.append("&amp;period=").append(periods[i]).append("&amp;showEvents=true\" title=\"Render summarized event counts\">events</a>");
                buf.append(" (as <a href=\"viewstat.jsp?stat=").append(name);
                buf.append("&amp;period=").append(periods[i]);
                buf.append("&amp;format=xml\" title=\"Dump stat history as XML\">XML</a>");
                buf.append(" in a format <a href=\"http://people.ee.ethz.ch/~oetiker/webtools/rrdtool\">RRDTool</a> understands)");
            }
            buf.append("</li>\n");
        }
        buf.append("<li><b>").append(this._("lifetime average value")).append(":</b> ");
        buf.append(StatsGenerator.num(rate.getLifetimeAverageValue()));
        buf.append(" over ");
        buf.append(rate.getLifetimeEventCount());
        buf.append(" events<br></li>");
        buf.append("</ul>");
        buf.append("<br>\n");
    }

    private static void renderPeriod(StringBuilder buf, long period, String name) {
        buf.append("<b>");
        buf.append(DataHelper.formatDuration(period));
        buf.append(" ");
        buf.append(name);
        buf.append(":</b> ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double num) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String pct(double num) {
        DecimalFormat decimalFormat = _pct;
        synchronized (decimalFormat) {
            return _pct.format(num);
        }
    }

    private String _(String s) {
        return Messages.getString(s, this._context);
    }

    private String _(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }
}

