/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.Shitlist;
import net.i2p.router.web.Messages;

public class ShitlistRenderer {
    private RouterContext _context;

    public ShitlistRenderer(RouterContext context) {
        this._context = context;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        TreeMap<Hash, Shitlist.Entry> entries = new TreeMap<Hash, Shitlist.Entry>(new HashComparator());
        entries.putAll(this._context.shitlist().getEntries());
        buf.append("<ul>");
        for (Map.Entry e : entries.entrySet()) {
            Hash key = (Hash)e.getKey();
            Shitlist.Entry entry = (Shitlist.Entry)e.getValue();
            buf.append("<li>").append(this._context.commSystem().renderPeerHTML(key));
            buf.append(' ');
            long expires = entry.expireOn - this._context.clock().now();
            String expireString = DataHelper.formatDuration(expires);
            if (expires < 432000000L) {
                buf.append(this._("Temporary ban expiring in {0}", expireString));
            } else {
                buf.append(this._("Banned until restart or in {0}", expireString));
            }
            Set<String> transports = entry.transports;
            if (transports != null && !transports.isEmpty()) {
                buf.append(" on the following transport: ").append(transports);
            }
            if (entry.cause != null) {
                buf.append("<br>\n");
                if (entry.causeCode != null) {
                    buf.append(this._(entry.cause, entry.causeCode));
                } else {
                    buf.append(this._(entry.cause));
                }
            }
            buf.append(" (<a href=\"configpeer.jsp?peer=").append(key.toBase64()).append("#unsh\">").append(this._("unban now")).append("</a>)");
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        out.write(buf.toString());
        out.flush();
    }

    private String _(String s) {
        return Messages.getString(s, this._context);
    }

    private String _(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    private static class HashComparator
    implements Comparator {
        private HashComparator() {
        }

        public int compare(Object l, Object r) {
            return ((Hash)l).toBase64().compareTo(((Hash)r).toBase64());
        }
    }
}

