/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.apps.systray.SysTray;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.LocaleWebAppHandler;
import net.i2p.router.web.NewsFetcher;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.PluginStopper;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.WebAppStarter;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.SecureDirectory;
import org.mortbay.http.Authenticator;
import org.mortbay.http.DigestAuthenticator;
import org.mortbay.http.HashUserRealm;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserRealm;
import org.mortbay.http.handler.SecurityHandler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;

public class RouterConsoleRunner {
    private Server _server;
    private String _listenPort = "7657";
    private String _listenHost = "127.0.0.1";
    private String _webAppsDir = "./webapps/";
    private static final String PROP_WEBAPP_CONFIG_FILENAME = "router.webappsConfigFile";
    private static final String DEFAULT_WEBAPP_CONFIG_FILENAME = "webapps.config";
    private static final DigestAuthenticator authenticator = new DigestAuthenticator();
    public static final String ROUTERCONSOLE = "routerconsole";
    public static final String PREFIX = "webapps.";
    public static final String ENABLED = ".startOnLoad";

    public RouterConsoleRunner(String[] args) {
        if (args.length == 3) {
            this._listenPort = args[0].trim();
            this._listenHost = args[1].trim();
            this._webAppsDir = args[2].trim();
        }
    }

    public static void main(String[] args) {
        RouterConsoleRunner runner = new RouterConsoleRunner(args);
        runner.startConsole();
    }

    public void startConsole() {
        RouterContext ctx;
        File app;
        boolean workDirCreated;
        SecureDirectory workDir = new SecureDirectory(I2PAppContext.getGlobalContext().getTempDir(), "jetty-work");
        boolean workDirRemoved = FileUtil.rmdir(workDir, false);
        if (!workDirRemoved) {
            System.err.println("ERROR: Unable to remove Jetty temporary work directory");
        }
        if (!(workDirCreated = ((File)workDir).mkdirs())) {
            System.err.println("ERROR: Unable to create Jetty temporary work directory");
        }
        System.setProperty("jetty.class.path", I2PAppContext.getGlobalContext().getBaseDir() + "/lib/routerconsole.jar");
        this._server = new Server();
        boolean rewrite = false;
        Properties props = RouterConsoleRunner.webAppProperties();
        if (props.isEmpty()) {
            props.setProperty("webapps.routerconsole.startOnLoad", "true");
            rewrite = true;
        }
        if (!(app = new File(this._webAppsDir)).isAbsolute()) {
            app = new File(I2PAppContext.getGlobalContext().getBaseDir(), this._webAppsDir);
            try {
                this._webAppsDir = app.getCanonicalPath();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (!this._webAppsDir.endsWith("/")) {
            this._webAppsDir = this._webAppsDir + '/';
        }
        ArrayList<String> notStarted = new ArrayList<String>();
        LocaleWebAppHandler baseHandler = null;
        try {
            StringTokenizer tok = new StringTokenizer(this._listenHost, " ,");
            int boundAddresses = 0;
            while (tok.hasMoreTokens()) {
                String host = tok.nextToken().trim();
                try {
                    if (host.indexOf(":") >= 0) {
                        this._server.addListener('[' + host + "]:" + this._listenPort);
                    } else {
                        this._server.addListener(host + ':' + this._listenPort);
                    }
                    ++boundAddresses;
                }
                catch (IOException ioe) {
                    System.err.println("Unable to bind routerconsole to " + host + " port " + this._listenPort + ' ' + ioe);
                }
            }
            if (boundAddresses <= 0) {
                System.err.println("Unable to bind routerconsole to any address on port " + this._listenPort);
                return;
            }
            this._server.setRootWebApp(ROUTERCONSOLE);
            WebApplicationContext wac = this._server.addWebApplication("/", this._webAppsDir + ROUTERCONSOLE + ".war");
            SecureDirectory tmpdir = new SecureDirectory(workDir, "routerconsole-" + this._listenPort);
            ((File)tmpdir).mkdir();
            wac.setTempDirectory((File)tmpdir);
            baseHandler = new LocaleWebAppHandler(I2PAppContext.getGlobalContext());
            wac.addHandler(0, (HttpHandler)baseHandler);
            RouterConsoleRunner.initialize(wac);
            File dir = new File(this._webAppsDir);
            String[] fileNames = dir.list(WarFilenameFilter.instance());
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    try {
                        String appName = fileNames[i].substring(0, fileNames[i].lastIndexOf(".war"));
                        String enabled = props.getProperty(PREFIX + appName + ENABLED);
                        if (!"false".equals(enabled)) {
                            String path = new File(dir, fileNames[i]).getCanonicalPath();
                            tmpdir = new SecureDirectory(workDir, appName + "-" + this._listenPort);
                            WebAppStarter.addWebApp(I2PAppContext.getGlobalContext(), this._server, appName, path, tmpdir);
                            if (enabled != null) continue;
                            props.setProperty(PREFIX + appName + ENABLED, "true");
                            rewrite = true;
                            continue;
                        }
                        notStarted.add(appName);
                        continue;
                    }
                    catch (IOException ioe) {
                        System.err.println("Error resolving '" + fileNames[i] + "' in '" + dir);
                    }
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (rewrite) {
            RouterConsoleRunner.storeWebAppProperties(props);
        }
        try {
            this._server.start();
        }
        catch (Throwable me) {
            System.err.println("WARNING: Error starting one or more listeners of the Router Console server.\nIf your console is still accessible at http://127.0.0.1:7657/,\nthis may be a problem only with binding to the IPV6 address ::1.\nIf so, you may ignore this error, or remove the\n\"::1,\" in the \"clientApp.0.args\" line of the clients.config file.\nException: " + me);
            me.printStackTrace();
        }
        if (baseHandler != null) {
            for (int i = 0; i < notStarted.size(); ++i) {
                try {
                    baseHandler.mapPathToServlet('/' + (String)notStarted.get(i) + "/*", "net.i2p.router.web.jsp.nowebapp_jsp");
                    continue;
                }
                catch (Throwable me) {
                    System.err.println(me);
                }
            }
        }
        try {
            SysTray tray = SysTray.getInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        NewsFetcher fetcher = NewsFetcher.getInstance(I2PAppContext.getGlobalContext());
        I2PAppThread t = new I2PAppThread(fetcher, "NewsFetcher", true);
        t.start();
        t = new I2PAppThread(new StatSummarizer(), "StatSummarizer", true);
        t.start();
        List<RouterContext> contexts = RouterContext.listContexts();
        if (contexts != null && PluginStarter.pluginsEnabled(ctx = contexts.get(0))) {
            t = new I2PAppThread(new PluginStarter(ctx), "PluginStarter", true);
            t.start();
            ctx.addShutdownTask(new PluginStopper(ctx));
        }
    }

    static void initialize(WebApplicationContext context) {
        String password = RouterConsoleRunner.getPassword();
        if (password != null) {
            HashUserRealm realm = new HashUserRealm("i2prouter");
            realm.put((Object)"admin", (Object)password);
            realm.addUserToRole("admin", "routerAdmin");
            context.setRealm((UserRealm)realm);
            context.setAuthenticator((Authenticator)authenticator);
            context.addHandler(0, (HttpHandler)new SecurityHandler());
            SecurityConstraint constraint = new SecurityConstraint("admin", "routerAdmin");
            constraint.setAuthenticate(true);
            context.addSecurityConstraint("/", constraint);
        }
        SecurityConstraint sc = new SecurityConstraint();
        sc.setName("No trace or options");
        sc.addMethod("TRACE");
        sc.addMethod("OPTIONS");
        sc.setAuthenticate(true);
        context.addSecurityConstraint("/*", sc);
    }

    static String getPassword() {
        List<RouterContext> contexts = RouterContext.listContexts();
        if (contexts != null) {
            for (int i = 0; i < contexts.size(); ++i) {
                RouterContext ctx = contexts.get(i);
                String password = ctx.getProperty("consolePassword");
                if (password == null || (password = password.trim()).length() <= 0) continue;
                return password;
            }
            return null;
        }
        return null;
    }

    public static Properties webAppProperties() {
        return RouterConsoleRunner.webAppProperties(I2PAppContext.getGlobalContext().getConfigDir().getAbsolutePath());
    }

    public static Properties webAppProperties(String dir) {
        Properties rv = new Properties();
        String webappConfigFile = DEFAULT_WEBAPP_CONFIG_FILENAME;
        File cfgFile = new File(dir, webappConfigFile);
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return rv;
    }

    public static void storeWebAppProperties(Properties props) {
        String webappConfigFile = DEFAULT_WEBAPP_CONFIG_FILENAME;
        File cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), webappConfigFile);
        try {
            DataHelper.storeProps(props, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        System.setProperty("org.mortbay.http.Version.paranoid", "true");
        System.setProperty("java.awt.headless", "true");
    }

    static class WarFilenameFilter
    implements FilenameFilter {
        private static final WarFilenameFilter _filter = new WarFilenameFilter();

        WarFilenameFilter() {
        }

        public static WarFilenameFilter instance() {
            return _filter;
        }

        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".war") && !name.equals("routerconsole.war");
        }
    }
}

