/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

class ProfileOrganizerRenderer {
    private RouterContext _context;
    private ProfileOrganizer _organizer;
    private ProfileComparator _comparator;
    private static final DecimalFormat _fmt = new DecimalFormat("###,##0.00");
    private static final String NA = HelperBase._x("n/a");

    public ProfileOrganizerRenderer(ProfileOrganizer organizer, RouterContext context) {
        this._context = context;
        this._organizer = organizer;
        this._comparator = new ProfileComparator();
    }

    public void renderStatusHTML(Writer out, boolean full) throws IOException {
        Hash peer;
        Set<Hash> peers = this._organizer.selectAllPeers();
        long now = this._context.clock().now();
        long hideBefore = now - 5400000L;
        TreeSet<PeerProfile> order = new TreeSet<PeerProfile>(this._comparator);
        TreeSet<PeerProfile> integratedPeers = new TreeSet<PeerProfile>(this._comparator);
        int older = 0;
        int standard = 0;
        for (Hash peer2 : peers) {
            if (this._organizer.getUs().equals(peer2)) continue;
            PeerProfile prof = this._organizer.getProfile(peer2);
            RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer2);
            if (info != null && info.getCapabilities().indexOf("f") >= 0) {
                integratedPeers.add(prof);
            }
            if (prof.getLastSendSuccessful() <= hideBefore) {
                ++older;
                continue;
            }
            if (!full && !this._organizer.isHighCapacity(peer2)) {
                ++standard;
                continue;
            }
            order.add(prof);
        }
        int fast = 0;
        int reliable = 0;
        int integrated = 0;
        int failing = 0;
        StringBuilder buf = new StringBuilder(16384);
        buf.append("<h2>").append(this._("Peer Profiles")).append("</h2>\n<p>");
        buf.append(this._("Showing {0} recent profiles.", order.size())).append('\n');
        if (older > 0) {
            buf.append(this._("Hiding {0} older profiles.", older)).append('\n');
        }
        if (standard > 0) {
            buf.append("<a href=\"/profiles.jsp?f=1\">").append(this._("Hiding {0} standard profiles.", standard)).append("</a>\n");
        }
        buf.append("</p>");
        buf.append("<table>");
        buf.append("<tr>");
        buf.append("<th>").append(this._("Peer")).append("</th>");
        buf.append("<th>").append(this._("Groups (Caps)")).append("</th>");
        buf.append("<th>").append(this._("Speed")).append("</th>");
        buf.append("<th>").append(this._("Capacity")).append("</th>");
        buf.append("<th>").append(this._("Integration")).append("</th>");
        buf.append("<th>").append(this._("Status")).append("</th>");
        buf.append("<th>&nbsp;</th>");
        buf.append("</tr>");
        int prevTier = 1;
        for (PeerProfile prof : order) {
            Rate accepted;
            long total;
            Rate failed;
            long fails;
            RouterInfo info;
            peer = prof.getPeer();
            int tier = 0;
            boolean isIntegrated = false;
            if (this._organizer.isFast(peer)) {
                tier = 1;
                ++fast;
                ++reliable;
            } else if (this._organizer.isHighCapacity(peer)) {
                tier = 2;
                ++reliable;
            } else if (this._organizer.isFailing(peer)) {
                ++failing;
            } else {
                tier = 3;
            }
            if (this._organizer.isWellIntegrated(peer)) {
                isIntegrated = true;
                ++integrated;
            }
            if (tier != prevTier) {
                buf.append("<tr><td colspan=\"7\"><hr></td></tr>\n");
            }
            prevTier = tier;
            buf.append("<tr><td align=\"center\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(peer));
            buf.append("</td><td align=\"center\">");
            switch (tier) {
                case 1: {
                    buf.append(this._("Fast, High Capacity"));
                    break;
                }
                case 2: {
                    buf.append(this._("High Capacity"));
                    break;
                }
                case 3: {
                    buf.append(this._("Standard"));
                    break;
                }
                default: {
                    buf.append(this._("Failing"));
                }
            }
            if (isIntegrated) {
                buf.append(", ").append(this._("Integrated"));
            }
            if ((info = this._context.netDb().lookupRouterInfoLocally(peer)) != null) {
                buf.append(" (").append(DataHelper.stripHTML(info.getCapabilities()));
                String v = info.getOption("router.version");
                if (v != null) {
                    buf.append(' ').append(DataHelper.stripHTML(v));
                }
                buf.append(')');
            }
            buf.append("<td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getSpeedValue()));
            long bonus = prof.getSpeedBonus();
            if (bonus != 0L) {
                if (bonus > 0L) {
                    buf.append(" (+");
                } else {
                    buf.append(" (");
                }
                buf.append(bonus).append(')');
            }
            buf.append("</td><td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getCapacityValue()));
            bonus = prof.getCapacityBonus();
            if (bonus != 0L) {
                if (bonus > 0L) {
                    buf.append(" (+");
                } else {
                    buf.append(" (");
                }
                buf.append(bonus).append(')');
            }
            buf.append("</td><td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getIntegrationValue()));
            buf.append("</td><td align=\"center\">");
            if (this._context.shitlist().isShitlisted(peer)) {
                buf.append(this._("Banned"));
            }
            if (prof.getIsFailing()) {
                buf.append(' ').append(this._("Failing"));
            }
            if (this._context.commSystem().wasUnreachable(peer)) {
                buf.append(' ').append(this._("Unreachable"));
            }
            if ((fails = (failed = prof.getTunnelHistory().getFailedRate().getRate(1800000L)).getCurrentEventCount() + failed.getLastEventCount()) > 0L && (total = fails + (accepted = prof.getTunnelCreateResponseTime().getRate(1800000L)).getCurrentEventCount() + accepted.getLastEventCount()) / fails <= 10L) {
                buf.append(' ').append(fails).append('/').append(total).append(' ').append(this._("Test Fails"));
            }
            buf.append("&nbsp;</td>");
            buf.append("<td nowrap align=\"center\"><a target=\"_blank\" href=\"dumpprofile.jsp?peer=").append(peer.toBase64().substring(0, 6)).append("\">").append(this._("profile")).append("</a>");
            buf.append("&nbsp;<a href=\"configpeer.jsp?peer=").append(peer.toBase64()).append("\">+-</a></td>\n");
            buf.append("</tr>");
            out.write(buf.toString());
            buf.setLength(0);
        }
        buf.append("</table>");
        buf.append("<h2><a name=\"flood\"></a>").append(this._("Floodfill and Integrated Peers")).append("</h2>\n");
        buf.append("<table>");
        buf.append("<tr>");
        buf.append("<th class=\"smallhead\">").append(this._("Peer")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Caps")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Integ. Value")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Last Heard About")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Last Heard From")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Last Good Send")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Last Bad Send")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("10m Resp. Time")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("1h Resp. Time")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("1d Resp. Time")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Last Good Lookup")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Last Bad Lookup")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Last Good Store")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("Last Bad Store")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("1h Fail Rate")).append("</th>");
        buf.append("<th class=\"smallhead\">").append(this._("1d Fail Rate")).append("</th>");
        buf.append("</tr>");
        for (PeerProfile prof : integratedPeers) {
            peer = prof.getPeer();
            buf.append("<tr><td align=\"center\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(peer));
            buf.append("</td>");
            RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
            if (info != null) {
                buf.append("<td align=\"center\">").append(DataHelper.stripHTML(info.getCapabilities())).append("</td>");
            } else {
                buf.append("<td>&nbsp;</td>");
            }
            buf.append("</code></td>");
            buf.append("<td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getIntegrationValue())).append("</td>");
            long time = now - prof.getLastHeardAbout();
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration(time)).append("</td>");
            time = now - prof.getLastHeardFrom();
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration(time)).append("</td>");
            time = now - prof.getLastSendSuccessful();
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration(time)).append("</td>");
            time = now - prof.getLastSendFailed();
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration(time)).append("</td>");
            buf.append("<td align=\"right\">").append(this.avg(prof, 600000L)).append("</td>");
            buf.append("<td align=\"right\">").append(this.avg(prof, 3600000L)).append("</td>");
            buf.append("<td align=\"right\">").append(this.avg(prof, 86400000L)).append("</td>");
            DBHistory dbh = prof.getDBHistory();
            if (dbh != null) {
                time = now - dbh.getLastLookupSuccessful();
                buf.append("<td align=\"right\">").append(DataHelper.formatDuration(time)).append("</td>");
                time = now - dbh.getLastLookupFailed();
                buf.append("<td align=\"right\">").append(DataHelper.formatDuration(time)).append("</td>");
                time = now - dbh.getLastStoreSuccessful();
                buf.append("<td align=\"right\">").append(DataHelper.formatDuration(time)).append("</td>");
                time = now - dbh.getLastStoreFailed();
                buf.append("<td align=\"right\">").append(DataHelper.formatDuration(time)).append("</td>");
                buf.append("<td align=\"right\">").append(this.davg(dbh, 3600000L)).append("</td>");
                buf.append("<td align=\"right\">").append(this.davg(dbh, 86400000L)).append("</td>");
            } else {
                for (int i = 0; i < 6; ++i) {
                    buf.append("<td align=\"right\">").append(this._(NA));
                }
            }
            buf.append("</tr>\n");
        }
        buf.append("</table>");
        buf.append("<h3>").append(this._("Thresholds")).append("</h3>");
        buf.append("<p><b>").append(this._("Speed")).append(":</b> ").append(ProfileOrganizerRenderer.num(this._organizer.getSpeedThreshold())).append(" (").append(fast).append(' ').append(this._("fast peers")).append(")<br>");
        buf.append("<b>").append(this._("Capacity")).append(":</b> ").append(ProfileOrganizerRenderer.num(this._organizer.getCapacityThreshold())).append(" (").append(reliable).append(' ').append(this._("high capacity peers")).append(")<br>");
        buf.append("<b>").append(this._("Integration")).append(":</b> ").append(ProfileOrganizerRenderer.num(this._organizer.getIntegrationThreshold())).append(" (").append(integrated).append(' ').append(this._(" well integrated peers")).append(")</p>");
        buf.append("<h3>").append(this._("Definitions")).append("</h3><ul>");
        buf.append("<li><b>").append(this._("groups")).append("</b>: ").append(this._("as determined by the profile organizer")).append("</li>");
        buf.append("<li><b>").append(this._("caps")).append("</b>: ").append(this._("capabilities in the netDb, not used to determine profiles")).append("</li>");
        buf.append("<li><b>").append(this._("speed")).append("</b>: ").append(this._("peak throughput (bytes per second) over a 1 minute period that the peer has sustained in a single tunnel")).append("</li>");
        buf.append("<li><b>").append(this._("capacity")).append("</b>: ").append(this._("how many tunnels can we ask them to join in an hour?")).append("</li>");
        buf.append("<li><b>").append(this._("integration")).append("</b>: ").append(this._("how many new peers have they told us about lately?")).append("</li>");
        buf.append("<li><b>").append(this._("status")).append("</b>: ").append(this._("is the peer banned, or unreachable, or failing tunnel tests?")).append("</li>");
        buf.append("</ul></i>");
        out.write(buf.toString());
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double num) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(num);
        }
    }

    private String avg(PeerProfile prof, long rate) {
        RateStat rs = prof.getDbResponseTime();
        if (rs == null) {
            return this._(NA);
        }
        Rate r = rs.getRate(rate);
        if (r == null) {
            return this._(NA);
        }
        long c = r.getCurrentEventCount() + r.getLastEventCount();
        if (c == 0L) {
            return this._(NA);
        }
        double d = r.getCurrentTotalValue() + r.getLastTotalValue();
        return Math.round(d / (double)c) + "ms";
    }

    private String davg(DBHistory dbh, long rate) {
        RateStat rs = dbh.getFailedLookupRate();
        if (rs == null) {
            return "0%";
        }
        Rate r = rs.getRate(rate);
        if (r == null) {
            return "0%";
        }
        long c = r.getCurrentEventCount() + r.getLastEventCount();
        if (c <= 0L) {
            return "0%";
        }
        double avg = 0.5 + 100.0 * (r.getCurrentTotalValue() + r.getLastTotalValue()) / (double)c;
        return (int)avg + "%";
    }

    private String _(String s) {
        return Messages.getString(s, this._context);
    }

    private String _(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProfileComparator
    implements Comparator<PeerProfile> {
        private ProfileComparator() {
        }

        @Override
        public int compare(PeerProfile left, PeerProfile right) {
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(left.getPeer())) {
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(right.getPeer())) {
                    return this.compareHashes(left, right);
                }
                return -1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isHighCapacity(left.getPeer())) {
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(right.getPeer())) {
                    return 1;
                }
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isHighCapacity(right.getPeer())) {
                    return this.compareHashes(left, right);
                }
                return -1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFailing(left.getPeer())) {
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFailing(right.getPeer())) {
                    return this.compareHashes(left, right);
                }
                return 1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(right.getPeer())) {
                return 1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isHighCapacity(right.getPeer())) {
                return 1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFailing(right.getPeer())) {
                return -1;
            }
            return this.compareHashes(left, right);
        }

        private int compareHashes(PeerProfile left, PeerProfile right) {
            return left.getPeer().toBase64().compareTo(right.getPeer().toBase64());
        }
    }
}

