/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.web.ConfigClientsHelper;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NavHelper;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.WebAppStarter;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.Translate;
import org.mortbay.jetty.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginStarter
implements Runnable {
    protected RouterContext _context;
    static final String PREFIX = "plugin.";
    static final String ENABLED = ".startOnLoad";
    private static final String[] STANDARD_WEBAPPS = new String[]{"i2psnark", "i2ptunnel", "susidns", "susimail", "addressbook", "routerconsole"};
    private static final String[] STANDARD_THEMES = new String[]{"images", "light", "dark", "classic", "midnight"};
    private static Map<String, ThreadGroup> pluginThreadGroups = new ConcurrentHashMap<String, ThreadGroup>();
    private static Map<String, Collection<Job>> pluginJobs = new ConcurrentHashMap<String, Collection<Job>>();
    private static Map<String, ClassLoader> _clCache = new ConcurrentHashMap<String, ClassLoader>();

    public PluginStarter(RouterContext ctx) {
        this._context = ctx;
    }

    static boolean pluginsEnabled(I2PAppContext ctx) {
        return Boolean.valueOf(ctx.getProperty("router.enablePlugins", "true"));
    }

    @Override
    public void run() {
        PluginStarter.startPlugins(this._context);
    }

    static void startPlugins(RouterContext ctx) {
        Log log = ctx.logManager().getLog(PluginStarter.class);
        Properties props = PluginStarter.pluginProperties();
        for (String string : props.keySet()) {
            if (!string.startsWith(PREFIX) || !string.endsWith(ENABLED) || !Boolean.valueOf(props.getProperty(string)).booleanValue()) continue;
            String app = string.substring(PREFIX.length(), string.lastIndexOf(ENABLED));
            try {
                if (PluginStarter.startPlugin(ctx, app)) continue;
                log.error("Failed to start plugin: " + app);
            }
            catch (Throwable e) {
                log.error("Failed to start plugin: " + app, e);
            }
        }
    }

    static boolean startPlugin(RouterContext ctx, String appName) throws Exception {
        String name;
        File[] files;
        File localeDir;
        Properties props;
        Server server;
        File clientConfig;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        File pluginDir = new File(ctx.getConfigDir(), "plugins/" + appName);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.error("Cannot start nonexistent plugin: " + appName);
            return false;
        }
        File dir = new File(pluginDir, "console/themes");
        File[] tfiles = dir.listFiles();
        if (tfiles != null) {
            for (int i = 0; i < tfiles.length; ++i) {
                String name2 = tfiles[i].getName();
                if (!tfiles[i].isDirectory() || Arrays.asList(STANDARD_THEMES).contains(tfiles[i])) continue;
                ctx.router().setConfigSetting("routerconsole.theme." + name2, tfiles[i].getAbsolutePath());
            }
        }
        if ((clientConfig = new File(pluginDir, "clients.config")).exists()) {
            Properties props2 = new Properties();
            DataHelper.loadProps(props2, clientConfig);
            List<ClientAppConfig> clients = ClientAppConfig.getClientApps(clientConfig);
            PluginStarter.runClientApps(ctx, pluginDir, clients, "start");
        }
        if ((server = WebAppStarter.getConsoleServer()) != null) {
            File consoleDir = new File(pluginDir, "console");
            props = RouterConsoleRunner.webAppProperties(consoleDir.getAbsolutePath());
            File webappDir = new File(consoleDir, "webapps");
            String[] fileNames = webappDir.list(RouterConsoleRunner.WarFilenameFilter.instance());
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    try {
                        String warName = fileNames[i].substring(0, fileNames[i].lastIndexOf(".war"));
                        if (Arrays.asList(STANDARD_WEBAPPS).contains(warName)) {
                            log.error("Skipping duplicate webapp " + warName + " in plugin " + appName);
                            continue;
                        }
                        String enabled = props.getProperty("webapps." + warName + ENABLED);
                        if ("false".equals(enabled)) continue;
                        String path = new File(webappDir, fileNames[i]).getCanonicalPath();
                        WebAppStarter.startWebApp(ctx, server, warName, path);
                        continue;
                    }
                    catch (IOException ioe) {
                        log.error("Error resolving '" + fileNames[i] + "' in '" + webappDir, ioe);
                    }
                }
            }
        }
        if ((localeDir = new File(pluginDir, "console/locale")).exists() && localeDir.isDirectory() && (files = localeDir.listFiles()) != null) {
            boolean added = false;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    PluginStarter.addPath(f.toURI().toURL());
                    log.error("INFO: Adding translation plugin to classpath: " + f);
                    added = true;
                    continue;
                }
                catch (Exception e) {
                    log.error("Plugin " + appName + " bad classpath element: " + f, e);
                }
            }
            if (added) {
                Translate.clearCache();
            }
        }
        if ((name = ConfigClientsHelper.stripHTML(props = PluginStarter.pluginProperties(ctx, appName), "consoleLinkName_" + Messages.getLanguage(ctx))) == null) {
            name = ConfigClientsHelper.stripHTML(props, "consoleLinkName");
        }
        String url = ConfigClientsHelper.stripHTML(props, "consoleLinkURL");
        if (name != null && url != null && name.length() > 0 && url.length() > 0) {
            String tip = ConfigClientsHelper.stripHTML(props, "consoleLinkTooltip_" + Messages.getLanguage(ctx));
            if (tip == null) {
                tip = ConfigClientsHelper.stripHTML(props, "consoleLinkTooltip");
            }
            if (tip != null) {
                NavHelper.registerApp(name, url, tip);
            } else {
                NavHelper.registerApp(name, url);
            }
        }
        return true;
    }

    static boolean stopPlugin(RouterContext ctx, String appName) throws Exception {
        Properties props;
        String name;
        Server server;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        File pluginDir = new File(ctx.getConfigDir(), "plugins/" + appName);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.error("Cannot stop nonexistent plugin: " + appName);
            return false;
        }
        File clientConfig = new File(pluginDir, "clients.config");
        if (clientConfig.exists()) {
            Properties props2 = new Properties();
            DataHelper.loadProps(props2, clientConfig);
            List<ClientAppConfig> clients = ClientAppConfig.getClientApps(clientConfig);
            PluginStarter.runClientApps(ctx, pluginDir, clients, "stop");
        }
        if ((server = WebAppStarter.getConsoleServer()) != null) {
            File consoleDir = new File(pluginDir, "console");
            Properties props3 = RouterConsoleRunner.webAppProperties(consoleDir.getAbsolutePath());
            File webappDir = new File(consoleDir, "webapps");
            String[] fileNames = webappDir.list(RouterConsoleRunner.WarFilenameFilter.instance());
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    String warName = fileNames[i].substring(0, fileNames[i].lastIndexOf(".war"));
                    if (Arrays.asList(STANDARD_WEBAPPS).contains(warName)) continue;
                    WebAppStarter.stopWebApp(server, warName);
                }
            }
        }
        if ((name = ConfigClientsHelper.stripHTML(props = PluginStarter.pluginProperties(ctx, appName), "consoleLinkName_" + Messages.getLanguage(ctx))) == null) {
            name = ConfigClientsHelper.stripHTML(props, "consoleLinkName");
        }
        if (name != null && name.length() > 0) {
            NavHelper.unregisterApp(name);
        }
        if (log.shouldLog(30)) {
            log.warn("Stopping plugin: " + appName);
        }
        return true;
    }

    static boolean deletePlugin(RouterContext ctx, String appName) throws Exception {
        String name;
        File dir;
        File[] tfiles;
        Log log = ctx.logManager().getLog(PluginStarter.class);
        File pluginDir = new File(ctx.getConfigDir(), "plugins/" + appName);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.error("Cannot delete nonexistent plugin: " + appName);
            return false;
        }
        File clientConfig = new File(pluginDir, "clients.config");
        if (clientConfig.exists()) {
            Properties props = new Properties();
            DataHelper.loadProps(props, clientConfig);
            List<ClientAppConfig> clients = ClientAppConfig.getClientApps(clientConfig);
            PluginStarter.runClientApps(ctx, pluginDir, clients, "uninstall");
        }
        if ((tfiles = (dir = new File(pluginDir, "console/themes")).listFiles()) != null) {
            String current = ctx.getProperty("routerconsole.theme");
            for (int i = 0; i < tfiles.length; ++i) {
                name = tfiles[i].getName();
                if (!tfiles[i].isDirectory() || Arrays.asList(STANDARD_THEMES).contains(tfiles[i])) continue;
                ctx.router().removeConfigSetting("routerconsole.theme." + name);
                if (!name.equals(current)) continue;
                ctx.router().setConfigSetting("routerconsole.theme", "light");
            }
            ctx.router().saveConfig();
        }
        FileUtil.rmdir(pluginDir, false);
        Properties props = PluginStarter.pluginProperties();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            if (!name.startsWith(PREFIX + appName)) continue;
            iter.remove();
        }
        PluginStarter.storePluginProperties(props);
        return true;
    }

    public static Properties pluginProperties(I2PAppContext ctx, String appName) {
        File cfgFile = new File(ctx.getConfigDir(), "plugins/" + appName + '/' + "plugin.config");
        Properties rv = new Properties();
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return rv;
    }

    public static Properties pluginProperties() {
        File dir = I2PAppContext.getGlobalContext().getConfigDir();
        Properties rv = new Properties();
        File cfgFile = new File(dir, "plugins.config");
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        List<String> names = PluginStarter.getPlugins();
        for (String name : names) {
            String prop = PREFIX + name + ENABLED;
            if (rv.getProperty(prop) != null) continue;
            rv.setProperty(prop, "true");
        }
        return rv;
    }

    public static List<String> getPlugins() {
        ArrayList<String> rv = new ArrayList<String>();
        File pluginDir = new File(I2PAppContext.getGlobalContext().getConfigDir(), "plugins");
        File[] files = pluginDir.listFiles();
        if (files == null) {
            return rv;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            rv.add(files[i].getName());
        }
        return rv;
    }

    public static Map<String, String> getPluginKeys(I2PAppContext ctx) {
        HashMap<String, String> rv = new HashMap<String, String>();
        List<String> names = PluginStarter.getPlugins();
        for (String name : names) {
            Properties props = PluginStarter.pluginProperties(ctx, name);
            String pubkey = props.getProperty("key");
            String signer = props.getProperty("signer");
            if (pubkey == null || signer == null || pubkey.length() != 172 || signer.length() <= 0) continue;
            rv.put(pubkey, signer);
        }
        return rv;
    }

    public static void storePluginProperties(Properties props) {
        File cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), "plugins.config");
        try {
            DataHelper.storeProps(props, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void runClientApps(RouterContext ctx, File pluginDir, List<ClientAppConfig> apps, String action) throws Exception {
        Log log = ctx.logManager().getLog(PluginStarter.class);
        String pluginName = pluginDir.getName();
        if (!pluginThreadGroups.containsKey(pluginName)) {
            pluginThreadGroups.put(pluginName, new ThreadGroup(pluginName));
        }
        ThreadGroup pluginThreadGroup = pluginThreadGroups.get(pluginName);
        if (action.equals("start")) {
            pluginJobs.put(pluginName, new ConcurrentHashSet());
        }
        for (ClientAppConfig app : apps) {
            String[] argVal;
            if (action.equals("start") && app.disabled) continue;
            if (action.equals("start")) {
                argVal = LoadClientAppsJob.parseArgs(app.args);
            } else {
                String args;
                if (action.equals("stop")) {
                    args = app.stopargs;
                } else if (action.equals("uninstall")) {
                    args = app.uninstallargs;
                } else {
                    throw new IllegalArgumentException("bad action");
                }
                if (args == null || args.length() <= 0) continue;
                argVal = LoadClientAppsJob.parseArgs(args);
            }
            for (int i = 0; i < argVal.length; ++i) {
                if (argVal[i].indexOf("$") < 0) continue;
                argVal[i] = argVal[i].replace("$I2P", ctx.getBaseDir().getAbsolutePath());
                argVal[i] = argVal[i].replace("$CONFIG", ctx.getConfigDir().getAbsolutePath());
                argVal[i] = argVal[i].replace("$PLUGIN", pluginDir.getAbsolutePath());
            }
            ClassLoader cl = null;
            if (app.classpath != null) {
                URL[] urls;
                String cp = new String(app.classpath);
                if (cp.indexOf("$") >= 0) {
                    cp = cp.replace("$I2P", ctx.getBaseDir().getAbsolutePath());
                    cp = cp.replace("$CONFIG", ctx.getConfigDir().getAbsolutePath());
                    cp = cp.replace("$PLUGIN", pluginDir.getAbsolutePath());
                }
                String clCacheKey = pluginName + app.className + app.args;
                if (!action.equals("start")) {
                    cl = _clCache.get(clCacheKey);
                }
                if (cl == null && (urls = PluginStarter.classpathToURLArray(cp, app.clientName, log)) != null) {
                    cl = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
                    if (action.equals("start")) {
                        _clCache.put(clCacheKey, cl);
                    }
                }
            }
            if (app.delay < 0L && action.equals("start")) {
                LoadClientAppsJob.runClientInline(app.className, app.clientName, argVal, log, cl);
                continue;
            }
            if (app.delay == 0L || !action.equals("start")) {
                LoadClientAppsJob.testClient(app.className, cl);
                LoadClientAppsJob.runClient(app.className, app.clientName, argVal, log, pluginThreadGroup, cl);
                continue;
            }
            try {
                LoadClientAppsJob.testClient(app.className, cl);
            }
            catch (ClassNotFoundException ex) {
                if (app.delay > 1L) {
                    Thread.sleep(2000L);
                }
                Thread.sleep(1000L);
            }
            LoadClientAppsJob.testClient(app.className, cl);
            LoadClientAppsJob.DelayedRunClient job = new LoadClientAppsJob.DelayedRunClient(ctx, app.className, app.clientName, argVal, app.delay, pluginThreadGroup, cl);
            ctx.jobQueue().addJob(job);
            pluginJobs.get(pluginName).add(job);
        }
    }

    public static boolean isPluginRunning(String pluginName, RouterContext ctx) {
        Log log = ctx.logManager().getLog(PluginStarter.class);
        boolean isJobRunning = false;
        if (pluginJobs.containsKey(pluginName)) {
            for (Job job : pluginJobs.get(pluginName)) {
                if (!ctx.jobQueue().isJobActive(job)) continue;
                isJobRunning = true;
                break;
            }
        }
        if (log.shouldLog(10)) {
            log.debug("plugin name = <" + pluginName + ">; threads running? " + PluginStarter.isClientThreadRunning(pluginName) + "; webapp runing? " + WebAppStarter.isWebAppRunning(pluginName) + "; jobs running? " + isJobRunning);
        }
        return PluginStarter.isClientThreadRunning(pluginName) || WebAppStarter.isWebAppRunning(pluginName) || isJobRunning;
    }

    private static boolean isClientThreadRunning(String pluginName) {
        ThreadGroup group = pluginThreadGroups.get(pluginName);
        if (group == null) {
            return false;
        }
        Thread[] activeThreads = new Thread[1];
        group.enumerate(activeThreads);
        return activeThreads[0] != null;
    }

    private static URL[] classpathToURLArray(String classpath, String clientName, Log log) {
        StringTokenizer tok = new StringTokenizer(classpath, ",");
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tok.hasMoreTokens()) {
            String elem = tok.nextToken().trim();
            File f = new File(elem);
            if (!f.isAbsolute()) {
                log.error("Plugin client " + clientName + " classpath element is not absolute: " + f);
                continue;
            }
            try {
                urls.add(f.toURI().toURL());
                if (!log.shouldLog(30)) continue;
                log.warn("INFO: Adding plugin to classpath: " + f);
            }
            catch (Exception e) {
                log.error("Plugin client " + clientName + " bad classpath element: " + f, e);
            }
        }
        if (urls.isEmpty()) {
            return null;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addPath(URL u) throws Exception {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u);
    }
}

