/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.NetDbRenderer;

public class NetDbHelper
extends HelperBase {
    private String _routerPrefix;
    private int _full;
    private boolean _lease;
    private boolean _debug;

    public void setRouter(String r) {
        if (r != null) {
            this._routerPrefix = DataHelper.stripHTML(r);
        }
    }

    public void setFull(String f) {
        try {
            this._full = Integer.parseInt(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setLease(String l) {
        this._debug = "2".equals(l);
        this._lease = this._debug || "1".equals(l);
    }

    public String getNetDbSummary() {
        NetDbRenderer renderer = new NetDbRenderer(this._context);
        try {
            if (this._out != null) {
                if (this._routerPrefix != null) {
                    renderer.renderRouterInfoHTML(this._out, this._routerPrefix);
                } else if (this._lease) {
                    renderer.renderLeaseSetHTML(this._out, this._debug);
                } else {
                    renderer.renderStatusHTML(this._out, this._full);
                }
                return "";
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
            if (this._routerPrefix != null) {
                renderer.renderRouterInfoHTML(new OutputStreamWriter(baos), this._routerPrefix);
            } else if (this._lease) {
                renderer.renderLeaseSetHTML(new OutputStreamWriter(baos), this._debug);
            } else {
                renderer.renderStatusHTML(new OutputStreamWriter(baos), this._full);
            }
            return new String(baos.toByteArray());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }
}

