/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;

public class NavHelper {
    private static Map<String, String> _apps = new ConcurrentHashMap<String, String>(4);
    private static Map<String, String> _tooltips = new ConcurrentHashMap<String, String>(4);

    public static void registerApp(String name, String path) {
        _apps.put(name, path);
    }

    public static void registerApp(String name, String path, String tooltip) {
        _apps.put(name, path);
        _tooltips.put(name, tooltip);
    }

    public static void unregisterApp(String name) {
        _apps.remove(name);
        _tooltips.remove(name);
    }

    public static String getClientAppLinks(I2PAppContext ctx) {
        if (_apps.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(256);
        ArrayList<String> l = new ArrayList<String>(_apps.keySet());
        Collections.sort(l);
        for (String name : l) {
            String path = _apps.get(name);
            if (path == null) continue;
            buf.append(" <a target=\"_blank\" href=\"").append(path).append("\" ");
            String tip = _tooltips.get(name);
            if (tip != null) {
                buf.append("title=\"").append(tip).append("\" ");
            }
            buf.append('>').append(name).append("</a>");
        }
        return buf.toString();
    }
}

