/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.List;
import net.i2p.router.web.HelperBase;
import net.i2p.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogsHelper
extends HelperBase {
    public String getLogs() {
        String str = this.formatMessages(this._context.logManager().getBuffer().getMostRecentMessages());
        return this._("File location") + ": <b><code>" + this._context.logManager().currentFile() + "</code></b><br><br>" + str;
    }

    public String getCriticalLogs() {
        return this.formatMessages(this._context.logManager().getBuffer().getMostRecentCriticalMessages());
    }

    public String getServiceLogs() {
        File f;
        String path = System.getProperty("wrapper.logfile");
        if (path != null) {
            f = new File(path);
        } else {
            f = new File(System.getProperty("java.io.tmpdir"), "wrapper.log");
            if (!f.exists()) {
                f = new File(this._context.getBaseDir(), "wrapper.log");
            }
        }
        String str = FileUtil.readTextFile(f.getAbsolutePath(), 250, false);
        if (str == null) {
            return this._("File not found") + ": <b><code>" + f.getAbsolutePath() + "</code></b>";
        }
        str = str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        return this._("File location") + ": <b><code>" + f.getAbsolutePath() + "</code></b> <pre>" + str + "</pre>";
    }

    private String formatMessages(List<String> msgs) {
        if (msgs.isEmpty()) {
            return "<p><i>" + this._("No log messages") + "</i></p>";
        }
        boolean colorize = Boolean.valueOf(this._context.getProperty("routerconsole.logs.color"));
        StringBuilder buf = new StringBuilder(16384);
        buf.append("<ul>");
        buf.append("<code>\n");
        for (int i = msgs.size(); i > 0; --i) {
            String msg = msgs.get(i - 1);
            msg = msg.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            buf.append("<li>");
            if (colorize) {
                String color = msg.contains("CRIT") ? "#cc0000" : (msg.contains("ERROR") ? "#ff3300" : (msg.contains("WARN") ? "#ff00cc" : (msg.contains("INFO") ? "#000099" : "#006600")));
                buf.append("<font color=\"").append(color).append("\">");
                buf.append(msg);
                buf.append("</font>");
            } else {
                buf.append(msg);
            }
            buf.append("</li>\n");
        }
        buf.append("</code></ul>\n");
        return buf.toString();
    }
}

