/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import net.i2p.I2PAppContext;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.WebApplicationHandler;

public class LocaleWebAppHandler
extends WebApplicationHandler {
    private I2PAppContext _context;

    public LocaleWebAppHandler(I2PAppContext ctx) {
        this._context = ctx;
    }

    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        int len;
        if ("OPTIONS".equals(httpRequest.getMethod())) {
            this.handleOptions(httpRequest, httpResponse);
            return;
        }
        String newPath = pathInContext;
        if (pathInContext.endsWith(".jsp") && ((len = pathInContext.length()) < 8 || pathInContext.charAt(len - 7) != '_')) {
            String servletPath;
            String testPath;
            Map.Entry servlet;
            String lang = this._context.getProperty("routerconsole.lang");
            if (lang == null || lang.length() <= 0) {
                lang = Locale.getDefault().getLanguage();
            }
            if (lang != null && lang.length() > 0 && !lang.equals("en") && (servlet = this.getHolderEntry(testPath = pathInContext.substring(0, len - 4) + '_' + lang + ".jsp")) != null && (servletPath = (String)servlet.getKey()) != null && !servletPath.startsWith("*")) {
                newPath = testPath;
            }
        }
        super.handle(newPath, pathParams, httpRequest, httpResponse);
    }

    public void handleTrace(HttpRequest request, HttpResponse response) throws IOException {
        response.sendError(405);
    }

    public void handleOptions(HttpRequest request, HttpResponse response) throws IOException {
        response.sendError(405);
    }
}

