/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryListener;
import net.i2p.stat.Rate;

public class GraphHelper
extends HelperBase {
    private int _periodCount;
    private boolean _showEvents;
    private int _width;
    private int _height;
    private int _refreshDelaySeconds;
    private static final String PROP_X = "routerconsole.graphX";
    private static final String PROP_Y = "routerconsole.graphY";
    private static final String PROP_REFRESH = "routerconsole.graphRefresh";
    private static final String PROP_PERIODS = "routerconsole.graphPeriods";
    private static final String PROP_EVENTS = "routerconsole.graphEvents";
    private static final int DEFAULT_X = 250;
    private static final int DEFAULT_Y = 100;
    private static final int DEFAULT_REFRESH = 60;
    private static final int DEFAULT_PERIODS = 60;
    static final int MAX_X = 2048;
    static final int MAX_Y = 1024;
    private static final int MIN_REFRESH = 15;

    public void setContextId(String contextId) {
        super.setContextId(contextId);
        this._width = this._context.getProperty(PROP_X, 250);
        this._height = this._context.getProperty(PROP_Y, 100);
        this._periodCount = this._context.getProperty(PROP_PERIODS, 60);
        this._refreshDelaySeconds = this._context.getProperty(PROP_REFRESH, 60);
        this._showEvents = Boolean.valueOf(this._context.getProperty(PROP_EVENTS));
    }

    public void setPeriodCount(String str) {
        try {
            this._periodCount = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setShowEvents(boolean b) {
        this._showEvents = b;
    }

    public void setHeight(String str) {
        try {
            this._height = Math.min(Integer.parseInt(str), 1024);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setWidth(String str) {
        try {
            this._width = Math.min(Integer.parseInt(str), 2048);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setRefreshDelay(String str) {
        try {
            this._refreshDelaySeconds = Math.max(Integer.parseInt(str), 15);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getImages() {
        try {
            List listeners = StatSummarizer.instance().getListeners();
            TreeSet ordered = new TreeSet(new AlphaComparator());
            ordered.addAll(listeners);
            boolean hasTx = false;
            boolean hasRx = false;
            for (SummaryListener lsnr : ordered) {
                String title = lsnr.getRate().getRateStat().getName();
                if (title.equals("bw.sendRate")) {
                    hasTx = true;
                    continue;
                }
                if (!title.equals("bw.recvRate")) continue;
                hasRx = true;
            }
            if (hasTx && hasRx && !this._showEvents) {
                this._out.write("<a href=\"viewstat.jsp?stat=bw.combined&amp;periodCount=" + 3 * this._periodCount + "&amp;width=" + 3 * this._width + "&amp;height=" + 3 * this._height + "\" / target=\"_blank\">");
                String title = this._("Combined bandwidth graph");
                this._out.write("<img class=\"statimage\" width=\"" + (this._width + 83) + "\" height=\"" + (this._height + 92) + "\" src=\"viewstat.jsp?stat=bw.combined" + "&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width + "&amp;height=" + (this._height - 14) + "\" alt=\"" + title + "\" title=\"" + title + "\"></a>\n");
            }
            for (SummaryListener lsnr : ordered) {
                Rate r = lsnr.getRate();
                String title = this._("{0} for {1}", (Object)r.getRateStat().getName(), (Object)DataHelper.formatDuration((long)this._periodCount * r.getPeriod()));
                this._out.write("<a href=\"viewstat.jsp?stat=" + r.getRateStat().getName() + "&amp;showEvents=" + this._showEvents + "&amp;period=" + r.getPeriod() + "&amp;periodCount=" + 3 * this._periodCount + "&amp;width=" + 3 * this._width + "&amp;height=" + 3 * this._height + "\" target=\"_blank\">");
                this._out.write("<img class=\"statimage\" border=\"0\" width=\"" + (this._width + 83) + "\" height=\"" + (this._height + 92) + "\" src=\"viewstat.jsp?stat=" + r.getRateStat().getName() + "&amp;showEvents=" + this._showEvents + "&amp;period=" + r.getPeriod() + "&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width + "&amp;height=" + this._height + "\" alt=\"" + title + "\" title=\"" + title + "\"></a>\n");
            }
            if (this._refreshDelaySeconds > 0) {
                this._out.write("<meta http-equiv=\"refresh\" content=\"" + (this._refreshDelaySeconds - 3) + "\">\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    public String getForm() {
        this.saveSettings();
        try {
            this._out.write("<br><h3>" + this._("Configure Graph Display") + " [<a href=\"configstats.jsp\">" + this._("Select Stats") + "</a>]</h3>");
            this._out.write("<form action=\"graphs.jsp\" method=\"GET\">");
            this._out.write(this._("Periods") + ": <input size=\"3\" type=\"text\" name=\"periodCount\" value=\"" + this._periodCount + "\"><br>\n");
            this._out.write(this._("Plot averages") + ": <input type=\"radio\" class=\"optbox\" name=\"showEvents\" value=\"false\" " + (this._showEvents ? "" : "checked=\"true\" ") + "> ");
            this._out.write(this._("or") + " " + this._("plot events") + ": <input type=\"radio\" class=\"optbox\" name=\"showEvents\" value=\"true\" " + (this._showEvents ? "checked=\"true\" " : "") + "><br>\n");
            this._out.write(this._("Image sizes") + ": " + this._("width") + ": <input size=\"4\" type=\"text\" name=\"width\" value=\"" + this._width + "\"> " + this._("pixels") + ", " + this._("height") + ": <input size=\"4\" type=\"text\" name=\"height\" value=\"" + this._height + "\"> " + this._("pixels") + "<br>\n");
            this._out.write(this._("Refresh delay") + ": <select name=\"refreshDelay\"><option value=\"60\">1 " + this._("minute") + "</option><option value=\"120\">2 " + this._("minutes") + "</option><option value=\"300\">5 " + this._("minutes") + "</option><option value=\"600\">10 " + this._("minutes") + "</option><option value=\"1800\">30 " + this._("minutes") + "</option><option value=\"3600\">1 " + this._("hour") + "</option><option value=\"-1\">" + this._("Never") + "</option></select><br>\n");
            this._out.write("<hr><div class=\"formaction\"><input type=\"submit\" value=\"" + this._("Redraw") + "\"></div></form>");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private void saveSettings() {
        if (this._width != this._context.getProperty(PROP_X, 250) || this._height != this._context.getProperty(PROP_Y, 100) || this._periodCount != this._context.getProperty(PROP_PERIODS, 60) || this._refreshDelaySeconds != this._context.getProperty(PROP_REFRESH, 60) || this._showEvents != Boolean.valueOf(this._context.getProperty(PROP_EVENTS))) {
            this._context.router().setConfigSetting(PROP_X, "" + this._width);
            this._context.router().setConfigSetting(PROP_Y, "" + this._height);
            this._context.router().setConfigSetting(PROP_PERIODS, "" + this._periodCount);
            this._context.router().setConfigSetting(PROP_REFRESH, "" + this._refreshDelaySeconds);
            this._context.router().setConfigSetting(PROP_EVENTS, "" + this._showEvents);
            this._context.router().saveConfig();
        }
    }

    private static class AlphaComparator
    implements Comparator {
        private AlphaComparator() {
        }

        public int compare(Object lhs, Object rhs) {
            SummaryListener l = (SummaryListener)lhs;
            SummaryListener r = (SummaryListener)rhs;
            String lName = l.getRate().getRateStat().getName() + "." + l.getRate().getPeriod();
            String rName = r.getRate().getRateStat().getName() + "." + r.getRate().getPeriod();
            return lName.compareTo(rName);
        }
    }
}

