/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.Messages;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormHandler {
    protected RouterContext _context;
    protected Log _log;
    private String _nonce = null;
    protected String _action = null;
    protected String _passphrase = null;
    private List<String> _errors = new ArrayList<String>();
    private List<String> _notices = new ArrayList<String>();
    private boolean _processed = false;
    private boolean _valid = true;

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
            this._log = this._context.logManager().getLog(this.getClass());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setNonce(String val) {
        this._nonce = val;
    }

    public void setAction(String val) {
        this._action = val;
    }

    public void setPassphrase(String val) {
        this._passphrase = val;
    }

    protected void processForm() {
    }

    protected void addFormError(String errorMsg) {
        if (errorMsg == null) {
            return;
        }
        this._errors.add(errorMsg);
    }

    protected void addFormNotice(String msg) {
        if (msg == null) {
            return;
        }
        this._notices.add(msg);
    }

    public String getAllMessages() {
        this.validate();
        this.process();
        if (this._errors.isEmpty() && this._notices.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<div class=\"messages\" id=\"messages\"><p>");
        if (!this._errors.isEmpty()) {
            buf.append("<span class=\"error\">");
            buf.append(FormHandler.render(this._errors));
            buf.append("</span>");
        }
        if (!this._notices.isEmpty()) {
            buf.append("<span class=\"notice\">");
            buf.append(FormHandler.render(this._notices));
            buf.append("</span>");
        }
        buf.append("</p></div>");
        return buf.toString();
    }

    public String getErrors() {
        this.validate();
        this.process();
        return FormHandler.render(this._errors);
    }

    public String getNotices() {
        this.validate();
        this.process();
        return FormHandler.render(this._notices);
    }

    private void validate() {
        String expected;
        if (this._processed) {
            return;
        }
        this._valid = true;
        if (this._action == null) {
            this._valid = false;
            return;
        }
        if (this._nonce == null) {
            this._valid = false;
            return;
        }
        String sharedNonce = System.getProperty("router.consoleNonce");
        if (sharedNonce != null && sharedNonce.equals(this._nonce)) {
            return;
        }
        String nonce = System.getProperty(this.getClass().getName() + ".nonce");
        String noncePrev = System.getProperty(this.getClass().getName() + ".noncePrev");
        if (!(nonce != null && this._nonce.equals(nonce) || noncePrev != null && this._nonce.equals(noncePrev) || (expected = this._context.getProperty("consolePassword")) != null && expected.trim().length() > 0 && expected.equals(this._passphrase))) {
            this.addFormError(this._("Invalid form submission, probably because you used the 'back' or 'reload' button on your browser. Please resubmit."));
            this._valid = false;
        }
    }

    private void process() {
        if (!this._processed) {
            if (this._valid) {
                this.processForm();
            }
            this._processed = true;
        }
    }

    private static String render(List<String> source) {
        if (source.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<ul>\n");
        for (int i = 0; i < source.size(); ++i) {
            buf.append("<li>");
            buf.append(source.get(i));
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        return buf.toString();
    }

    public String _(String s) {
        return Messages.getString(s, this._context);
    }

    public String _(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }
}

