/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUIHelper
extends HelperBase {
    static final String PROP_THEME_PFX = "routerconsole.theme.";
    private static final String[] langs = new String[]{"de", "en", "es", "fr", "nl", "ru", "sv", "zh"};
    private static final String[] flags = new String[]{"de", "us", "es", "fr", "nl", "ru", "se", "cn"};
    private static final String[] xlangs = new String[]{ConfigUIHelper._x("German"), ConfigUIHelper._x("English"), ConfigUIHelper._x("Spanish"), ConfigUIHelper._x("French"), ConfigUIHelper._x("Dutch"), ConfigUIHelper._x("Russian"), ConfigUIHelper._x("Swedish"), ConfigUIHelper._x("Chinese")};

    public String getSettings() {
        StringBuilder buf = new StringBuilder(512);
        String current = this._context.getProperty("routerconsole.theme", "light");
        Set<String> themes = this.themeSet();
        for (String theme : themes) {
            buf.append("<input type=\"radio\" class=\"optbox\" name=\"theme\" ");
            if (theme.equals(current)) {
                buf.append("checked=\"true\" ");
            }
            buf.append("value=\"").append(theme).append("\">").append(this._(theme)).append("<br>\n");
        }
        return buf.toString();
    }

    private Set<String> themeSet() {
        TreeSet<String> rv = new TreeSet<String>();
        rv.add("light");
        File dir = new File(this._context.getBaseDir(), "docs/themes/console");
        File[] files = dir.listFiles();
        if (files == null) {
            return rv;
        }
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (!files[i].isDirectory() || name.equals("images")) continue;
            rv.add(name);
        }
        Set props = this._context.getPropertyNames();
        for (String prop : props) {
            if (!prop.startsWith(PROP_THEME_PFX) || prop.length() <= PROP_THEME_PFX.length()) continue;
            rv.add(prop.substring(PROP_THEME_PFX.length()));
        }
        return rv;
    }

    public String getLangSettings() {
        StringBuilder buf = new StringBuilder(512);
        String current = Messages.getLanguage(this._context);
        for (int i = 0; i < langs.length; ++i) {
            buf.append("<input type=\"radio\" class=\"optbox\" name=\"lang\" ");
            if (langs[i].equals(current)) {
                buf.append("checked=\"true\" ");
            }
            buf.append("value=\"").append(langs[i]).append("\">").append("<img height=\"11\" width=\"16\" alt=\"\" src=\"/flags.jsp?c=").append(flags[i]).append("\"> ").append(this._(xlangs[i])).append("<br>\n");
        }
        return buf.toString();
    }
}

