/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Properties;
import java.util.Set;
import net.i2p.data.Destination;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.web.HelperBase;

public class ConfigTunnelsHelper
extends HelperBase {
    private static final String HOP = "hop";
    private static final String TUNNEL = "tunnel";
    private static final String HOPS = ConfigTunnelsHelper.ngettext("1 hop", "{0} hops");
    private static final String TUNNELS = ConfigTunnelsHelper.ngettext("1 tunnel", "{0} tunnels");
    private static final int WARN_LENGTH = 4;
    private static final int MAX_LENGTH = 4;
    private static final int WARN_QUANTITY = 5;
    private static final int MAX_QUANTITY = 6;
    private static final int MAX_BACKUP_QUANTITY = 3;
    private static final int MAX_VARIANCE = 2;
    private static final int MIN_NEG_VARIANCE = -1;

    public String getForm() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table>\n");
        TunnelPoolSettings exploratoryIn = this._context.tunnelManager().getInboundSettings();
        TunnelPoolSettings exploratoryOut = this._context.tunnelManager().getOutboundSettings();
        buf.append("<input type=\"hidden\" name=\"pool.0\" value=\"exploratory\" >");
        this.renderForm(buf, 0, "exploratory", this._("Exploratory tunnels"), exploratoryIn, exploratoryOut);
        int cur = 1;
        Set<Destination> clients = this._context.clientManager().listClients();
        for (Destination dest : clients) {
            TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(dest.calculateHash());
            TunnelPoolSettings out = this._context.tunnelManager().getOutboundSettings(dest.calculateHash());
            if (in == null || out == null) continue;
            String name = in.getDestinationNickname();
            if (name == null) {
                name = out.getDestinationNickname();
            }
            if (name == null) {
                name = dest.calculateHash().toBase64().substring(0, 6);
            }
            String prefix = dest.calculateHash().toBase64().substring(0, 4);
            buf.append("<input type=\"hidden\" name=\"pool.").append(cur).append("\" value=\"");
            buf.append(dest.calculateHash().toBase64()).append("\" >");
            this.renderForm(buf, cur, prefix, this._("Client tunnels for") + " " + this._(name), in, out);
            ++cur;
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    private void renderForm(StringBuilder buf, int index, String prefix, String name, TunnelPoolSettings in, TunnelPoolSettings out) {
        String val;
        buf.append("<tr><th colspan=\"3\"><a name=\"").append(prefix).append("\">");
        buf.append(name).append("</a></th></tr>\n");
        if (in.getLength() <= 0 || in.getLength() + in.getLengthVariance() <= 0 || out.getLength() <= 0 || out.getLength() + out.getLengthVariance() <= 0) {
            buf.append("<tr><th colspan=\"3\"><font color=\"red\">" + this._("ANONYMITY WARNING - Settings include 0-hop tunnels.") + "</font></th></tr>");
        } else if (in.getLength() <= 1 || in.getLength() + in.getLengthVariance() <= 1 || out.getLength() <= 1 || out.getLength() + out.getLengthVariance() <= 1) {
            buf.append("<tr><th colspan=\"3\"><font color=\"red\">" + this._("ANONYMITY WARNING - Settings include 1-hop tunnels.") + "</font></th></tr>");
        }
        if (in.getLength() + Math.abs(in.getLengthVariance()) >= 4 || out.getLength() + Math.abs(out.getLengthVariance()) >= 4) {
            buf.append("<tr><th colspan=\"3\"><font color=\"red\">" + this._("PERFORMANCE WARNING - Settings include very long tunnels.") + "</font></th></tr>");
        }
        if (in.getQuantity() + in.getBackupQuantity() >= 5 || out.getQuantity() + out.getBackupQuantity() >= 5) {
            buf.append("<tr><th colspan=\"3\"><font color=\"red\">" + this._("PERFORMANCE WARNING - Settings include high tunnel quantities.") + "</font></th></tr>");
        }
        buf.append("<tr><th></th><th><img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"Inbound Tunnels\">&nbsp;&nbsp;" + this._("Inbound") + "</th><th><img src=\"/themes/console/images/outbound.png\" alt=\"Outbound Tunnels\" title=\"Outbound\">&nbsp;&nbsp;" + this._("Outbound") + "</th></tr>\n");
        buf.append("<tr><td align=\"right\" class=\"mediumtags\">" + this._("Length") + ":</td>\n");
        buf.append("<td align=\"center\"><select name=\"").append(index).append(".depthInbound\">\n");
        int now = in.getLength();
        this.renderOptions(buf, 0, 4, now, "", HOP);
        if (now > 4) {
            this.renderOptions(buf, now, now, now, "", HOP);
        }
        buf.append("</select></td>\n");
        buf.append("<td align=\"center\"><select name=\"").append(index).append(".depthOutbound\">\n");
        now = out.getLength();
        this.renderOptions(buf, 0, 4, now, "", HOP);
        if (now > 4) {
            this.renderOptions(buf, now, now, now, "", HOP);
        }
        buf.append("</select></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr><td align=\"right\" class=\"mediumtags\">" + this._("Randomization") + ":</td>\n");
        buf.append("<td align=\"center\"><select name=\"").append(index).append(".varianceInbound\">\n");
        now = in.getLengthVariance();
        this.renderOptions(buf, 0, 0, now, "", HOP);
        this.renderOptions(buf, 1, 2, now, "+ 0-", HOP);
        this.renderOptions(buf, -1, -1, now, "+/- 0", HOP);
        if (now > 2) {
            this.renderOptions(buf, now, now, now, "+ 0-", HOP);
        } else if (now < -1) {
            this.renderOptions(buf, now, now, now, "+/- 0", HOP);
        }
        buf.append("</select></td>\n");
        buf.append("<td align=\"center\"><select name=\"").append(index).append(".varianceOutbound\">\n");
        now = out.getLengthVariance();
        this.renderOptions(buf, 0, 0, now, "", HOP);
        this.renderOptions(buf, 1, 2, now, "+ 0-", HOP);
        this.renderOptions(buf, -1, -1, now, "+/- 0", HOP);
        if (now > 2) {
            this.renderOptions(buf, now, now, now, "+ 0-", HOP);
        } else if (now < -1) {
            this.renderOptions(buf, now, now, now, "+/- 0", HOP);
        }
        buf.append("</select></td>\n");
        buf.append("<tr><td align=\"right\" class=\"mediumtags\">" + this._("Quantity") + ":</td>\n");
        buf.append("<td align=\"center\"><select name=\"").append(index).append(".quantityInbound\">\n");
        now = in.getQuantity();
        this.renderOptions(buf, 1, 6, now, "", TUNNEL);
        if (now > 6) {
            this.renderOptions(buf, now, now, now, "", TUNNEL);
        }
        buf.append("</select></td>\n");
        buf.append("<td align=\"center\"><select name=\"").append(index).append(".quantityOutbound\">\n");
        now = out.getQuantity();
        this.renderOptions(buf, 1, 6, now, "", TUNNEL);
        if (now > 6) {
            this.renderOptions(buf, now, now, now, "", TUNNEL);
        }
        buf.append("</select></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr><td align=\"right\" class=\"mediumtags\">" + this._("Backup quantity") + ":</td>\n");
        buf.append("<td align=\"center\"><select name=\"").append(index).append(".backupInbound\">\n");
        now = in.getBackupQuantity();
        this.renderOptions(buf, 0, 3, now, "", TUNNEL);
        if (now > 3) {
            this.renderOptions(buf, now, now, now, "", TUNNEL);
        }
        buf.append("</select></td>\n");
        buf.append("<td align=\"center\"><select name=\"").append(index).append(".backupOutbound\">\n");
        now = out.getBackupQuantity();
        this.renderOptions(buf, 0, 3, now, "", TUNNEL);
        if (now > 3) {
            this.renderOptions(buf, now, now, now, "", TUNNEL);
        }
        buf.append("</select></td>\n");
        buf.append("</tr>\n");
        Properties props = in.getUnknownOptions();
        if (!props.isEmpty()) {
            buf.append("<tr><td align=\"right\" class=\"mediumtags\">" + this._("Inbound options") + ":</td>\n" + "<td colspan=\"2\" align=\"center\"><input name=\"").append(index);
            buf.append(".inboundOptions\" type=\"text\" size=\"32\" disabled=\"true\" value=\"");
            for (String string : props.keySet()) {
                val = props.getProperty(string);
                buf.append(string).append('=').append(val).append(' ');
            }
            buf.append("\"></td></tr>\n");
        }
        if (!(props = out.getUnknownOptions()).isEmpty()) {
            buf.append("<tr><td align=\"right\" class=\"mediumtags\">" + this._("Outbound options") + ":</td>\n" + "<td colspan=\"2\" align=\"center\"><input name=\"").append(index);
            buf.append(".outboundOptions\" type=\"text\" size=\"32\" disabled=\"true\" value=\"");
            for (String string : props.keySet()) {
                val = props.getProperty(string);
                buf.append(string).append('=').append(val).append(' ');
            }
            buf.append("\"></td></tr>\n");
        }
    }

    private void renderOptions(StringBuilder buf, int min, int max, int now, String prefix, String name) {
        for (int i = min; i <= max; ++i) {
            buf.append("<option value=\"").append(i).append("\" ");
            if (i == now) {
                buf.append("selected=\"true\" ");
            }
            buf.append(">").append(this._(i, "1 " + name, "{0} " + name + 's'));
            buf.append("</option>\n");
        }
    }

    private static String ngettext(String s, String p) {
        return null;
    }
}

