/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.List;
import net.i2p.apps.systray.SysTray;
import net.i2p.apps.systray.UrlLauncher;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.FormHandler;
import org.tanukisoftware.wrapper.WrapperManager;

public class ConfigServiceHandler
extends FormHandler {
    protected void processForm() {
        block36: {
            if (this._action == null) {
                return;
            }
            if (this._("Shutdown gracefully").equals(this._action)) {
                this._context.addShutdownTask(new UpdateWrapperManagerTask(2));
                this._context.router().shutdownGracefully();
                this.addFormNotice(this._("Graceful shutdown initiated"));
            } else if (this._("Shutdown immediately").equals(this._action)) {
                this._context.addShutdownTask(new UpdateWrapperManagerTask(3));
                this._context.router().shutdown(3);
                this.addFormNotice(this._("Shutdown immediately!  boom bye bye bad bwoy"));
            } else if (this._("Cancel graceful shutdown").equals(this._action)) {
                this._context.router().cancelGracefulShutdown();
                this.addFormNotice(this._("Graceful shutdown cancelled"));
            } else if (this._("Graceful restart").equals(this._action)) {
                this._context.addShutdownTask(new UpdateWrapperManagerTask(5));
                this._context.router().shutdownGracefully(5);
                this.addFormNotice(this._("Graceful restart requested"));
            } else if (this._("Hard restart").equals(this._action)) {
                this._context.addShutdownTask(new UpdateWrapperManagerTask(4));
                this._context.router().shutdown(4);
                this.addFormNotice(this._("Hard restart requested"));
            } else if (this._("Rekey and Restart").equals(this._action)) {
                this.addFormNotice(this._("Rekeying after graceful restart"));
                this._context.addShutdownTask(new UpdateWrapperManagerAndRekeyTask(5));
                this._context.router().shutdownGracefully(5);
            } else if (this._("Rekey and Shutdown").equals(this._action)) {
                this.addFormNotice(this._("Rekeying after graceful shutdown"));
                this._context.addShutdownTask(new UpdateWrapperManagerAndRekeyTask(2));
                this._context.router().shutdownGracefully(2);
            } else if (this._("Run I2P on startup").equals(this._action)) {
                this.installService();
            } else if (this._("Don't run I2P on startup").equals(this._action)) {
                this.uninstallService();
            } else if (this._("Dump threads").equals(this._action)) {
                try {
                    WrapperManager.requestThreadDump();
                }
                catch (Throwable t) {
                    this.addFormError("Warning: unable to contact the service manager - " + t.getMessage());
                }
                this.addFormNotice("Threads dumped to wrapper.log");
            } else if (this._("Show systray icon").equals(this._action)) {
                try {
                    SysTray tray = SysTray.getInstance();
                    if (tray != null) {
                        tray.show();
                        this.addFormNotice(this._("System tray icon enabled."));
                        break block36;
                    }
                    this.addFormNotice(this._("System tray icon feature not supported on this platform. Sorry!"));
                }
                catch (Throwable t) {
                    this.addFormError(this._("Warning: unable to contact the systray manager") + " - " + t.getMessage());
                }
            } else if (this._("Hide systray icon").equals(this._action)) {
                try {
                    SysTray tray = SysTray.getInstance();
                    if (tray != null) {
                        tray.hide();
                        this.addFormNotice(this._("System tray icon disabled."));
                        break block36;
                    }
                    this.addFormNotice(this._("System tray icon feature not supported on this platform. Sorry!"));
                }
                catch (Throwable t) {
                    this.addFormError(this._("Warning: unable to contact the systray manager") + " - " + t.getMessage());
                }
            } else if (this._("View console on startup").equals(this._action)) {
                this.browseOnStartup(true);
                this.addFormNotice(this._("Console is to be shown on startup"));
            } else if (this._("Do not view console on startup").equals(this._action)) {
                this.browseOnStartup(false);
                this.addFormNotice(this._("Console is not to be shown on startup"));
            }
        }
    }

    private void installService() {
        try {
            Runtime.getRuntime().exec("install_i2p_service_winnt.bat");
            this.addFormNotice(this._("Service installed"));
        }
        catch (IOException ioe) {
            this.addFormError(this._("Warning: unable to install the service") + " - " + ioe.getMessage());
        }
    }

    private void uninstallService() {
        try {
            Runtime.getRuntime().exec("uninstall_i2p_service_winnt.bat");
            this.addFormNotice(this._("Service removed"));
        }
        catch (IOException ioe) {
            this.addFormError(this._("Warning: unable to remove the service") + " - " + ioe.getMessage());
        }
    }

    private void browseOnStartup(boolean shouldLaunchBrowser) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        boolean found = false;
        for (int cur = 0; cur < clients.size(); ++cur) {
            ClientAppConfig ca = clients.get(cur);
            if (!UrlLauncher.class.getName().equals(ca.className)) continue;
            ca.disabled = !shouldLaunchBrowser;
            found = true;
            break;
        }
        if (shouldLaunchBrowser && !found) {
            ClientAppConfig ca = new ClientAppConfig(UrlLauncher.class.getName(), "consoleBrowser", "http://127.0.0.1:7657", 5L, false);
            clients.add(ca);
        }
        ClientAppConfig.writeClientAppConfig(this._context, clients);
    }

    public static class UpdateWrapperManagerAndRekeyTask
    implements Runnable {
        private int _exitCode;

        public UpdateWrapperManagerAndRekeyTask(int exitCode) {
            this._exitCode = exitCode;
        }

        public void run() {
            try {
                ContextHelper.getContext(null).router().killKeys();
                WrapperManager.signalStopped((int)this._exitCode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static class UpdateWrapperManagerTask
    implements Runnable {
        private int _exitCode;

        public UpdateWrapperManagerTask(int exitCode) {
            this._exitCode = exitCode;
        }

        public void run() {
            try {
                WrapperManager.signalStopped((int)this._exitCode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

