/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.RouterConsoleRunner;

public class ConfigClientsHelper
extends HelperBase {
    private String _edit;

    public void setEdit(String edit) {
        if (edit == null) {
            return;
        }
        String xStart = this._("Edit");
        if (edit.startsWith(xStart + "<span class=hide> ") && edit.endsWith("</span>")) {
            this._edit = edit.substring(xStart.length() + 18, edit.length() - 7);
        } else if (edit.startsWith("Edit ")) {
            this._edit = edit.substring(5);
        } else if (edit.startsWith(xStart + ' ')) {
            this._edit = edit.substring(xStart.length() + 1);
        } else if (this._("Add Client").equals(edit)) {
            this._edit = "new";
        }
    }

    public String getForm1() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table>\n");
        buf.append("<tr><th align=\"right\">" + this._("Client") + "</th><th>" + this._("Run at Startup?") + "</th><th>" + this._("Control") + "</th><th align=\"left\">" + this._("Class and arguments") + "</th></tr>\n");
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        for (int cur = 0; cur < clients.size(); ++cur) {
            ClientAppConfig ca = clients.get(cur);
            this.renderForm(buf, "" + cur, ca.clientName, false, !ca.disabled, "webConsole".equals(ca.clientName) || "Web console".equals(ca.clientName), ca.className + (ca.args != null ? " " + ca.args : ""), ("" + cur).equals(this._edit), true, false, false, true, ca.disabled);
        }
        if ("new".equals(this._edit)) {
            this.renderForm(buf, "" + clients.size(), "", false, false, false, "", true, false, false, false, false, false);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    public String getForm2() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table>\n");
        buf.append("<tr><th align=\"right\">" + this._("WebApp") + "</th><th>" + this._("Run at Startup?") + "</th><th>" + this._("Control") + "</th><th align=\"left\">" + this._("Description") + "</th></tr>\n");
        Properties props = RouterConsoleRunner.webAppProperties();
        TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
        for (String string : keys) {
            if (!string.startsWith("webapps.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("webapps.".length(), string.lastIndexOf(".startOnLoad"));
            String val = props.getProperty(string);
            this.renderForm(buf, app, app, !"addressbook".equals(app), "true".equals(val), "routerconsole".equals(app), app + ".war", false, false, false, false, false, true);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    public boolean showPlugins() {
        return PluginStarter.pluginsEnabled(this._context);
    }

    public String getForm3() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table>\n");
        buf.append("<tr><th align=\"right\">" + this._("Plugin") + "</th><th>" + this._("Run at Startup?") + "</th><th>" + this._("Control") + "</th><th align=\"left\">" + this._("Description") + "</th></tr>\n");
        Properties props = PluginStarter.pluginProperties();
        TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
        for (String string : keys) {
            String updateURL;
            if (!string.startsWith("plugin.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("plugin.".length(), string.lastIndexOf(".startOnLoad"));
            String val = props.getProperty(string);
            Properties appProps = PluginStarter.pluginProperties(this._context, app);
            if (appProps.isEmpty()) continue;
            StringBuilder desc = new StringBuilder(256);
            desc.append("<table border=\"0\">").append("<tr><td><b>").append(this._("Version")).append("<td>").append(ConfigClientsHelper.stripHTML(appProps, "version")).append("<tr><td><b>").append(this._("Signed by")).append("<td>");
            String s = ConfigClientsHelper.stripHTML(appProps, "signer");
            if (s != null) {
                if (s.indexOf("@") > 0) {
                    desc.append("<a href=\"mailto:").append(s).append("\">").append(s).append("</a>");
                } else {
                    desc.append(s);
                }
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "date")) != null) {
                long ms = 0L;
                try {
                    ms = Long.parseLong(s);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (ms > 0L) {
                    String date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(ms));
                    desc.append("<tr><td><b>").append(this._("Date")).append("<td>").append(date);
                }
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "author")) != null) {
                desc.append("<tr><td><b>").append(this._("Author")).append("<td>");
                if (s.indexOf("@") > 0) {
                    desc.append("<a href=\"mailto:").append(s).append("\">").append(s).append("</a>");
                } else {
                    desc.append(s);
                }
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "description_" + Messages.getLanguage(this._context))) == null) {
                s = ConfigClientsHelper.stripHTML(appProps, "description");
            }
            if (s != null) {
                desc.append("<tr><td><b>").append(this._("Description")).append("<td>").append(s);
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "license")) != null) {
                desc.append("<tr><td><b>").append(this._("License")).append("<td>").append(s);
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "websiteURL")) != null) {
                desc.append("<tr><td>").append("<a href=\"").append(s).append("\">").append(this._("Website")).append("</a><td>&nbsp;");
            }
            if ((updateURL = ConfigClientsHelper.stripHTML(appProps, "updateURL")) != null) {
                desc.append("<tr><td>").append("<a href=\"").append(updateURL).append("\">").append(this._("Update link")).append("</a><td>&nbsp;");
            }
            desc.append("</table>");
            boolean enableStop = Boolean.valueOf(appProps.getProperty("disableStop")) == false;
            boolean enableStart = !PluginStarter.isPluginRunning(app, this._context);
            this.renderForm(buf, app, app, false, "true".equals(val), false, desc.toString(), false, false, updateURL != null, enableStop &= PluginStarter.isPluginRunning(app, this._context), true, enableStart);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    private void renderForm(StringBuilder buf, String index, String name, boolean urlify, boolean enabled, boolean ro, String desc, boolean edit, boolean showEditButton, boolean showUpdateButton, boolean showStopButton, boolean showDeleteButton, boolean showStartButton) {
        buf.append("<tr><td class=\"mediumtags\" align=\"right\" width=\"25%\">");
        if (urlify && enabled) {
            String link = "/";
            if (!"routerconsole".equals(name)) {
                link = link + name + "/";
            }
            buf.append("<a href=\"").append(link).append("\">").append(this._(name)).append("</a>");
        } else if (edit && !ro) {
            buf.append("<input type=\"text\" name=\"name").append(index).append("\" value=\"");
            if (name.length() > 0) {
                buf.append(this._(name));
            }
            buf.append("\" >");
        } else if (name.length() > 0) {
            buf.append(this._(name));
        }
        buf.append("</td><td align=\"center\" width=\"10%\"><input type=\"checkbox\" class=\"optbox\" name=\"").append(index).append(".enabled\" value=\"true\" ");
        if (enabled) {
            buf.append("checked=\"true\" ");
            if (ro) {
                buf.append("disabled=\"true\" ");
            }
        }
        buf.append("></td><td align=\"center\" width=\"15%\">");
        if (showStartButton && !ro && !edit) {
            buf.append("<button type=\"submit\" name=\"action\" value=\"Start ").append(index).append("\" >" + this._("Start") + "<span class=hide> ").append(index).append("</span></button>");
        }
        if (showEditButton && !edit && !ro) {
            buf.append("<button type=\"submit\" name=\"edit\" value=\"Edit ").append(index).append("\" >" + this._("Edit") + "<span class=hide> ").append(index).append("</span></button>");
        }
        if (showStopButton && !edit) {
            buf.append("<button type=\"submit\" name=\"action\" value=\"Stop ").append(index).append("\" >" + this._("Stop") + "<span class=hide> ").append(index).append("</span></button>");
        }
        if (showUpdateButton && !edit && !ro) {
            buf.append("<button type=\"submit\" name=\"action\" value=\"Check ").append(index).append("\" >" + this._("Check for updates") + "<span class=hide> ").append(index).append("</span></button>");
            buf.append("<button type=\"submit\" name=\"action\" value=\"Update ").append(index).append("\" >" + this._("Update") + "<span class=hide> ").append(index).append("</span></button>");
        }
        if (showDeleteButton && !edit && !ro) {
            buf.append("<button type=\"submit\" name=\"action\" value=\"Delete ").append(index).append("\" onclick=\"if (!confirm('").append(this._("Are you sure you want to delete {0}?", this._(name))).append("')) { return false; }\">").append(this._("Delete")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        buf.append("</td><td align=\"left\" width=\"50%\">");
        if (edit && !ro) {
            buf.append("<input type=\"text\" size=\"80\" name=\"desc").append(index).append("\" value=\"");
            buf.append(desc);
            buf.append("\" >");
        } else {
            buf.append(desc);
        }
        buf.append("</td></tr>\n");
    }

    static String stripHTML(Properties props, String key) {
        String orig = props.getProperty(key);
        if (orig == null) {
            return null;
        }
        String t1 = orig.replace('<', ' ');
        String rv = t1.replace('>', ' ');
        return rv;
    }
}

