/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.PluginUpdateChecker;
import net.i2p.router.web.PluginUpdateHandler;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.WebAppStarter;
import org.mortbay.jetty.Server;

public class ConfigClientsHandler
extends FormHandler {
    private Map _settings;

    protected void processForm() {
        String app;
        if (this._action.length() <= 0) {
            String url = this.getJettyString("pluginURL");
            this._action = url != null && url.length() > 0 ? "Install Plugin" : "Save Client Configuration";
        }
        if (this._action.equals(this._("Save Client Configuration"))) {
            this.saveClientChanges();
            return;
        }
        if (this._action.equals(this._("Save WebApp Configuration"))) {
            this.saveWebAppChanges();
            return;
        }
        if (this._action.equals(this._("Save Plugin Configuration"))) {
            this.savePluginChanges();
            return;
        }
        if (this._action.equals(this._("Install Plugin"))) {
            this.installPlugin();
            return;
        }
        if (this._action.startsWith("Start ")) {
            app = this._action.substring(6);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.startClient(appnum);
            } else {
                List<String> plugins = PluginStarter.getPlugins();
                if (plugins.contains(app)) {
                    this.startPlugin(app);
                } else {
                    this.startWebApp(app);
                }
            }
            return;
        }
        if (this._action.startsWith("Delete ")) {
            app = this._action.substring(7);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.deleteClient(appnum);
            } else {
                try {
                    PluginStarter.stopPlugin(this._context, app);
                    PluginStarter.deletePlugin(this._context, app);
                    this.addFormNotice(this._("Deleted plugin {0}", app));
                }
                catch (Throwable e) {
                    this.addFormError(this._("Error deleting plugin {0}", app) + ": " + e);
                    this._log.error("Error deleting plugin " + app, e);
                }
            }
            return;
        }
        if (this._action.startsWith("Stop ")) {
            app = this._action.substring(5);
            try {
                PluginStarter.stopPlugin(this._context, app);
                this.addFormNotice(this._("Stopped plugin {0}", app));
            }
            catch (Throwable e) {
                this.addFormError(this._("Error stopping plugin {0}", app) + ": " + e);
                this._log.error("Error stopping plugin " + app, e);
            }
            return;
        }
        if (this._action.startsWith("Update ")) {
            app = this._action.substring(7);
            this.updatePlugin(app);
            return;
        }
        if (this._action.startsWith("Check ")) {
            app = this._action.substring(6);
            this.checkPlugin(app);
            return;
        }
        String xStart = this._("Start");
        if (this._action.toLowerCase().startsWith(xStart + "<span class=hide> ") && this._action.toLowerCase().endsWith("</span>")) {
            String app2 = this._action.substring(xStart.length() + 18, this._action.length() - 7);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app2);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.startClient(appnum);
            } else {
                List<String> plugins = PluginStarter.getPlugins();
                if (plugins.contains(app2)) {
                    this.startPlugin(app2);
                } else {
                    this.startWebApp(app2);
                }
            }
        } else {
            this.addFormError(this._("Unsupported") + ' ' + this._action + '.');
        }
    }

    public void setSettings(Map settings) {
        this._settings = new HashMap(settings);
    }

    private void saveClientChanges() {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        for (int cur = 0; cur < clients.size(); ++cur) {
            String desc;
            ClientAppConfig ca = clients.get(cur);
            Object val = this._settings.get(cur + ".enabled");
            if (!"webConsole".equals(ca.clientName) && !"Web console".equals(ca.clientName)) {
                boolean bl = ca.disabled = val == null;
            }
            if ((desc = this.getJettyString("desc" + cur)) == null) continue;
            int spc = desc.indexOf(" ");
            String clss = desc;
            String args = null;
            if (spc >= 0) {
                clss = desc.substring(0, spc);
                args = desc.substring(spc + 1);
            }
            ca.className = clss;
            ca.args = args;
            ca.clientName = this.getJettyString("name" + cur);
        }
        int newClient = clients.size();
        String newDesc = this.getJettyString("desc" + newClient);
        if (newDesc != null && newDesc.trim().length() > 0) {
            String name;
            int spc = newDesc.indexOf(" ");
            String clss = newDesc;
            String args = null;
            if (spc >= 0) {
                clss = newDesc.substring(0, spc);
                args = newDesc.substring(spc + 1);
            }
            if ((name = this.getJettyString("name" + newClient)) == null || name.trim().length() <= 0) {
                name = "new client";
            }
            ClientAppConfig ca = new ClientAppConfig(clss, name, args, 120000L, this._settings.get(newClient + ".enabled") != null);
            clients.add(ca);
            this.addFormNotice(this._("New client added") + ": " + name + " (" + clss + ").");
        }
        ClientAppConfig.writeClientAppConfig(this._context, clients);
        this.addFormNotice(this._("Client configuration saved successfully - restart required to take effect."));
    }

    private String getJettyString(String key) {
        String[] arr = (String[])this._settings.get(key);
        if (arr == null) {
            return null;
        }
        return arr[0];
    }

    private void startClient(int i) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        if (i >= clients.size()) {
            this.addFormError(this._("Bad client index."));
            return;
        }
        ClientAppConfig ca = clients.get(i);
        LoadClientAppsJob.runClient(ca.className, ca.clientName, LoadClientAppsJob.parseArgs(ca.args), this._log);
        this.addFormNotice(this._("Client") + ' ' + this._(ca.clientName) + ' ' + this._("started") + '.');
    }

    private void deleteClient(int i) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        if (i < 0 || i >= clients.size()) {
            this.addFormError(this._("Bad client index."));
            return;
        }
        ClientAppConfig ca = clients.remove(i);
        ClientAppConfig.writeClientAppConfig(this._context, clients);
        this.addFormNotice(this._("Client") + ' ' + this._(ca.clientName) + ' ' + this._("deleted") + '.');
    }

    private void saveWebAppChanges() {
        Properties props = RouterConsoleRunner.webAppProperties();
        Set<Object> keys = props.keySet();
        boolean cur = false;
        for (String string : keys) {
            if (!string.startsWith("webapps.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("webapps.".length(), string.lastIndexOf(".startOnLoad"));
            Object val = this._settings.get(app + ".enabled");
            if ("routerconsole".equals(app)) continue;
            props.setProperty(string, "" + (val != null));
        }
        RouterConsoleRunner.storeWebAppProperties(props);
        this.addFormNotice(this._("WebApp configuration saved."));
    }

    private void savePluginChanges() {
        Properties props = PluginStarter.pluginProperties();
        Set<Object> keys = props.keySet();
        boolean cur = false;
        for (String string : keys) {
            if (!string.startsWith("plugin.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("plugin.".length(), string.lastIndexOf(".startOnLoad"));
            Object val = this._settings.get(app + ".enabled");
            props.setProperty(string, "" + (val != null));
        }
        PluginStarter.storePluginProperties(props);
        this.addFormNotice(this._("Plugin configuration saved."));
    }

    private void startWebApp(String app) {
        Server s = WebAppStarter.getConsoleServer();
        if (s != null) {
            try {
                File path = new File(this._context.getBaseDir(), "webapps");
                path = new File(path, app + ".war");
                WebAppStarter.startWebApp(this._context, s, app, path.getAbsolutePath());
                this.addFormNotice(this._("WebApp") + " <a href=\"/" + app + "/\">" + this._(app) + "</a> " + this._("started") + '.');
            }
            catch (Throwable e) {
                this.addFormError(this._("Failed to start") + ' ' + this._(app) + " " + e + '.');
                this._log.error("Failed to start webapp " + app, e);
            }
            return;
        }
        this.addFormError(this._("Failed to find server."));
    }

    private void installPlugin() {
        String url = this.getJettyString("pluginURL");
        if (url == null || url.length() <= 0) {
            this.addFormError(this._("No plugin URL specified."));
            return;
        }
        this.installPlugin(url);
    }

    private void updatePlugin(String app) {
        Properties props = PluginStarter.pluginProperties(this._context, app);
        String url = props.getProperty("updateURL");
        if (url == null) {
            this.addFormError(this._("No update URL specified for {0}", app));
            return;
        }
        this.installPlugin(url);
    }

    private void installPlugin(String url) {
        if ("true".equals(System.getProperty("net.i2p.router.web.UpdateHandler.updateInProgress"))) {
            this.addFormError(this._("Plugin or update download already in progress."));
            return;
        }
        PluginUpdateHandler puh = PluginUpdateHandler.getInstance(this._context);
        if (puh.isRunning()) {
            this.addFormError(this._("Plugin or update download already in progress."));
            return;
        }
        puh.update(url);
        this.addFormNotice(this._("Downloading plugin from {0}", url));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void checkPlugin(String app) {
        if ("true".equals(System.getProperty("net.i2p.router.web.UpdateHandler.updateInProgress"))) {
            this.addFormError(this._("Plugin or update download already in progress."));
            return;
        }
        PluginUpdateChecker puc = PluginUpdateChecker.getInstance(this._context);
        if (puc.isRunning()) {
            this.addFormError(this._("Plugin or update download already in progress."));
            return;
        }
        puc.update(app);
        this.addFormNotice(this._("Checking plugin {0} for updates", app));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startPlugin(String app) {
        try {
            PluginStarter.startPlugin(this._context, app);
            this.addFormNotice(this._("Started plugin {0}", app));
        }
        catch (Throwable e) {
            this.addFormError(this._("Error starting plugin {0}", app) + ": " + e);
            this._log.error("Error starting plugin " + app, e);
        }
    }
}

