/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import net.i2p.router.web.FormHandler;

public class ConfigAdvancedHandler
extends FormHandler {
    private boolean _shouldSave;
    private String _config;

    protected void processForm() {
        if (this._shouldSave) {
            this.saveChanges();
        }
    }

    public void setShouldsave(String moo) {
        this._shouldSave = true;
    }

    public void setConfig(String val) {
        this._config = val;
    }

    private void saveChanges() {
        HashSet<Object> unsetKeys = new HashSet<Object>(this._context.router().getConfigMap().keySet());
        if (this._config != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this._config.getBytes())));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    int eq = line.indexOf(61);
                    if (eq == -1 || eq >= line.length() - 1) continue;
                    String string = line.substring(0, eq).trim();
                    String val = line.substring(eq + 1).trim();
                    this._context.router().setConfigSetting(string, val);
                    unsetKeys.remove(string);
                }
            }
            catch (IOException ioe) {
                this.addFormError(this._("Error updating the configuration - please see the error logs"));
                return;
            }
            for (String string : unsetKeys) {
                this._context.router().removeConfigSetting(string);
            }
            boolean bl = this._context.router().saveConfig();
            if (bl) {
                this.addFormNotice(this._("Configuration saved successfully"));
            } else {
                this.addFormNotice(this._("Error saving the configuration (applied but not saved) - please see the error logs"));
            }
        }
    }
}

