/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;

public class CSSHelper
extends HelperBase {
    public static final String PROP_THEME_NAME = "routerconsole.theme";
    public static final String DEFAULT_THEME = "light";
    public static final String BASE_THEME_PATH = "/themes/console/";
    private static final String FORCE = "classic";
    public static final String PROP_REFRESH = "routerconsole.summaryRefresh";
    public static final String DEFAULT_REFRESH = "60";

    public String getTheme(String userAgent) {
        String url = BASE_THEME_PATH;
        if (userAgent != null && userAgent.contains("MSIE")) {
            url = url + "classic/";
        } else {
            if (this._context == null) {
                throw new IllegalStateException("No contexts. This is usually because the router is either starting up or shutting down.");
            }
            String theme = this._context.getProperty(PROP_THEME_NAME, DEFAULT_THEME);
            url = url + theme + "/";
        }
        return url;
    }

    public void setLang(String lang) {
        if (lang != null && lang.length() > 0) {
            this._context.router().setConfigSetting("routerconsole.lang", lang);
        }
    }

    public String getLang() {
        return Messages.getLanguage(this._context);
    }

    public void setRefresh(String r) {
        this._context.router().setConfigSetting(PROP_REFRESH, r);
        this._context.router().saveConfig();
    }

    public String getRefresh() {
        return this._context.getProperty(PROP_REFRESH, DEFAULT_REFRESH);
    }

    public String title(String s) {
        StringBuilder buf = new StringBuilder(128);
        buf.append("<title>").append(this._("I2P Router Console")).append(" - ").append(this._(s)).append("</title>");
        return buf.toString();
    }
}

