/*
 * Decompiled with CFR 0.152.
 */
package org.xlattice.crypto.filters;

import org.xlattice.crypto.filters.BloomSHA1;

public class KeySelector {
    private int m;
    private int k;
    private byte[] b;
    private int offset;
    private int length;
    private int[] bitOffset;
    private int[] wordOffset;
    private BitSelector bitSel;
    private WordSelector wordSel;
    public static final int[] UNMASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    public static final int[] MASK = new int[]{-1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, Short.MIN_VALUE};
    public static final int TWO_UP_15 = 32768;

    public KeySelector(int m, int k, int[] bitOffset, int[] wordOffset) {
        this.m = m;
        this.k = k;
        this.bitOffset = bitOffset;
        this.wordOffset = wordOffset;
        this.bitSel = new GenericBitSelector();
        this.wordSel = new GenericWordSelector();
    }

    public void getOffsets(byte[] key) {
        this.getOffsets(key, 0, key.length);
    }

    public void getOffsets(byte[] key, int off, int len) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (len < 20) {
            throw new IllegalArgumentException("key must be at least 20 bytes long");
        }
        this.b = key;
        this.offset = off;
        this.length = len;
        this.bitSel.getBitSelectors();
        this.wordSel.getWordSelectors();
    }

    String itoh(int i) {
        return BloomSHA1.itoh(i);
    }

    String btoh(byte b) {
        return BloomSHA1.btoh(b);
    }

    public class GenericWordSelector
    implements WordSelector {
        public void getWordSelectors() {
            int stride = KeySelector.this.m - 5;
            int curBit = KeySelector.this.k * 5 + KeySelector.this.offset * 8;
            for (int j = 0; j < KeySelector.this.k; ++j) {
                int curByte = curBit / 8;
                int bitsUnused = (curByte + 1) * 8 - curBit;
                if (bitsUnused > stride) {
                    ((KeySelector)KeySelector.this).wordOffset[j] = (0xFF & KeySelector.this.b[curByte]) >> bitsUnused - stride & UNMASK[stride];
                } else if (bitsUnused == stride) {
                    ((KeySelector)KeySelector.this).wordOffset[j] = KeySelector.this.b[curByte] & UNMASK[stride];
                } else {
                    ((KeySelector)KeySelector.this).wordOffset[j] = KeySelector.this.b[curByte] & UNMASK[bitsUnused];
                    int bitsToGet = stride - bitsUnused;
                    if (bitsToGet >= 8) {
                        int[] nArray = KeySelector.this.wordOffset;
                        int n = j;
                        nArray[n] = nArray[n] | (0xFF & KeySelector.this.b[curByte + 1]) << bitsUnused;
                        if ((bitsToGet -= 8) > 0) {
                            int[] nArray2 = KeySelector.this.wordOffset;
                            int n2 = j;
                            nArray2[n2] = nArray2[n2] | (0xFF & KeySelector.this.b[curByte + 2]) >> 8 - bitsToGet << stride - bitsToGet;
                        }
                    } else {
                        int[] nArray = KeySelector.this.wordOffset;
                        int n = j;
                        nArray[n] = nArray[n] | (KeySelector.this.b[curByte + 1] >> 8 - bitsToGet & UNMASK[bitsToGet]) << bitsUnused;
                    }
                }
                curBit += stride;
            }
        }
    }

    public class GenericBitSelector
    implements BitSelector {
        public void getBitSelectors() {
            int curBit = 8 * KeySelector.this.offset;
            for (int j = 0; j < KeySelector.this.k; ++j) {
                int curByte = curBit / 8;
                int bitsUnused = (curByte + 1) * 8 - curBit;
                ((KeySelector)KeySelector.this).bitOffset[j] = bitsUnused > 5 ? (0xFF & KeySelector.this.b[curByte]) >> bitsUnused - 5 & UNMASK[5] : (bitsUnused == 5 ? KeySelector.this.b[curByte] & UNMASK[5] : KeySelector.this.b[curByte] & UNMASK[bitsUnused] | (0xFF & KeySelector.this.b[curByte + 1]) >> 3 & MASK[bitsUnused]);
                curBit += 5;
            }
        }
    }

    public static interface WordSelector {
        public void getWordSelectors();
    }

    public static interface BitSelector {
        public void getBitSelectors();
    }
}

