/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import net.i2p.util.VersionComparator;

public class SecureFileOutputStream
extends FileOutputStream {
    private static final boolean canSetPerms = new VersionComparator().compare(System.getProperty("java.version"), "1.6") >= 0;

    public SecureFileOutputStream(String file) throws FileNotFoundException {
        super(file);
        SecureFileOutputStream.setPerms(new File(file));
    }

    public SecureFileOutputStream(String file, boolean append) throws FileNotFoundException {
        super(file, append);
        SecureFileOutputStream.setPerms(new File(file));
    }

    public SecureFileOutputStream(File file) throws FileNotFoundException {
        super(file);
        SecureFileOutputStream.setPerms(file);
    }

    public SecureFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(file, append);
        SecureFileOutputStream.setPerms(file);
    }

    public static void setPerms(File f) {
        if (!canSetPerms) {
            return;
        }
        try {
            f.setReadable(false, false);
            f.setReadable(true, true);
            f.setWritable(false, false);
            f.setWritable(true, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

