/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import net.i2p.util.VersionComparator;

public class SecureDirectory
extends File {
    private static final boolean canSetPerms = new VersionComparator().compare(System.getProperty("java.version"), "1.6") >= 0;
    private static final boolean isNotWindows = !System.getProperty("os.name").startsWith("Win");

    public SecureDirectory(String pathname) {
        super(pathname);
    }

    public SecureDirectory(String parent, String child) {
        super(parent, child);
    }

    public SecureDirectory(File parent, String child) {
        super(parent, child);
    }

    public boolean mkdir() {
        boolean rv = super.mkdir();
        if (rv) {
            this.setPerms();
        }
        return rv;
    }

    public boolean mkdirs() {
        boolean rv = super.mkdirs();
        if (rv) {
            this.setPerms();
        }
        return rv;
    }

    private void setPerms() {
        if (!canSetPerms) {
            return;
        }
        try {
            this.setReadable(false, false);
            this.setReadable(true, true);
            this.setWritable(false, false);
            this.setWritable(true, true);
            if (isNotWindows) {
                this.setExecutable(false, false);
                this.setExecutable(true, true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

