/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.LogConsoleBuffer;
import net.i2p.util.LogLimit;
import net.i2p.util.LogRecord;
import net.i2p.util.LogWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    public static final String CONFIG_LOCATION_PROP = "loggerConfigLocation";
    public static final String FILENAME_OVERRIDE_PROP = "loggerFilenameOverride";
    public static final String CONFIG_LOCATION_DEFAULT = "logger.config";
    public static final char DATE = 'd';
    public static final char CLASS = 'c';
    public static final char THREAD = 't';
    public static final char PRIORITY = 'p';
    public static final char MESSAGE = 'm';
    public static final String PROP_FORMAT = "logger.format";
    public static final String PROP_DATEFORMAT = "logger.dateFormat";
    public static final String PROP_FILENAME = "logger.logFileName";
    public static final String PROP_FILESIZE = "logger.logFileSize";
    public static final String PROP_ROTATIONLIMIT = "logger.logRotationLimit";
    public static final String PROP_DISPLAYONSCREEN = "logger.displayOnScreen";
    public static final String PROP_CONSOLEBUFFERSIZE = "logger.consoleBufferSize";
    public static final String PROP_DISPLAYONSCREENLEVEL = "logger.minimumOnScreenLevel";
    public static final String PROP_DEFAULTLEVEL = "logger.defaultLevel";
    public static final String PROP_RECORD_PREFIX = "logger.record.";
    public static final String DEFAULT_FORMAT = "d p [t] c: m";
    public static final String DEFAULT_DATEFORMAT = "HH:mm:ss.SSS";
    public static final String DEFAULT_FILENAME = "logs/log-#.txt";
    public static final String DEFAULT_FILESIZE = "10m";
    public static final boolean DEFAULT_DISPLAYONSCREEN = true;
    public static final int DEFAULT_CONSOLEBUFFERSIZE = 20;
    public static final String DEFAULT_ROTATIONLIMIT = "2";
    public static final String DEFAULT_DEFAULTLEVEL = "ERROR";
    public static final String DEFAULT_ONSCREENLEVEL = "CRIT";
    private I2PAppContext _context;
    private Log _log;
    private long _configLastRead;
    private File _locationFile;
    private LinkedBlockingQueue<LogRecord> _records;
    private Set<LogLimit> _limits;
    private ConcurrentHashMap<Object, Log> _logs;
    private LogWriter _writer;
    private int _defaultLimit;
    private char[] _format;
    private SimpleDateFormat _dateFormat;
    private String _dateFormatPattern;
    private String _baseLogfilename;
    private int _fileSize;
    private int _rotationLimit;
    private int _onScreenLimit;
    private boolean _displayOnScreen;
    private int _consoleBufferSize;
    private LogConsoleBuffer _consoleBuffer;
    private boolean _alreadyNoticedMissingConfig;
    private static int __id = 0;

    public LogManager(I2PAppContext context) {
        this._displayOnScreen = true;
        this._alreadyNoticedMissingConfig = false;
        this._records = new LinkedBlockingQueue();
        this._limits = new ConcurrentHashSet<LogLimit>();
        this._logs = new ConcurrentHashMap(128);
        this._defaultLimit = 40;
        this._configLastRead = 0L;
        this._context = context;
        this._log = this.getLog(LogManager.class);
        String location = context.getProperty(CONFIG_LOCATION_PROP, CONFIG_LOCATION_DEFAULT);
        this.setConfig(location);
        this._consoleBuffer = new LogConsoleBuffer(context);
        this._writer = new LogWriter(this);
        I2PThread t = new I2PThread(this._writer);
        t.setName("LogWriter");
        t.setDaemon(true);
        t.start();
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
    }

    private LogManager() {
    }

    public Log getLog(Class cls) {
        return this.getLog(cls, null);
    }

    public Log getLog(String name) {
        return this.getLog(null, name);
    }

    public Log getLog(Class cls, String name) {
        String scope = Log.getScope(name, cls);
        boolean isNew = false;
        Log rv = this._logs.get(scope);
        if (rv == null) {
            rv = new Log(this, cls, name);
            this._logs.putIfAbsent(scope, rv);
            isNew = true;
        }
        if (isNew) {
            this.updateLimit(rv);
        }
        return rv;
    }

    public List<Log> getLogs() {
        return new ArrayList<Log>(this._logs.values());
    }

    void addLog(Log log) {
        this._logs.putIfAbsent(log.getScope(), log);
        this.updateLimit(log);
    }

    public LogConsoleBuffer getBuffer() {
        return this._consoleBuffer;
    }

    public void setDisplayOnScreen(boolean yes) {
        this._displayOnScreen = yes;
    }

    public boolean displayOnScreen() {
        return this._displayOnScreen;
    }

    public int getDisplayOnScreenLevel() {
        return this._onScreenLimit;
    }

    public void setDisplayOnScreenLevel(int level) {
        this._onScreenLimit = level;
    }

    public int getConsoleBufferSize() {
        return this._consoleBufferSize;
    }

    public void setConsoleBufferSize(int numRecords) {
        this._consoleBufferSize = numRecords;
    }

    public void setConfig(String filename) {
        this._locationFile = new File(filename);
        if (!this._locationFile.isAbsolute()) {
            this._locationFile = new File(this._context.getConfigDir(), filename);
        }
        this.loadConfig();
    }

    public String currentFile() {
        return this._writer.currentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRecord(LogRecord record) {
        this._records.offer(record);
        int numRecords = this._records.size();
        if (numRecords > 100) {
            LogWriter logWriter = this._writer;
            synchronized (logWriter) {
                this._writer.notifyAll();
            }
        }
    }

    void rereadConfig() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Rereading configuration file");
        }
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        File cfgFile = this._locationFile;
        if (!cfgFile.exists()) {
            if (!this._alreadyNoticedMissingConfig) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Log file " + this._locationFile.getAbsolutePath() + " does not exist");
                }
                this._alreadyNoticedMissingConfig = true;
            }
            this.parseConfig(new Properties());
            this.updateLimits();
            return;
        }
        this._alreadyNoticedMissingConfig = false;
        if (this._configLastRead > 0L && this._configLastRead >= cfgFile.lastModified()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Short circuiting config read (last read: " + (this._context.clock().now() - this._configLastRead) + "ms ago, config file modified " + (this._context.clock().now() - cfgFile.lastModified()) + "ms ago");
            }
            return;
        }
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(cfgFile);
            p.load(fis);
            this._configLastRead = this._context.clock().now();
        }
        catch (IOException ioe) {
            System.err.println("Error loading logger config from " + cfgFile.getAbsolutePath());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        this.parseConfig(p);
        this.updateLimits();
    }

    private void parseConfig(Properties config) {
        String str;
        String df;
        String fmt = config.getProperty(PROP_FORMAT, DEFAULT_FORMAT);
        this._format = fmt.toCharArray();
        this._dateFormatPattern = df = config.getProperty(PROP_DATEFORMAT, DEFAULT_DATEFORMAT);
        this._dateFormat = new SimpleDateFormat(df);
        String disp = config.getProperty(PROP_DISPLAYONSCREEN);
        this._displayOnScreen = disp == null ? true : ("TRUE".equals(disp.toUpperCase().trim()) ? true : "YES".equals(disp.toUpperCase().trim()));
        String filenameOverride = this._context.getProperty(FILENAME_OVERRIDE_PROP);
        this._baseLogfilename = filenameOverride != null ? filenameOverride : config.getProperty(PROP_FILENAME, DEFAULT_FILENAME);
        this._fileSize = LogManager.getFileSize(config.getProperty(PROP_FILESIZE, DEFAULT_FILESIZE));
        this._rotationLimit = -1;
        try {
            str = config.getProperty(PROP_ROTATIONLIMIT);
            this._rotationLimit = Integer.parseInt(config.getProperty(PROP_ROTATIONLIMIT, DEFAULT_ROTATIONLIMIT));
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid rotation limit");
            nfe.printStackTrace();
        }
        this._defaultLimit = Log.getLevel(config.getProperty(PROP_DEFAULTLEVEL, DEFAULT_DEFAULTLEVEL));
        this._onScreenLimit = Log.getLevel(config.getProperty(PROP_DISPLAYONSCREENLEVEL, DEFAULT_ONSCREENLEVEL));
        try {
            str = config.getProperty(PROP_CONSOLEBUFFERSIZE);
            this._consoleBufferSize = str == null ? 20 : Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid console buffer size");
            nfe.printStackTrace();
            this._consoleBufferSize = 20;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Log set to use the base log file as " + this._baseLogfilename);
        }
        this.parseLimits(config);
    }

    private void parseLimits(Properties config) {
        this.parseLimits(config, PROP_RECORD_PREFIX);
    }

    /*
     * WARNING - void declaration
     */
    private void parseLimits(Properties config, String recordPrefix) {
        this._limits.clear();
        if (config != null) {
            for (String string : config.keySet()) {
                void var4_4;
                LogLimit lim;
                String val = config.getProperty(string);
                if (recordPrefix != null) {
                    if (!string.startsWith(recordPrefix)) continue;
                    String string2 = string.substring(recordPrefix.length());
                }
                if (this._limits.contains(lim = new LogLimit((String)var4_4, Log.getLevel(val)))) continue;
                this._limits.add(lim);
            }
        }
        this.updateLimits();
    }

    public void setLimits(Properties limits) {
        this.parseLimits(limits, null);
    }

    public boolean setDateFormat(String format) {
        if (format == null) {
            return false;
        }
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(format);
            this._dateFormatPattern = format;
            this._dateFormat = fmt;
            return true;
        }
        catch (IllegalArgumentException iae) {
            this.getLog(LogManager.class).error("Date format is invalid [" + format + "]", iae);
            return false;
        }
    }

    public void setFileSize(int numBytes) {
        if (numBytes > 0) {
            this._fileSize = numBytes;
        }
    }

    public String getDefaultLimit() {
        return Log.toLevelString(this._defaultLimit);
    }

    public void setDefaultLimit(String lim) {
        this._defaultLimit = Log.getLevel(lim);
        this.updateLimits();
    }

    public Properties getLimits() {
        Properties rv = new Properties();
        for (LogLimit lim : this._limits) {
            rv.setProperty(lim.getRootName(), Log.toLevelString(lim.getLimit()));
        }
        return rv;
    }

    public static int getFileSize(String size) {
        try {
            char mod;
            String v = size.trim().toUpperCase();
            if (v.length() < 2) {
                return -1;
            }
            if (v.endsWith("B")) {
                v = v.substring(0, v.length() - 1);
            }
            if (!Character.isDigit(mod = v.charAt(v.length() - 1))) {
                v = v.substring(0, v.length() - 1);
            }
            double val = new DecimalFormat().parse(v.trim()).doubleValue();
            switch (mod) {
                case 'K': {
                    val *= 1024.0;
                    break;
                }
                case 'M': {
                    val *= 1048576.0;
                    break;
                }
                case 'G': {
                    val *= 1.073741824E9;
                    break;
                }
            }
            if (val < 4096.0 || val > 2.147483647E9) {
                return -1;
            }
            return (int)val;
        }
        catch (Throwable t) {
            System.err.println("Error parsing config for filesize: [" + size + "]");
            return -1;
        }
    }

    private void updateLimits() {
        for (Log log : this._logs.values()) {
            this.updateLimit(log);
        }
    }

    private void updateLimit(Log log) {
        List<LogLimit> limits = this.getLimits(log);
        LogLimit max = null;
        LogLimit notMax = null;
        if (limits != null) {
            for (LogLimit cur : limits) {
                if (max == null) {
                    max = cur;
                    continue;
                }
                if (cur.getRootName().length() <= max.getRootName().length()) continue;
                notMax = max;
                max = cur;
            }
        }
        if (max != null) {
            log.setMinimumPriority(max.getLimit());
        } else {
            log.setMinimumPriority(this._defaultLimit);
        }
    }

    private List<LogLimit> getLimits(Log log) {
        ArrayList<LogLimit> limits = null;
        for (LogLimit limit : this._limits) {
            if (!limit.matches(log)) continue;
            if (limits == null) {
                limits = new ArrayList<LogLimit>(4);
            }
            limits.add(limit);
        }
        return limits;
    }

    public String getBaseLogfilename() {
        return this._baseLogfilename;
    }

    public void setBaseLogfilename(String filenamePattern) {
        this._baseLogfilename = filenamePattern;
    }

    public int getFileSize() {
        return this._fileSize;
    }

    public int getRotationLimit() {
        return this._rotationLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfig() {
        String config = this.createConfig();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this._locationFile);
            fos.write(config.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            this.getLog(LogManager.class).error("Error saving the config", ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private String createConfig() {
        StringBuilder buf = new StringBuilder(8192);
        buf.append(PROP_FORMAT).append('=').append(new String(this._format)).append('\n');
        buf.append(PROP_DATEFORMAT).append('=').append(this._dateFormatPattern).append('\n');
        buf.append(PROP_DISPLAYONSCREEN).append('=').append(this._displayOnScreen ? "TRUE" : "FALSE").append('\n');
        String filenameOverride = this._context.getProperty(FILENAME_OVERRIDE_PROP);
        if (filenameOverride == null) {
            buf.append(PROP_FILENAME).append('=').append(this._baseLogfilename).append('\n');
        } else {
            buf.append(PROP_FILENAME).append('=').append(DEFAULT_FILENAME).append('\n');
        }
        if (this._fileSize >= 0x100000) {
            buf.append(PROP_FILESIZE).append('=').append(this._fileSize / 0x100000).append("m\n");
        } else if (this._fileSize >= 1024) {
            buf.append(PROP_FILESIZE).append('=').append(this._fileSize / 1024).append("k\n");
        } else if (this._fileSize > 0) {
            buf.append(PROP_FILESIZE).append('=').append(this._fileSize).append('\n');
        }
        buf.append(PROP_ROTATIONLIMIT).append('=').append(this._rotationLimit).append('\n');
        buf.append(PROP_DEFAULTLEVEL).append('=').append(Log.toLevelString(this._defaultLimit)).append('\n');
        buf.append(PROP_DISPLAYONSCREENLEVEL).append('=').append(Log.toLevelString(this._onScreenLimit)).append('\n');
        buf.append(PROP_CONSOLEBUFFERSIZE).append('=').append(this._consoleBufferSize).append('\n');
        buf.append("# log limit overrides:\n");
        TreeMap<String, String> limits = new TreeMap<String, String>();
        for (LogLimit lim : this._limits) {
            limits.put(lim.getRootName(), Log.toLevelString(lim.getLimit()));
        }
        for (Map.Entry entry : limits.entrySet()) {
            String path = (String)entry.getKey();
            String lim = (String)entry.getValue();
            buf.append(PROP_RECORD_PREFIX).append(path);
            buf.append('=').append(lim).append('\n');
        }
        return buf.toString();
    }

    List<LogRecord> _removeAll() {
        LinkedList<LogRecord> vals = new LinkedList<LogRecord>();
        this._records.drainTo(vals);
        return vals;
    }

    public char[] getFormat() {
        return this._format;
    }

    public void setFormat(char[] fmt) {
        this._format = fmt;
    }

    public SimpleDateFormat getDateFormat() {
        return this._dateFormat;
    }

    public String getDateFormatPattern() {
        return this._dateFormatPattern;
    }

    public static void main(String[] args) {
        I2PAppContext ctx = new I2PAppContext();
        Log l1 = ctx.logManager().getLog("test.1");
        Log l2 = ctx.logManager().getLog("test.2");
        Log l21 = ctx.logManager().getLog("test.2.1");
        Log l = ctx.logManager().getLog("test");
        l.debug("this should fail");
        l.info("this should pass");
        l1.warn("this should pass");
        l1.info("this should fail");
        l2.error("this should fail");
        l21.debug("this should pass");
        l1.error("test exception", new Exception("test"));
        l1.error("test exception", new Exception("test"));
        try {
            Thread.sleep(2000L);
        }
        catch (Throwable t) {
            // empty catch block
        }
        System.exit(0);
    }

    public void shutdown() {
        this._log.log(30, "Shutting down logger");
        this._writer.flushRecords(false);
        this._writer.stopWriting();
    }

    I2PAppContext getContext() {
        return this._context;
    }

    static /* synthetic */ int access$004() {
        return ++__id;
    }

    private class ShutdownHook
    extends Thread {
        private int _id = LogManager.access$004();

        public void run() {
            this.setName("Log " + this._id + " shutdown ");
            LogManager.this.shutdown();
        }
    }
}

