/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

public final class ByteCache {
    private static final Map<Integer, ByteCache> _caches = new HashMap<Integer, ByteCache>(16);
    private static final int MAX_CACHE;
    private Log _log;
    private Queue<ByteArray> _available;
    private int _maxCached;
    private int _entrySize;
    private long _lastOverflow;
    private static final boolean _cache = true;
    private static final int CLEANUP_FREQUENCY = 30000;
    private static final long EXPIRE_PERIOD = 120000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteCache getInstance(int cacheSize, int size) {
        if (cacheSize * size > MAX_CACHE) {
            cacheSize = MAX_CACHE / size;
        }
        Integer sz = size;
        ByteCache cache = null;
        Map<Integer, ByteCache> map = _caches;
        synchronized (map) {
            if (!_caches.containsKey(sz)) {
                _caches.put(sz, new ByteCache(cacheSize, size));
            }
            cache = _caches.get(sz);
        }
        cache.resize(cacheSize);
        return cache;
    }

    public static void clearAll() {
        for (ByteCache bc : _caches.values()) {
            bc.clear();
        }
        I2PAppContext.getGlobalContext().logManager().getLog(ByteCache.class).warn("WARNING: Low memory, clearing byte caches");
    }

    private ByteCache(int maxCachedEntries, int entrySize) {
        this._available = new LinkedBlockingQueue<ByteArray>(maxCachedEntries);
        this._maxCached = maxCachedEntries;
        this._entrySize = entrySize;
        this._lastOverflow = -1L;
        SimpleScheduler.getInstance().addPeriodicEvent(new Cleanup(), 30000L);
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(ByteCache.class);
        I2PAppContext.getGlobalContext().statManager().createRateStat("byteCache.memory." + entrySize, "Memory usage (B)", "Router", new long[]{60000L});
    }

    private void resize(int maxCachedEntries) {
        ByteArray ba;
        if (this._maxCached >= maxCachedEntries) {
            return;
        }
        this._maxCached = maxCachedEntries;
        LinkedBlockingQueue<ByteArray> newLBQ = new LinkedBlockingQueue<ByteArray>(maxCachedEntries);
        while ((ba = this._available.poll()) != null) {
            newLBQ.offer(ba);
        }
        this._available = newLBQ;
    }

    public final ByteArray acquire() {
        ByteArray rv = this._available.poll();
        if (rv != null) {
            return rv;
        }
        this._lastOverflow = System.currentTimeMillis();
        byte[] data = new byte[this._entrySize];
        ByteArray rv2 = new ByteArray(data);
        rv2.setValid(0);
        rv2.setOffset(0);
        return rv2;
    }

    public final void release(ByteArray entry) {
        this.release(entry, true);
    }

    public final void release(ByteArray entry, boolean shouldZero) {
        if (entry == null || entry.getData() == null) {
            return;
        }
        entry.setValid(0);
        entry.setOffset(0);
        if (shouldZero) {
            Arrays.fill(entry.getData(), (byte)0);
        }
        this._available.offer(entry);
    }

    private void clear() {
        this._available.clear();
    }

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        MAX_CACHE = (int)Math.min(0x400000L, Math.max(131072L, maxMemory / 128L));
    }

    private class Cleanup
    implements SimpleTimer.TimedEvent {
        private Cleanup() {
        }

        public void timeReached() {
            I2PAppContext.getGlobalContext().statManager().addRateData("byteCache.memory." + ByteCache.this._entrySize, ByteCache.this._entrySize * ByteCache.this._available.size(), 0L);
            if (System.currentTimeMillis() - ByteCache.this._lastOverflow > 120000L) {
                int toRemove = ByteCache.this._available.size() / 2;
                for (int i = 0; i < toRemove; ++i) {
                    ByteCache.this._available.poll();
                }
                if (toRemove > 0 && ByteCache.this._log.shouldLog(10)) {
                    ByteCache.this._log.debug("Removing " + toRemove + " cached entries of size " + ByteCache.this._entrySize);
                }
            }
        }
    }
}

