/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.RandomSource;

public class BufferedRandomSource
extends RandomSource {
    private byte[] _buffer;
    private int _nextByte;
    private int _nextBit;
    private static volatile long _reseeds;
    private static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final byte[] GOBBLE_MASK;
    private static final double DOUBLE_DENOMENATOR = 9.007199254740992E15;
    private static final float FLOAT_DENOMENATOR = 1.6777216E7f;

    public BufferedRandomSource(I2PAppContext context) {
        this(context, 262144);
    }

    public BufferedRandomSource(I2PAppContext context, int bufferSize) {
        super(context);
        context.statManager().createRateStat("prng.reseedCount", "How many times the prng has been reseeded", "Encryption", new long[]{60000L, 600000L, 3600000L});
        this._buffer = new byte[bufferSize];
        this.refillBuffer();
        this._nextByte = ((int)_reseeds - 1) * 16 * 1024;
    }

    private final void refillBuffer() {
        long before = System.currentTimeMillis();
        this.doRefillBuffer();
        long duration = System.currentTimeMillis() - before;
        if (_reseeds % 1L == 0L) {
            this._context.statManager().addRateData("prng.reseedCount", _reseeds, duration);
        }
    }

    private final synchronized void doRefillBuffer() {
        super.nextBytes(this._buffer);
        this._nextByte = 0;
        this._nextBit = 0;
        ++_reseeds;
    }

    private final synchronized long nextBits(int numBits) {
        long rv = 0L;
        int curBit = 0;
        while (curBit < numBits) {
            int want;
            int gobbleBits;
            if (this._nextBit >= 8) {
                this._nextBit = 0;
                ++this._nextByte;
            }
            if (this._nextByte >= this._buffer.length) {
                this.refillBuffer();
            }
            if ((gobbleBits = 8 - this._nextBit) > (want = numBits - curBit)) {
                gobbleBits = want;
            }
            int shift = 8 - this._nextBit - gobbleBits;
            int c = this._buffer[this._nextByte] & GOBBLE_MASK[gobbleBits] << shift;
            rv += (long)(c >>> shift << (curBit += gobbleBits) - gobbleBits);
            this._nextBit += gobbleBits;
        }
        return rv;
    }

    public final synchronized void nextBytes(byte[] buf) {
        int outOffset = 0;
        while (outOffset < buf.length) {
            int availableBytes = this._buffer.length - this._nextByte - (this._nextBit != 0 ? 1 : 0);
            if (availableBytes <= 0) {
                this.refillBuffer();
            }
            int start = this._buffer.length - availableBytes;
            int writeSize = Math.min(buf.length - outOffset, availableBytes);
            System.arraycopy(this._buffer, start, buf, outOffset, writeSize);
            outOffset += writeSize;
            this._nextByte += writeSize;
            this._nextBit = 0;
        }
    }

    public final int nextInt(int n) {
        if (n <= 0) {
            return 0;
        }
        int val = (int)this.nextBits(BufferedRandomSource.countBits(n)) % n;
        if (val < 0) {
            return 0 - val;
        }
        return val;
    }

    public final int nextInt() {
        return this.nextInt(Integer.MAX_VALUE);
    }

    public final long nextLong(long n) {
        if (n <= 0L) {
            return 0L;
        }
        long val = this.nextBits(BufferedRandomSource.countBits(n)) % n;
        if (val < 0L) {
            return 0L - val;
        }
        return val;
    }

    public final long nextLong() {
        return this.nextLong(Long.MAX_VALUE);
    }

    static final int countBits(long val) {
        int rv = 0;
        while (val > Integer.MAX_VALUE) {
            rv += 31;
            val >>>= 31;
        }
        while (val > 0L) {
            ++rv;
            val >>= 1;
        }
        return rv;
    }

    public final boolean nextBoolean() {
        return this.nextBits(1) != 0L;
    }

    public final double nextDouble() {
        long top = (this.nextBits(26) << 27) + this.nextBits(27);
        return (double)top / 9.007199254740992E15;
    }

    public float nextFloat() {
        long top = this.nextBits(24);
        return (float)top / 1.6777216E7f;
    }

    public double nextGaussian() {
        return super.nextGaussian();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 16; ++i) {
            BufferedRandomSource.test();
        }
    }

    private static void test() {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] data = new byte[16384];
        for (int i = 0; i < data.length; i += 4) {
            long l = ctx.random().nextLong();
            if (l < 0L) {
                l = 0L - l;
            }
            DataHelper.toLong(data, i, 4, l);
        }
        byte[] compressed = DataHelper.compress(data);
        System.out.println("Data: " + data.length + "/" + compressed.length + ": " + BufferedRandomSource.toString(data));
    }

    private static final String toString(byte[] data) {
        StringBuilder buf = new StringBuilder(data.length * 9);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((data[i] & 1 << j) != 0) {
                    buf.append('1');
                    continue;
                }
                buf.append('0');
            }
            buf.append(' ');
        }
        return buf.toString();
    }

    static {
        GOBBLE_MASK = new byte[]{0, 1, 3, 7, 15, 31, 63, 127, -1};
    }
}

