/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.util.OrderedProperties;

public class RouterAddress
extends DataStructureImpl {
    private int _cost = -1;
    private Date _expiration;
    private String _transportStyle;
    private Properties _options;

    public int getCost() {
        return this._cost;
    }

    public void setCost(int cost) {
        this._cost = cost;
    }

    public Date getExpiration() {
        return this._expiration;
    }

    public void setExpiration(Date expiration) {
        this._expiration = expiration;
    }

    public String getTransportStyle() {
        return this._transportStyle;
    }

    public void setTransportStyle(String transportStyle) {
        this._transportStyle = transportStyle;
    }

    public Properties getOptions() {
        return this._options;
    }

    public void setOptions(Properties options) {
        this._options = options;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._cost = (int)DataHelper.readLong(in, 1);
        this._expiration = DataHelper.readDate(in);
        this._transportStyle = DataHelper.readString(in);
        this._options = DataHelper.readProperties(in);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._cost < 0 || this._transportStyle == null || this._options == null) {
            throw new DataFormatException("Not enough data to write a router address");
        }
        DataHelper.writeLong(out, 1, this._cost);
        DataHelper.writeDate(out, this._expiration);
        DataHelper.writeString(out, this._transportStyle);
        DataHelper.writeProperties(out, this._options);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RouterAddress)) {
            return false;
        }
        RouterAddress addr = (RouterAddress)object;
        return this._cost == addr.getCost() && DataHelper.eq(this._expiration, addr.getExpiration()) && DataHelper.eq(this._options, addr.getOptions()) && DataHelper.eq(this._transportStyle, addr.getTransportStyle());
    }

    public int hashCode() {
        return DataHelper.hashCode(this._transportStyle);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[RouterAddress: ");
        buf.append("\n\tTransportStyle: ").append(this._transportStyle);
        buf.append("\n\tCost: ").append(this._cost);
        buf.append("\n\tExpiration: ").append(this._expiration);
        if (this._options != null) {
            buf.append("\n\tOptions: #: ").append(this._options.size());
            OrderedProperties p = new OrderedProperties();
            p.putAll((Map<?, ?>)this._options);
            for (Map.Entry<Object, Object> e : ((Properties)p).entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append("\n\t\t[").append(key).append("] = [").append(val).append("]");
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

