/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.DSAEngine;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.PublicKey;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.TunnelId;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class LeaseSet
extends DataStructureImpl {
    private static final Log _log = new Log(LeaseSet.class);
    private Destination _destination;
    private PublicKey _encryptionKey;
    private SigningPublicKey _signingKey;
    private List<Lease> _leases = new ArrayList<Lease>(6);
    private Signature _signature;
    private volatile Hash _currentRoutingKey;
    private volatile byte[] _routingKeyGenMod;
    private boolean _receivedAsPublished;
    private boolean _receivedAsReply;
    private long _firstExpiration = Long.MAX_VALUE;
    private long _lastExpiration;
    private List<Lease> _decryptedLeases;
    private boolean _decrypted;
    private boolean _checked;
    public static final int MAX_LEASES = 6;
    private static final int DATA_LEN = 36;
    private static final int IV_LEN = 16;

    public Destination getDestination() {
        return this._destination;
    }

    public void setDestination(Destination dest) {
        this._destination = dest;
    }

    public PublicKey getEncryptionKey() {
        return this._encryptionKey;
    }

    public void setEncryptionKey(PublicKey encryptionKey) {
        this._encryptionKey = encryptionKey;
    }

    public SigningPublicKey getSigningKey() {
        return this._signingKey;
    }

    public void setSigningKey(SigningPublicKey key) {
        this._signingKey = key;
    }

    public boolean getReceivedAsPublished() {
        return this._receivedAsPublished;
    }

    public void setReceivedAsPublished(boolean received) {
        this._receivedAsPublished = received;
    }

    public boolean getReceivedAsReply() {
        return this._receivedAsReply;
    }

    public void setReceivedAsReply() {
        this._receivedAsReply = true;
    }

    public void addLease(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException("erm, null lease");
        }
        if (lease.getGateway() == null) {
            throw new IllegalArgumentException("erm, lease has no gateway");
        }
        if (lease.getTunnelId() == null) {
            throw new IllegalArgumentException("erm, lease has no tunnel");
        }
        if (this._leases.size() > 6) {
            throw new IllegalArgumentException("Too many leases - max is 6");
        }
        this._leases.add(lease);
        long expire = lease.getEndDate().getTime();
        if (expire < this._firstExpiration) {
            this._firstExpiration = expire;
        }
        if (expire > this._lastExpiration) {
            this._lastExpiration = expire;
        }
    }

    public int getLeaseCount() {
        if (this.isEncrypted()) {
            return this._leases.size() - 1;
        }
        return this._leases.size();
    }

    public Lease getLease(int index) {
        if (this.isEncrypted()) {
            return this._decryptedLeases.get(index);
        }
        return this._leases.get(index);
    }

    public Signature getSignature() {
        return this._signature;
    }

    public void setSignature(Signature sig) {
        this._signature = sig;
    }

    public Hash getRoutingKey() {
        RoutingKeyGenerator gen = RoutingKeyGenerator.getInstance();
        if (gen.getModData() == null || this._routingKeyGenMod == null || !DataHelper.eq(gen.getModData(), this._routingKeyGenMod)) {
            this.setRoutingKey(gen.getRoutingKey(this.getDestination().calculateHash()));
            this._routingKeyGenMod = gen.getModData();
        }
        return this._currentRoutingKey;
    }

    public void setRoutingKey(Hash key) {
        this._currentRoutingKey = key;
    }

    public boolean validateRoutingKey() {
        Hash destKey = this.getDestination().calculateHash();
        Hash rk = RoutingKeyGenerator.getInstance().getRoutingKey(destKey);
        return rk.equals(this.getRoutingKey());
    }

    public long getEarliestLeaseDate() {
        if (this._leases.isEmpty()) {
            return -1L;
        }
        return this._firstExpiration;
    }

    public void sign(SigningPrivateKey key) throws DataFormatException {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            throw new DataFormatException("Not enough data to sign");
        }
        Signature sig = DSAEngine.getInstance().sign(bytes, key);
        this.setSignature(sig);
    }

    public boolean verifySignature() {
        if (this.getSignature() == null) {
            return false;
        }
        if (this.getDestination() == null) {
            return false;
        }
        byte[] data = this.getBytes();
        if (data == null) {
            return false;
        }
        boolean signedByDest = DSAEngine.getInstance().verifySignature(this._signature, data, this._destination.getSigningPublicKey());
        boolean signedByRevoker = false;
        if (!signedByDest) {
            signedByRevoker = DSAEngine.getInstance().verifySignature(this._signature, data, this._signingKey);
        }
        return signedByDest || signedByRevoker;
    }

    public boolean verifySignature(SigningPublicKey signingKey) {
        if (this.getSignature() == null) {
            return false;
        }
        if (this.getDestination() == null) {
            return false;
        }
        byte[] data = this.getBytes();
        if (data == null) {
            return false;
        }
        boolean signedByDest = DSAEngine.getInstance().verifySignature(this._signature, data, this._destination.getSigningPublicKey());
        boolean signedByRevoker = false;
        if (!signedByDest) {
            signedByRevoker = DSAEngine.getInstance().verifySignature(this._signature, data, signingKey);
        }
        return signedByDest || signedByRevoker;
    }

    public boolean isCurrent(long fudge) {
        long now = Clock.getInstance().now();
        return this._lastExpiration > now - fudge;
    }

    private byte[] getBytes() {
        if (this._destination == null || this._encryptionKey == null || this._signingKey == null || this._leases == null) {
            return null;
        }
        int len = 773 + this._leases.size() * 44;
        ByteArrayOutputStream out = new ByteArrayOutputStream(len);
        try {
            this._destination.writeBytes(out);
            this._encryptionKey.writeBytes(out);
            this._signingKey.writeBytes(out);
            DataHelper.writeLong(out, 1, this._leases.size());
            for (Lease lease : this._leases) {
                lease.writeBytes(out);
            }
        }
        catch (IOException ioe) {
            return null;
        }
        catch (DataFormatException dfe) {
            return null;
        }
        byte[] rv = out.toByteArray();
        return rv;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._destination = new Destination();
        this._destination.readBytes(in);
        this._encryptionKey = new PublicKey();
        this._encryptionKey.readBytes(in);
        this._signingKey = new SigningPublicKey();
        this._signingKey.readBytes(in);
        int numLeases = (int)DataHelper.readLong(in, 1);
        if (numLeases > 6) {
            throw new DataFormatException("Too many leases - max is 6");
        }
        this._leases.clear();
        for (int i = 0; i < numLeases; ++i) {
            Lease lease = new Lease();
            lease.readBytes(in);
            this.addLease(lease);
        }
        this._signature = new Signature();
        this._signature.readBytes(in);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._destination == null || this._encryptionKey == null || this._signingKey == null || this._leases == null || this._signature == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        this._destination.writeBytes(out);
        this._encryptionKey.writeBytes(out);
        this._signingKey.writeBytes(out);
        DataHelper.writeLong(out, 1, this._leases.size());
        for (Lease lease : this._leases) {
            lease.writeBytes(out);
        }
        this._signature.writeBytes(out);
    }

    public int size() {
        return 771 + this._leases.size() * 44;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LeaseSet)) {
            return false;
        }
        LeaseSet ls = (LeaseSet)object;
        return DataHelper.eq(this.getEncryptionKey(), ls.getEncryptionKey()) && DataHelper.eq(this._leases, ls._leases) && DataHelper.eq(this._signature, ls.getSignature()) && DataHelper.eq(this._signingKey, ls.getSigningKey()) && DataHelper.eq(this._destination, ls.getDestination());
    }

    public int hashCode() {
        if (this._destination == null) {
            return 0;
        }
        return this._destination.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[LeaseSet: ");
        buf.append("\n\tDestination: ").append(this._destination);
        buf.append("\n\tEncryptionKey: ").append(this._encryptionKey);
        buf.append("\n\tSigningKey: ").append(this._signingKey);
        buf.append("\n\tSignature: ").append(this._signature);
        buf.append("\n\tLeases: #").append(this.getLeaseCount());
        for (int i = 0; i < this.getLeaseCount(); ++i) {
            buf.append("\n\t\tLease (").append(i).append("): ").append(this.getLease(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public void encrypt(SessionKey key) {
        if (_log.shouldLog(30)) {
            _log.warn("encrypting lease: " + this._destination.calculateHash());
        }
        try {
            this.encryp(key);
        }
        catch (DataFormatException dfe) {
            _log.error("Error encrypting lease: " + this._destination.calculateHash());
        }
        catch (IOException ioe) {
            _log.error("Error encrypting lease: " + this._destination.calculateHash());
        }
    }

    private void encryp(SessionKey key) throws DataFormatException, IOException {
        int size = this._leases.size();
        if (size < 1 || size > 5) {
            throw new IllegalArgumentException("Bad number of leases for encryption");
        }
        int datalen = (36 * size / 16 + 1) * 16;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(datalen);
        for (int i = 0; i < size; ++i) {
            this._leases.get(i).getGateway().writeBytes(baos);
            this._leases.get(i).getTunnelId().writeBytes(baos);
        }
        int padlen = datalen - 36 * size;
        byte[] pad = new byte[padlen];
        RandomSource.getInstance().nextBytes(pad);
        baos.write(pad);
        byte[] iv = new byte[16];
        System.arraycopy(this._destination.getPublicKey().getData(), 0, iv, 0, 16);
        byte[] enc = new byte[36 * (size + 1)];
        I2PAppContext.getGlobalContext().aes().encrypt(baos.toByteArray(), 0, enc, 0, key, iv, datalen);
        padlen = enc.length - datalen;
        pad = new byte[padlen];
        RandomSource.getInstance().nextBytes(pad);
        System.arraycopy(pad, 0, enc, datalen, padlen);
        Lease padLease = new Lease();
        padLease.setEndDate(this._leases.get(0).getEndDate());
        this._leases.add(padLease);
        ByteArrayInputStream bais = new ByteArrayInputStream(enc);
        for (int i = 0; i < size + 1; ++i) {
            Hash h = new Hash();
            h.readBytes(bais);
            this._leases.get(i).setGateway(h);
            TunnelId t = new TunnelId();
            t.readBytes(bais);
            this._leases.get(i).setTunnelId(t);
        }
    }

    private void decrypt(SessionKey key) throws DataFormatException, IOException {
        int size;
        if (_log.shouldLog(30)) {
            _log.warn("decrypting lease: " + this._destination.calculateHash());
        }
        if ((size = this._leases.size()) < 2) {
            throw new DataFormatException("Bad number of leases for decryption");
        }
        int datalen = 36 * size;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(datalen);
        for (int i = 0; i < size; ++i) {
            this._leases.get(i).getGateway().writeBytes(baos);
            this._leases.get(i).getTunnelId().writeBytes(baos);
        }
        byte[] iv = new byte[16];
        System.arraycopy(this._destination.getPublicKey().getData(), 0, iv, 0, 16);
        int enclen = (36 * (size - 1) / 16 + 1) * 16;
        byte[] enc = new byte[enclen];
        System.arraycopy(baos.toByteArray(), 0, enc, 0, enclen);
        byte[] dec = new byte[enclen];
        I2PAppContext.getGlobalContext().aes().decrypt(enc, 0, dec, 0, key, iv, enclen);
        ByteArrayInputStream bais = new ByteArrayInputStream(dec);
        this._decryptedLeases = new ArrayList<Lease>(size - 1);
        for (int i = 0; i < size - 1; ++i) {
            Lease l = new Lease();
            Hash h = new Hash();
            h.readBytes(bais);
            l.setGateway(h);
            TunnelId t = new TunnelId();
            t.readBytes(bais);
            l.setTunnelId(t);
            l.setEndDate(this._leases.get(i).getEndDate());
            this._decryptedLeases.add(l);
        }
    }

    private synchronized boolean isEncrypted() {
        if (this._decrypted) {
            return true;
        }
        if (this._checked || this._destination == null) {
            return false;
        }
        SessionKey key = (SessionKey)I2PAppContext.getGlobalContext().keyRing().get(this._destination.calculateHash());
        if (key != null) {
            try {
                this.decrypt(key);
                this._decrypted = true;
            }
            catch (DataFormatException dfe) {
                _log.error("Error decrypting lease: " + this._destination.calculateHash() + dfe);
            }
            catch (IOException ioe) {
                _log.error("Error decrypting lease: " + this._destination.calculateHash() + ioe);
            }
        }
        this._checked = true;
        return this._decrypted;
    }
}

