/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.util.Clock;

public class Lease
extends DataStructureImpl {
    private Hash _gateway;
    private TunnelId _tunnelId;
    private Date _end;
    private int _numSuccess;
    private int _numFailure;

    public Hash getGateway() {
        return this._gateway;
    }

    public void setGateway(Hash ident) {
        this._gateway = ident;
    }

    public TunnelId getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(TunnelId id) {
        this._tunnelId = id;
    }

    public Date getEndDate() {
        return this._end;
    }

    public void setEndDate(Date date) {
        this._end = date;
    }

    public int getNumSuccess() {
        return this._numSuccess;
    }

    public void setNumSuccess(int num) {
        this._numSuccess = num;
    }

    public int getNumFailure() {
        return this._numFailure;
    }

    public void setNumFailure(int num) {
        this._numFailure = num;
    }

    public boolean isExpired() {
        return this.isExpired(0L);
    }

    public boolean isExpired(long fudgeFactor) {
        if (this._end == null) {
            return true;
        }
        return this._end.getTime() < Clock.getInstance().now() - fudgeFactor;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._gateway = new Hash();
        this._gateway.readBytes(in);
        this._tunnelId = new TunnelId();
        this._tunnelId.readBytes(in);
        this._end = DataHelper.readDate(in);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._gateway == null || this._tunnelId == null) {
            throw new DataFormatException("Not enough data to write out a Lease");
        }
        this._gateway.writeBytes(out);
        this._tunnelId.writeBytes(out);
        DataHelper.writeDate(out, this._end);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Lease)) {
            return false;
        }
        Lease lse = (Lease)object;
        return DataHelper.eq(this._end, lse.getEndDate()) && DataHelper.eq(this._tunnelId, lse.getTunnelId()) && DataHelper.eq(this._gateway, lse.getGateway());
    }

    public int hashCode() {
        return DataHelper.hashCode(this._end) + DataHelper.hashCode(this._gateway) + DataHelper.hashCode(this._tunnelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[Lease: ");
        buf.append("\n\tEnd Date: ").append(this._end);
        buf.append("\n\tGateway: ").append(this._gateway);
        buf.append("\n\tTunnelId: ").append(this._tunnelId);
        buf.append("]");
        return buf.toString();
    }
}

