/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class Hash
extends DataStructureImpl {
    private byte[] _data;
    private volatile String _stringified;
    private volatile String _base64ed;
    private int _cachedHashCode;
    public static final int HASH_LENGTH = 32;
    public static final Hash FAKE_HASH = new Hash(new byte[32]);

    public Hash() {
    }

    public Hash(byte[] data) {
        this.setData(data);
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        if (data != null && data.length != 32) {
            throw new IllegalArgumentException("Hash must be 32 bytes");
        }
        this._data = data;
        this._stringified = null;
        this._base64ed = null;
        this._cachedHashCode = this.calcHashCode();
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._data = new byte[32];
        this._stringified = null;
        this._base64ed = null;
        int read = this.read(in, this._data);
        if (read != 32) {
            throw new DataFormatException("Not enough bytes to read the hash");
        }
        this._cachedHashCode = this.calcHashCode();
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._data == null) {
            throw new DataFormatException("No data in the hash to write out");
        }
        if (this._data.length != 32) {
            throw new DataFormatException("Invalid size of data in the hash");
        }
        out.write(this._data);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Hash)) {
            return false;
        }
        return DataHelper.eq(this._data, ((Hash)obj)._data);
    }

    public int hashCode() {
        return this._cachedHashCode;
    }

    private int calcHashCode() {
        int rv = 0;
        if (this._data != null) {
            for (int i = 0; i < 4; ++i) {
                rv ^= this._data[i] << i * 8;
            }
        }
        return rv;
    }

    public String toString() {
        if (this._stringified == null) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("[Hash: ");
            if (this._data == null) {
                buf.append("null hash");
            } else {
                buf.append(this.toBase64());
            }
            buf.append("]");
            this._stringified = buf.toString();
        }
        return this._stringified;
    }

    public String toBase64() {
        if (this._base64ed == null) {
            this._base64ed = super.toBase64();
        }
        return this._base64ed;
    }
}

