/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;

public class TrustedUpdate {
    private static final String DEFAULT_TRUSTED_KEY = "W4kJbnv9KSVwbnapV7SaNW2kMIZKs~hwL0ro9pZXFo1xTwqz45nykCp1HM7sAKYDZay5z1HvYYOl9CNVz00xF03KPU9RUCVxhDZ1YXhZIskPKjUPUsCIpE~Z1C~N9KSEV6~2stDlBNH10VZ4T0X1TrcXwb3IBXliWo2y2GAx~Ow=";
    private static final String DEFAULT_TRUSTED_KEY2 = "lT54eq3SH0TWWwQ1wgH6XPelIno7wH7UfiZOpQg-ZuxdNhc4UjjrohKdKZqfswt1ANPnmOlMewLGBESl7kJB9c5sByz~IOlNyz5BMLRC~R~ZC9QI4WXwUBYW8BhYO2mkvtdOrcy690lDkwzdf5xLxlCBpQlTaLYzQVjVWBcvbCA=";
    private static final String DEFAULT_TRUSTED_KEY3 = "JHFA0yXUgKtmhajXFZH9Nk62OPRHbvvQHTi8EANV-D~3tjLjaz9p9cs6Fs8W3FSLfUwsQeFg7dfVSQQZga~1jMjboo94vIcm3j6XbW4mbcorVQ74uPjd8EA1AQhJ6bBTxDAFk~6fVDOdhHT0Wo5CcUn7v8bAYY3x3UWiL8Remx0=";
    private static final String DEFAULT_TRUSTED_KEY4 = "l3G6um9nB9EDLkT9cUusz5fX-GxXSWE5zaj2~V8lUL~XsGuFf8gKqzJLKNkAw0CgDIDsLRHHuUaF7ZHo5Z7HG~9JJU9Il4G2jyNYtg5S8AzG0UxkEt-JeBEqIxv5GDn6OFKr~wTI0UafJbegEWokl-8m-GPWf0vW-yPMjL7y5MI=";
    private static final int VERSION_BYTES = 16;
    public static final int HEADER_BYTES = 56;
    private static final String PROP_TRUSTED_KEYS = "router.trustedUpdateKeys";
    private static I2PAppContext _context;
    private Log _log;
    private Map<SigningPublicKey, String> _trustedKeys;
    private String _newVersion;
    private static final int KEYSIZE_B64_BYTES = 172;

    public TrustedUpdate() {
        this(I2PAppContext.getGlobalContext());
    }

    public TrustedUpdate(I2PAppContext context) {
        _context = context;
        this._log = _context.logManager().getLog(TrustedUpdate.class);
        this._trustedKeys = new HashMap<SigningPublicKey, String>(4);
        this._newVersion = null;
        String propertyTrustedKeys = context.getProperty(PROP_TRUSTED_KEYS);
        if (propertyTrustedKeys != null && propertyTrustedKeys.length() > 0) {
            StringTokenizer propertyTrustedKeysTokens = new StringTokenizer(propertyTrustedKeys, " ,\r\n");
            while (propertyTrustedKeysTokens.hasMoreTokens()) {
                this.addKey(propertyTrustedKeysTokens.nextToken().trim(), "");
            }
        } else {
            this.addKey(DEFAULT_TRUSTED_KEY, "jrandom@mail.i2p");
            this.addKey(DEFAULT_TRUSTED_KEY2, "zzz@mail.i2p");
            this.addKey(DEFAULT_TRUSTED_KEY4, "HungryHobo@mail.i2p");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("TrustedUpdate created, trusting " + this._trustedKeys.size() + " keys.");
        }
    }

    public boolean addKey(String key, String name) {
        SigningPublicKey signingPublicKey = new SigningPublicKey();
        try {
            if (key.length() != 172) {
                throw new DataFormatException("x");
            }
            signingPublicKey.fromBase64(key);
        }
        catch (DataFormatException dfe) {
            this._log.error("Bad signing key for " + name + " : " + key);
            return false;
        }
        if (this._trustedKeys.containsKey(signingPublicKey) || !name.equals("") && this._trustedKeys.containsValue(name)) {
            this._log.error("Duplicate signing key for " + name + " : " + key);
            return false;
        }
        this._trustedKeys.put(signingPublicKey, name);
        return true;
    }

    public boolean haveKey(String key) {
        if (key.length() != 172) {
            return false;
        }
        SigningPublicKey signingPublicKey = new SigningPublicKey();
        try {
            signingPublicKey.fromBase64(key);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        return this._trustedKeys.containsKey(signingPublicKey);
    }

    public static void main(String[] args) {
        boolean ok = false;
        try {
            if ("keygen".equals(args[0])) {
                ok = TrustedUpdate.genKeysCLI(args[1], args[2]);
            } else if ("showversion".equals(args[0])) {
                ok = TrustedUpdate.showVersionCLI(args[1]);
            } else if ("sign".equals(args[0])) {
                ok = TrustedUpdate.signCLI(args[1], args[2], args[3], args[4]);
            } else if ("verifysig".equals(args[0])) {
                ok = TrustedUpdate.verifySigCLI(args[1]);
            } else if ("verifyupdate".equals(args[0])) {
                ok = TrustedUpdate.verifyUpdateCLI(args[1]);
            } else {
                TrustedUpdate.showUsageCLI();
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            TrustedUpdate.showUsageCLI();
        }
        if (!ok) {
            System.exit(1);
        }
    }

    public static final boolean needsUpdate(String currentVersion, String newVersion) {
        return new VersionComparator().compare(currentVersion, newVersion) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean genKeysCLI(String publicKeyFile, String privateKeyFile) {
        FileOutputStream fileOutputStream = null;
        _context = I2PAppContext.getGlobalContext();
        try {
            Object[] signingKeypair = _context.keyGenerator().generateSigningKeypair();
            SigningPublicKey signingPublicKey = (SigningPublicKey)signingKeypair[0];
            SigningPrivateKey signingPrivateKey = (SigningPrivateKey)signingKeypair[1];
            fileOutputStream = new FileOutputStream(publicKeyFile);
            signingPublicKey.writeBytes(fileOutputStream);
            fileOutputStream.close();
            fileOutputStream = null;
            fileOutputStream = new FileOutputStream(privateKeyFile);
            signingPrivateKey.writeBytes(fileOutputStream);
            System.out.println("\r\nPrivate key written to: " + privateKeyFile);
            System.out.println("Public key written to: " + publicKeyFile);
            System.out.println("\r\nPublic key: " + signingPublicKey.toBase64() + "\r\n");
        }
        catch (Exception e) {
            System.err.println("Error writing keys:");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    private static final void showUsageCLI() {
        System.err.println("Usage: TrustedUpdate keygen       publicKeyFile privateKeyFile");
        System.err.println("       TrustedUpdate showversion  signedFile");
        System.err.println("       TrustedUpdate sign         inputFile signedFile privateKeyFile version");
        System.err.println("       TrustedUpdate verifysig    signedFile");
        System.err.println("       TrustedUpdate verifyupdate signedFile");
    }

    private static final boolean showVersionCLI(String signedFile) {
        String versionString = TrustedUpdate.getVersionString(new File(signedFile));
        if (versionString.equals("")) {
            System.out.println("No version string found in file '" + signedFile + "'");
        } else {
            System.out.println("Version: " + versionString);
        }
        return !versionString.equals("");
    }

    private static final boolean signCLI(String inputFile, String signedFile, String privateKeyFile, String version) {
        Signature signature = new TrustedUpdate().sign(inputFile, signedFile, privateKeyFile, version);
        if (signature != null) {
            System.out.println("Input file '" + inputFile + "' signed and written to '" + signedFile + "'");
        } else {
            System.out.println("Error signing input file '" + inputFile + "'");
        }
        return signature != null;
    }

    private static final boolean verifySigCLI(String signedFile) {
        boolean isValidSignature = new TrustedUpdate().verify(new File(signedFile));
        if (isValidSignature) {
            System.out.println("Signature VALID");
        } else {
            System.out.println("Signature INVALID");
        }
        return isValidSignature;
    }

    private static final boolean verifyUpdateCLI(String signedFile) {
        boolean isUpdate = new TrustedUpdate().isUpdatedVersion("0.8.1", new File(signedFile));
        if (isUpdate) {
            System.out.println("File version is newer than current version.");
        } else {
            System.out.println("File version is older than or equal to current version.");
        }
        return isUpdate;
    }

    public String getTrustedKeysString() {
        StringBuilder buf = new StringBuilder(1024);
        for (SigningPublicKey spk : this._trustedKeys.keySet()) {
            if (buf.length() > 0) {
                buf.append("\r\n");
            }
            buf.append(spk.toBase64());
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersionString(File signedFile) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(signedFile);
            long skipped = fileInputStream.skip(40L);
            if (skipped != 40L) {
                String string = "";
                return string;
            }
            byte[] data = new byte[16];
            int bytesRead = DataHelper.read(fileInputStream, data);
            if (bytesRead != 16) {
                String string = "";
                return string;
            }
            for (int i = 0; i < 16; ++i) {
                if (data[i] != 0) continue;
                String ioe = new String(data, 0, i, "UTF-8");
                return ioe;
            }
            String string = new String(data, "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + uee.getMessage());
        }
        catch (IOException ioe) {
            String string = "";
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersionString(InputStream inputStream) {
        try {
            long skipped = inputStream.skip(40L);
            if (skipped != 40L) {
                String string = "";
                return string;
            }
            byte[] data = new byte[16];
            int bytesRead = DataHelper.read(inputStream, data);
            if (bytesRead != 16) {
                String string = "";
                return string;
            }
            for (int i = 0; i < 16; ++i) {
                if (data[i] != 0) continue;
                String ioe = new String(data, 0, i, "UTF-8");
                return ioe;
            }
            String string = new String(data, "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + uee.getMessage());
        }
        catch (IOException ioe) {
            String string = "";
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String newVersion() {
        return this._newVersion;
    }

    public boolean isUpdatedVersion(String currentVersion, File signedFile) {
        this._newVersion = TrustedUpdate.getVersionString(signedFile);
        return TrustedUpdate.needsUpdate(currentVersion, this._newVersion);
    }

    public String migrateVerified(String currentVersion, File signedFile, File outputFile) {
        if (!signedFile.exists()) {
            return "File not found: " + signedFile.getAbsolutePath();
        }
        if (!this.isUpdatedVersion(currentVersion, signedFile)) {
            if ("".equals(this._newVersion)) {
                return "Truncated or corrupt file: " + signedFile.getAbsolutePath();
            }
            return "Downloaded version is not greater than current version";
        }
        if (!this.verify(signedFile)) {
            return "Unknown signing key or corrupt file";
        }
        return this.migrateFile(signedFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String migrateFile(File signedFile, File outputFile) {
        if (!signedFile.exists()) {
            return "File not found: " + signedFile.getAbsolutePath();
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(signedFile);
            fileOutputStream = new FileOutputStream(outputFile);
            for (long skipped = 0L; skipped < 56L; skipped += fileInputStream.skip(56L - skipped)) {
            }
            byte[] buffer = new byte[16384];
            int bytesRead = 0;
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ioe) {
            String string = "Error copying update: " + ioe;
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature sign(String inputFile, String signedFile, String privateKeyFile, String version) {
        FileInputStream fileInputStream = null;
        SigningPrivateKey signingPrivateKey = new SigningPrivateKey();
        try {
            fileInputStream = new FileInputStream(privateKeyFile);
            signingPrivateKey.readBytes(fileInputStream);
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to load the signing key", ioe);
            }
            Signature signature = null;
            return signature;
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to load the signing key", dfe);
            }
            Signature signature = null;
            return signature;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return this.sign(inputFile, signedFile, signingPrivateKey, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature sign(String inputFile, String signedFile, SigningPrivateKey signingPrivateKey, String version) {
        byte[] versionHeader = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] versionRawBytes = null;
        if (version.length() > 16) {
            version = version.substring(0, 16);
        }
        try {
            versionRawBytes = version.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + e.getMessage());
        }
        System.arraycopy(versionRawBytes, 0, versionHeader, 0, versionRawBytes.length);
        FileInputStream fileInputStream = null;
        Signature signature = null;
        SequenceInputStream bytesToSignInputStream = null;
        ByteArrayInputStream versionHeaderInputStream = null;
        try {
            fileInputStream = new FileInputStream(inputFile);
            versionHeaderInputStream = new ByteArrayInputStream(versionHeader);
            bytesToSignInputStream = new SequenceInputStream(versionHeaderInputStream, fileInputStream);
            signature = _context.dsa().sign(bytesToSignInputStream, signingPrivateKey);
        }
        catch (Exception e) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error signing", e);
            }
            Signature signature2 = null;
            return signature2;
        }
        finally {
            if (bytesToSignInputStream != null) {
                try {
                    bytesToSignInputStream.close();
                }
                catch (IOException ioe) {}
            }
            fileInputStream = null;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(signedFile);
            fileOutputStream.write(signature.getData());
            fileOutputStream.write(versionHeader);
            fileInputStream = new FileInputStream(inputFile);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, bytesRead);
            }
            fileOutputStream.close();
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.log(30, "Error writing signed file " + signedFile, ioe);
            }
            Signature signature3 = null;
            return signature3;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return signature;
    }

    public boolean verify(File signedFile) {
        for (SigningPublicKey signingPublicKey : this._trustedKeys.keySet()) {
            boolean isValidSignature = this.verify(signedFile, signingPublicKey);
            if (!isValidSignature) continue;
            return true;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("None of the keys match");
        }
        return false;
    }

    public String verifyAndGetSigner(File signedFile) {
        for (SigningPublicKey signingPublicKey : this._trustedKeys.keySet()) {
            boolean isValidSignature = this.verify(signedFile, signingPublicKey);
            if (!isValidSignature) continue;
            return this._trustedKeys.get(signingPublicKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(String signedFile, String publicKeyFile) {
        SigningPublicKey signingPublicKey = new SigningPublicKey();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(signedFile);
            signingPublicKey.readBytes(fileInputStream);
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to load the signature", ioe);
            }
            boolean bl = false;
            return bl;
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to load the signature", dfe);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return this.verify(new File(signedFile), signingPublicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(File signedFile, SigningPublicKey signingPublicKey) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(signedFile);
            Signature signature = new Signature();
            signature.readBytes(fileInputStream);
            boolean bl = _context.dsa().verifySignature(signature, fileInputStream, signingPublicKey);
            return bl;
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error reading " + signedFile + " to verify", ioe);
            }
            boolean bl = false;
            return bl;
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the signature", dfe);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

