/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class SHA1Hash
extends DataStructureImpl {
    private byte[] _data;
    private int _cachedHashCode;
    public static final int HASH_LENGTH = 20;

    public SHA1Hash(byte[] data) {
        this.setData(data);
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        if (data != null && data.length != 20) {
            throw new IllegalArgumentException("Hash must be 20 bytes");
        }
        this._data = data;
        this._cachedHashCode = this.calcHashCode();
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        throw new IOException("unimplemented");
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        throw new IOException("unimplemented");
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SHA1Hash)) {
            return false;
        }
        return DataHelper.eq(this._data, ((SHA1Hash)obj)._data);
    }

    public int hashCode() {
        return this._cachedHashCode;
    }

    private int calcHashCode() {
        int rv = 0;
        if (this._data != null) {
            for (int i = 0; i < 4; ++i) {
                rv ^= this._data[i] << i * 8;
            }
        }
        return rv;
    }
}

