/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.util.Log;

public class ElGamalAESEngine {
    private static final Log _log = new Log(ElGamalAESEngine.class);
    private static final int MIN_ENCRYPTED_SIZE = 80;
    private I2PAppContext _context;
    private static final Set EMPTY_SET = new HashSet();

    private ElGamalAESEngine() {
    }

    public ElGamalAESEngine(I2PAppContext ctx) {
        this._context = ctx;
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.encryptNewSession", "how frequently we encrypt to a new ElGamal/AES+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.encryptExistingSession", "how frequently we encrypt to an existing ElGamal/AES+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.decryptNewSession", "how frequently we decrypt with a new ElGamal/AES+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.decryptExistingSession", "how frequently we decrypt with an existing ElGamal/AES+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.elGamalAES.decryptFailed", "how frequently we fail to decrypt with ElGamal/AES+SessionTag?", "Encryption", new long[]{3600000L});
    }

    public byte[] decrypt(byte[] data, PrivateKey targetPrivateKey) throws DataFormatException {
        return this.decrypt(data, targetPrivateKey, this._context.sessionKeyManager());
    }

    public byte[] decrypt(byte[] data, PrivateKey targetPrivateKey, SessionKeyManager keyManager) throws DataFormatException {
        if (data == null) {
            if (_log.shouldLog(40)) {
                _log.error("Null data being decrypted?");
            }
            return null;
        }
        if (data.length < 80) {
            if (_log.shouldLog(40)) {
                _log.error("Data is less than the minimum size (" + data.length + " < " + 80 + ")");
            }
            return null;
        }
        byte[] tag = new byte[32];
        System.arraycopy(data, 0, tag, 0, tag.length);
        SessionTag st = new SessionTag(tag);
        SessionKey key = keyManager.consumeTag(st);
        SessionKey foundKey = new SessionKey();
        foundKey.setData(null);
        SessionKey usedKey = new SessionKey();
        HashSet<SessionTag> foundTags = new HashSet<SessionTag>();
        byte[] decrypted = null;
        boolean wasExisting = false;
        if (key != null) {
            usedKey.setData(key.getData());
            long id = this._context.random().nextLong();
            if (_log.shouldLog(10)) {
                _log.debug(id + ": Decrypting existing session encrypted with tag: " + st.toString() + ": key: " + key.toBase64() + ": " + data.length + " bytes: " + Base64.encode(data, 0, 64));
            }
            if ((decrypted = this.decryptExistingSession(data, key, targetPrivateKey, foundTags, usedKey, foundKey)) != null) {
                this._context.statManager().updateFrequency("crypto.elGamalAES.decryptExistingSession");
                if (!foundTags.isEmpty() && _log.shouldLog(10)) {
                    _log.debug(id + ": ElG/AES decrypt success with " + st + ": found tags: " + foundTags);
                }
                wasExisting = true;
            } else {
                this._context.statManager().updateFrequency("crypto.elGamalAES.decryptFailed");
                if (_log.shouldLog(30)) {
                    _log.warn(id + ": ElG decrypt fail: known tag [" + st + "], failed decrypt");
                }
            }
        } else {
            if (_log.shouldLog(10)) {
                _log.debug("Key is NOT known for tag " + st);
            }
            if ((decrypted = this.decryptNewSession(data, targetPrivateKey, foundTags, usedKey, foundKey)) != null) {
                this._context.statManager().updateFrequency("crypto.elGamalAES.decryptNewSession");
                if (!foundTags.isEmpty() && _log.shouldLog(10)) {
                    _log.debug("ElG decrypt success: found tags: " + foundTags);
                }
            } else {
                this._context.statManager().updateFrequency("crypto.elGamalAES.decryptFailed");
                if (_log.shouldLog(30)) {
                    _log.warn("ElG decrypt fail: unknown tag: " + st);
                }
            }
        }
        if (key != null || decrypted == null) {
            // empty if block
        }
        if (!foundTags.isEmpty()) {
            if (foundKey.getData() != null) {
                if (_log.shouldLog(10)) {
                    _log.debug("Found key: " + foundKey.toBase64() + " tags: " + foundTags + " wasExisting? " + wasExisting);
                }
                keyManager.tagsReceived(foundKey, foundTags);
            } else {
                if (_log.shouldLog(10)) {
                    _log.debug("Used key: " + usedKey.toBase64() + " tags: " + foundTags + " wasExisting? " + wasExisting);
                }
                keyManager.tagsReceived(usedKey, foundTags);
            }
        }
        return decrypted;
    }

    byte[] decryptNewSession(byte[] data, PrivateKey targetPrivateKey, Set foundTags, SessionKey usedKey, SessionKey foundKey) throws DataFormatException {
        if (data == null) {
            return null;
        }
        if (data.length < 514) {
            return null;
        }
        byte[] elgEncr = new byte[514];
        if (data.length > 514) {
            System.arraycopy(data, 0, elgEncr, 0, 514);
        } else {
            System.arraycopy(data, 0, elgEncr, 514 - data.length, data.length);
        }
        byte[] elgDecr = this._context.elGamalEngine().decrypt(elgEncr, targetPrivateKey);
        if (elgDecr == null) {
            return null;
        }
        byte[] preIV = null;
        int offset = 0;
        byte[] key = new byte[32];
        System.arraycopy(elgDecr, offset, key, 0, 32);
        usedKey.setData(key);
        preIV = new byte[32];
        System.arraycopy(elgDecr, offset += 32, preIV, 0, 32);
        Hash ivHash = this._context.sha().calculateHash(preIV);
        byte[] iv = new byte[16];
        System.arraycopy(ivHash.getData(), 0, iv, 0, 16);
        this._context.random().harvester().feedEntropy("ElG/AES", elgDecr, offset += 32, elgDecr.length - offset);
        byte[] aesDecr = this.decryptAESBlock(data, 514, data.length - 514, usedKey, iv, null, foundTags, foundKey);
        return aesDecr;
    }

    byte[] decryptExistingSession(byte[] data, SessionKey key, PrivateKey targetPrivateKey, Set foundTags, SessionKey usedKey, SessionKey foundKey) throws DataFormatException {
        byte[] preIV = new byte[32];
        System.arraycopy(data, 0, preIV, 0, preIV.length);
        Hash ivHash = this._context.sha().calculateHash(preIV);
        byte[] iv = new byte[16];
        System.arraycopy(ivHash.getData(), 0, iv, 0, 16);
        usedKey.setData(key.getData());
        byte[] decrypted = this.decryptAESBlock(data, 32, data.length - 32, key, iv, preIV, foundTags, foundKey);
        if (decrypted == null) {
            if (_log.shouldLog(30)) {
                _log.warn("Decrypting looks negative... existing key fails with existing tag, lets try as a new one");
            }
            byte[] rv = this.decryptNewSession(data, targetPrivateKey, foundTags, usedKey, foundKey);
            if (_log.shouldLog(30)) {
                if (rv == null) {
                    _log.warn("Decrypting failed with a known existing tag as either an existing message or a new session");
                } else {
                    _log.warn("Decrypting suceeded as a new session, even though it used an existing tag!");
                }
            }
            return rv;
        }
        return decrypted;
    }

    byte[] decryptAESBlock(byte[] encrypted, SessionKey key, byte[] iv, byte[] sentTag, Set foundTags, SessionKey foundKey) throws DataFormatException {
        return this.decryptAESBlock(encrypted, 0, encrypted.length, key, iv, sentTag, foundTags, foundKey);
    }

    byte[] decryptAESBlock(byte[] encrypted, int offset, int encryptedLen, SessionKey key, byte[] iv, byte[] sentTag, Set foundTags, SessionKey foundKey) throws DataFormatException {
        byte[] decrypted = new byte[encryptedLen];
        this._context.aes().decrypt(encrypted, offset, decrypted, 0, key, iv, encryptedLen);
        try {
            SessionKey newKey = null;
            Hash readHash = null;
            ArrayList<SessionTag> tags = null;
            int cur = 0;
            long numTags = DataHelper.fromLong(decrypted, cur, 2);
            if (numTags < 0L || numTags > 200L) {
                throw new Exception("Invalid number of session tags");
            }
            if (numTags > 0L) {
                tags = new ArrayList<SessionTag>((int)numTags);
            }
            cur += 2;
            if (numTags * 32L > (long)(decrypted.length - 2)) {
                throw new Exception("# tags: " + numTags + " is too many for " + (decrypted.length - 2));
            }
            int i = 0;
            while ((long)i < numTags) {
                byte[] tag = new byte[32];
                System.arraycopy(decrypted, cur, tag, 0, 32);
                cur += 32;
                tags.add(new SessionTag(tag));
                ++i;
            }
            long len = DataHelper.fromLong(decrypted, cur, 4);
            if (len < 0L || len > (long)(decrypted.length - (cur += 4) - 32 - 1)) {
                throw new Exception("Invalid size of payload (" + len + ", remaining " + (decrypted.length - cur) + ")");
            }
            byte[] hashval = new byte[32];
            System.arraycopy(decrypted, cur, hashval, 0, 32);
            cur += 32;
            readHash = new Hash();
            readHash.setData(hashval);
            byte flag = decrypted[cur++];
            if (flag == 1) {
                byte[] rekeyVal = new byte[32];
                System.arraycopy(decrypted, cur, rekeyVal, 0, 32);
                cur += 32;
                newKey = new SessionKey();
                newKey.setData(rekeyVal);
            }
            byte[] unencrData = new byte[(int)len];
            System.arraycopy(decrypted, cur, unencrData, 0, (int)len);
            cur = (int)((long)cur + len);
            Hash calcHash = this._context.sha().calculateHash(unencrData);
            boolean eq = calcHash.equals(readHash);
            if (eq) {
                if (tags != null) {
                    foundTags.addAll(tags);
                }
                if (newKey != null) {
                    foundKey.setData(newKey.getData());
                }
                return unencrData;
            }
            throw new Exception("Hash does not match");
        }
        catch (Exception e) {
            if (_log.shouldLog(30)) {
                _log.warn("Unable to decrypt AES block", e);
            }
            return null;
        }
    }

    public byte[] encrypt(byte[] data, PublicKey target, SessionKey key, Set tagsForDelivery, SessionTag currentTag, SessionKey newKey, long paddedSize) {
        if (currentTag == null) {
            if (_log.shouldLog(20)) {
                _log.info("Current tag is null, encrypting as new session");
            }
            this._context.statManager().updateFrequency("crypto.elGamalAES.encryptNewSession");
            return this.encryptNewSession(data, target, key, tagsForDelivery, newKey, paddedSize);
        }
        if (_log.shouldLog(20)) {
            _log.info("Current tag is NOT null, encrypting as existing session");
        }
        this._context.statManager().updateFrequency("crypto.elGamalAES.encryptExistingSession");
        byte[] rv = this.encryptExistingSession(data, target, key, tagsForDelivery, currentTag, newKey, paddedSize);
        if (_log.shouldLog(10)) {
            _log.debug("Existing session encrypted with tag: " + currentTag.toString() + ": " + rv.length + " bytes and key: " + key.toBase64() + ": " + Base64.encode(rv, 0, 64));
        }
        return rv;
    }

    public byte[] encrypt(byte[] data, PublicKey target, SessionKey key, Set tagsForDelivery, SessionTag currentTag, long paddedSize) {
        return this.encrypt(data, target, key, tagsForDelivery, currentTag, null, paddedSize);
    }

    public byte[] encrypt(byte[] data, PublicKey target, SessionKey key, Set tagsForDelivery, long paddedSize) {
        return this.encrypt(data, target, key, tagsForDelivery, null, null, paddedSize);
    }

    public byte[] encrypt(byte[] data, PublicKey target, SessionKey key, long paddedSize) {
        return this.encrypt(data, target, key, null, null, null, paddedSize);
    }

    byte[] encryptNewSession(byte[] data, PublicKey target, SessionKey key, Set tagsForDelivery, SessionKey newKey, long paddedSize) {
        byte[] elgSrcData = new byte[222];
        System.arraycopy(key.getData(), 0, elgSrcData, 0, 32);
        byte[] preIV = new byte[32];
        this._context.random().nextBytes(preIV);
        System.arraycopy(preIV, 0, elgSrcData, 32, 32);
        byte[] rnd = new byte[158];
        this._context.random().nextBytes(rnd);
        System.arraycopy(rnd, 0, elgSrcData, 64, 158);
        long before = this._context.clock().now();
        byte[] elgEncr = this._context.elGamalEngine().encrypt(elgSrcData, target);
        if (_log.shouldLog(20)) {
            long after = this._context.clock().now();
            _log.info("elgEngine.encrypt of the session key took " + (after - before) + "ms");
        }
        if (elgEncr.length < 514) {
            byte[] elg = new byte[514];
            int diff = elg.length - elgEncr.length;
            System.arraycopy(elgEncr, 0, elg, diff, elgEncr.length);
            elgEncr = elg;
        }
        Hash ivHash = this._context.sha().calculateHash(preIV);
        byte[] iv = new byte[16];
        System.arraycopy(ivHash.getData(), 0, iv, 0, 16);
        byte[] aesEncr = this.encryptAESBlock(data, key, iv, tagsForDelivery, newKey, paddedSize);
        byte[] rv = new byte[elgEncr.length + aesEncr.length];
        System.arraycopy(elgEncr, 0, rv, 0, elgEncr.length);
        System.arraycopy(aesEncr, 0, rv, elgEncr.length, aesEncr.length);
        return rv;
    }

    byte[] encryptExistingSession(byte[] data, PublicKey target, SessionKey key, Set tagsForDelivery, SessionTag currentTag, SessionKey newKey, long paddedSize) {
        byte[] rawTag = currentTag.getData();
        Hash ivHash = this._context.sha().calculateHash(rawTag);
        byte[] iv = new byte[16];
        System.arraycopy(ivHash.getData(), 0, iv, 0, 16);
        byte[] aesEncr = this.encryptAESBlock(data, key, iv, tagsForDelivery, newKey, paddedSize, 32);
        System.arraycopy(rawTag, 0, aesEncr, 0, rawTag.length);
        return aesEncr;
    }

    final byte[] encryptAESBlock(byte[] data, SessionKey key, byte[] iv, Set tagsForDelivery, SessionKey newKey, long paddedSize) {
        return this.encryptAESBlock(data, key, iv, tagsForDelivery, newKey, paddedSize, 0);
    }

    final byte[] encryptAESBlock(byte[] data, SessionKey key, byte[] iv, Set tagsForDelivery, SessionKey newKey, long paddedSize, int prefixBytes) {
        if (tagsForDelivery == null) {
            tagsForDelivery = EMPTY_SET;
        }
        int size = 2 + tagsForDelivery.size() + 32 * tagsForDelivery.size() + 4 + 32 + (newKey == null ? 1 : 33) + data.length;
        int totalSize = size + ElGamalAESEngine.getPaddingSize(size, paddedSize);
        byte[] aesData = new byte[totalSize + prefixBytes];
        int cur = prefixBytes;
        DataHelper.toLong(aesData, cur, 2, tagsForDelivery.size());
        cur += 2;
        for (SessionTag tag : tagsForDelivery) {
            System.arraycopy(tag.getData(), 0, aesData, cur, 32);
            cur += 32;
        }
        DataHelper.toLong(aesData, cur, 4, data.length);
        Hash hash = this._context.sha().calculateHash(data);
        System.arraycopy(hash.getData(), 0, aesData, cur += 4, 32);
        cur += 32;
        if (newKey == null) {
            aesData[cur++] = 0;
        } else {
            aesData[cur++] = 1;
            System.arraycopy(newKey.getData(), 0, aesData, cur, 32);
            cur += 32;
        }
        System.arraycopy(data, 0, aesData, cur, data.length);
        byte[] padding = ElGamalAESEngine.getPadding(this._context, size, paddedSize);
        System.arraycopy(padding, 0, aesData, cur += data.length, padding.length);
        cur += padding.length;
        this._context.aes().encrypt(aesData, prefixBytes, aesData, prefixBytes, key, iv, aesData.length - prefixBytes);
        return aesData;
    }

    static final byte[] getPadding(I2PAppContext context, int curSize, long minPaddedSize) {
        int size = ElGamalAESEngine.getPaddingSize(curSize, minPaddedSize);
        byte[] rv = new byte[size];
        context.random().nextBytes(rv);
        return rv;
    }

    static final int getPaddingSize(int curSize, long minPaddedSize) {
        int diff = 0;
        if ((long)curSize < minPaddedSize) {
            diff = (int)minPaddedSize - curSize;
        }
        int numPadding = diff;
        if ((curSize + diff) % 16 != 0) {
            numPadding += 16 - (curSize + diff) % 16;
        }
        return numPadding;
    }

    public static void main(String[] args) {
        I2PAppContext ctx = new I2PAppContext();
        ElGamalAESEngine e = new ElGamalAESEngine(ctx);
        Object[] kp = ctx.keyGenerator().generatePKIKeypair();
        PublicKey pubKey = (PublicKey)kp[0];
        PrivateKey privKey = (PrivateKey)kp[1];
        SessionKey sessionKey = ctx.keyGenerator().generateSessionKey();
        for (int i = 0; i < 10; ++i) {
            try {
                byte[] encrypted;
                byte[] decrypted;
                HashSet<SessionTag> tags = new HashSet<SessionTag>(5);
                if (i == 0) {
                    for (int j = 0; j < 5; ++j) {
                        tags.add(new SessionTag(true));
                    }
                }
                if (!"blah".equals(new String(decrypted = e.decrypt(encrypted = e.encrypt("blah".getBytes(), pubKey, sessionKey, tags, 1024L), privKey)))) {
                    System.out.println("NOT equal on " + i + ": " + new String(decrypted));
                    break;
                }
                System.out.println("equal on " + i);
                ctx.sessionKeyManager().tagsDelivered(pubKey, sessionKey, tags);
                continue;
            }
            catch (Exception ee) {
                ee.printStackTrace();
                break;
            }
        }
    }
}

