/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.ClientWriterRunner;
import net.i2p.client.I2CPMessageHandler;
import net.i2p.client.I2CPMessageProducer;
import net.i2p.client.I2PClientMessageHandlerMap;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.SessionIdleTimer;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.I2PThread;
import net.i2p.util.InternalSocket;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

abstract class I2PSessionImpl
implements I2PSession,
I2CPMessageReader.I2CPMessageEventListener {
    protected Log _log;
    private Destination _myDestination;
    private PrivateKey _privateKey;
    private SigningPrivateKey _signingPrivateKey;
    private Properties _options;
    private SessionId _sessionId;
    private LeaseSet _leaseSet;
    protected String _hostname;
    protected int _portNum;
    protected Socket _socket;
    protected I2CPMessageReader _reader;
    protected ClientWriterRunner _writer;
    protected OutputStream _out;
    protected I2PSessionListener _sessionListener;
    protected I2CPMessageProducer _producer;
    protected Map<Long, MessagePayloadMessage> _availableMessages;
    protected I2PClientMessageHandlerMap _handlerMap;
    protected I2PAppContext _context;
    private final Object _leaseSetWait = new Object();
    protected boolean _closed;
    protected boolean _closing;
    private boolean _dateReceived;
    private final Object _dateReceivedLock = new Object();
    protected boolean _opening;
    private final Object _openingWait = new Object();
    protected AvailabilityNotifier _availabilityNotifier;
    private long _lastActivity;
    private boolean _isReduced;
    public static final int LISTEN_PORT = 7654;
    private static final int MAX_RECONNECT_DELAY = 320000;
    private static final int BASE_RECONNECT_DELAY = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dateUpdated() {
        this._dateReceived = true;
        Object object = this._dateReceivedLock;
        synchronized (object) {
            this._dateReceivedLock.notifyAll();
        }
    }

    public I2PSessionImpl() {
    }

    public I2PSessionImpl(I2PAppContext context, InputStream destKeyStream, Properties options) throws I2PSessionException {
        this._context = context;
        this._log = context.logManager().getLog(I2PSessionImpl.class);
        this._handlerMap = new I2PClientMessageHandlerMap(context);
        this._closed = true;
        this._opening = false;
        this._closing = false;
        this._producer = new I2CPMessageProducer(context);
        this._availabilityNotifier = new AvailabilityNotifier();
        this._availableMessages = new ConcurrentHashMap<Long, MessagePayloadMessage>();
        try {
            this.readDestination(destKeyStream);
        }
        catch (DataFormatException dfe) {
            throw new I2PSessionException("Error reading the destination key stream", dfe);
        }
        catch (IOException ioe) {
            throw new I2PSessionException("Error reading the destination key stream", ioe);
        }
        if (options == null) {
            options = System.getProperties();
        }
        this.loadConfig(options);
        this._sessionId = null;
        this._leaseSet = null;
    }

    protected void loadConfig(Properties options) {
        this._options = new Properties();
        this._options.putAll((Map<?, ?>)this.filter(options));
        this._hostname = this._options.getProperty("i2cp.tcp.host", "127.0.0.1");
        String portNum = this._options.getProperty("i2cp.tcp.port", "7654");
        try {
            this._portNum = Integer.parseInt(portNum);
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Invalid port number specified, defaulting to " + 7654, nfe);
            }
            this._portNum = 7654;
        }
    }

    private Properties filter(Properties options) {
        Properties rv = new Properties();
        for (String string : options.keySet()) {
            String val = options.getProperty(string);
            if (string.startsWith("java") || string.startsWith("user") || string.startsWith("os") || string.startsWith("sun") || string.startsWith("file") || string.startsWith("line") || string.startsWith("wrapper")) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping property: " + string);
                continue;
            }
            if (string.length() > 255 || val.length() > 255) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn(this.getPrefix() + "Not passing on property [" + string + "] in the session configuration as the value is too long (max = 255): " + val);
                continue;
            }
            rv.setProperty(string, val);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLeaseSet(LeaseSet ls) {
        this._leaseSet = ls;
        if (ls != null) {
            Object object = this._leaseSetWait;
            synchronized (object) {
                this._leaseSetWait.notifyAll();
            }
        }
    }

    LeaseSet getLeaseSet() {
        return this._leaseSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOpening(boolean ls) {
        this._opening = ls;
        Object object = this._openingWait;
        synchronized (object) {
            this._openingWait.notifyAll();
        }
    }

    boolean getOpening() {
        return this._opening;
    }

    private void readDestination(InputStream destKeyStream) throws DataFormatException, IOException {
        this._myDestination = new Destination();
        this._privateKey = new PrivateKey();
        this._signingPrivateKey = new SigningPrivateKey();
        this._myDestination.readBytes(destKeyStream);
        this._privateKey.readBytes(destKeyStream);
        this._signingPrivateKey.readBytes(destKeyStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws I2PSessionException {
        this.setOpening(true);
        this._closed = false;
        this._availabilityNotifier.stopNotifying();
        I2PThread notifier = new I2PThread(this._availabilityNotifier);
        notifier.setName("Notifier " + this._myDestination.calculateHash().toBase64().substring(0, 4));
        notifier.setDaemon(true);
        notifier.start();
        if (this._options != null && "Guaranteed".equals(this._options.getProperty("i2cp.messageReliability", "BestEffort")) && this._log.shouldLog(40)) {
            this._log.error("I2CP guaranteed delivery mode has been removed, using best effort.");
        }
        long startConnect = this._context.clock().now();
        try {
            this._socket = InternalSocket.getSocket(this._hostname, this._portNum);
            OutputStream outputStream = this._out = this._socket.getOutputStream();
            synchronized (outputStream) {
                this._out.write(42);
                this._out.flush();
            }
            this._writer = new ClientWriterRunner(this._out, this);
            InputStream in = this._socket.getInputStream();
            this._reader = new I2CPMessageReader(in, this);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "before startReading");
            }
            this._reader.startReading();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "Before getDate");
            }
            this.sendMessage(new GetDateMessage());
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "After getDate / begin waiting for a response");
            }
            int waitcount = 0;
            while (!this._dateReceived) {
                if (waitcount++ > 30) {
                    this.closeSocket();
                    throw new IOException("no date handshake");
                }
                try {
                    Object object = this._dateReceivedLock;
                    synchronized (object) {
                        this._dateReceivedLock.wait(1000L);
                    }
                }
                catch (InterruptedException ie) {
                }
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "After received a SetDate response");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "Before producer.connect()");
            }
            this._producer.connect(this);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "After  producer.connect()");
            }
            waitcount = 0;
            while (this._leaseSet == null) {
                if (waitcount++ > 300) {
                    try {
                        this._producer.disconnect(this);
                    }
                    catch (I2PSessionException ipe) {
                        // empty catch block
                    }
                    this.closeSocket();
                    throw new IOException("no leaseset");
                }
                Object ipe = this._leaseSetWait;
                synchronized (ipe) {
                    try {
                        this._leaseSetWait.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            long connected = this._context.clock().now();
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Lease set created with inbound tunnels after " + (connected - startConnect) + "ms - ready to participate in the network!");
            }
            this.startIdleMonitor();
            this.setOpening(false);
        }
        catch (UnknownHostException uhe) {
            this._closed = true;
            this.setOpening(false);
            throw new I2PSessionException(this.getPrefix() + "Invalid session configuration", uhe);
        }
        catch (IOException ioe) {
            this._closed = true;
            this.setOpening(false);
            throw new I2PSessionException(this.getPrefix() + "Problem connecting to " + this._hostname + " on port " + this._portNum, ioe);
        }
    }

    public byte[] receiveMessage(int msgId) throws I2PSessionException {
        MessagePayloadMessage msg = this._availableMessages.remove(new Long(msgId));
        if (msg == null) {
            this._log.error("Receive message " + msgId + " had no matches");
            return null;
        }
        this.updateActivity();
        return msg.getPayload().getUnencryptedData();
    }

    public void reportAbuse(int msgId, int severity) throws I2PSessionException {
        if (this.isClosed()) {
            throw new I2PSessionException(this.getPrefix() + "Already closed");
        }
        this._producer.reportAbuse(this, msgId, severity);
    }

    public abstract boolean sendMessage(Destination var1, byte[] var2) throws I2PSessionException;

    public abstract boolean sendMessage(Destination var1, byte[] var2, SessionKey var3, Set var4) throws I2PSessionException;

    public abstract void receiveStatus(int var1, long var2, int var4);

    public void addNewMessage(MessagePayloadMessage msg) {
        Long mid = new Long(msg.getMessageId());
        this._availableMessages.put(mid, msg);
        long id = msg.getMessageId();
        byte[] data = msg.getPayload().getUnencryptedData();
        if (data == null || data.length <= 0) {
            if (this._log.shouldLog(50)) {
                this._log.log(50, this.getPrefix() + "addNewMessage of a message with no unencrypted data", new Exception("Empty message"));
            }
        } else {
            int size = data.length;
            this._availabilityNotifier.available(id, size);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Notified availability for session " + this._sessionId + ", message " + id);
            }
        }
        SimpleScheduler.getInstance().addEvent(new VerifyUsage(mid), 30000L);
    }

    public void messageReceived(I2CPMessageReader reader, I2CPMessage message) {
        I2CPMessageHandler handler = this._handlerMap.getHandler(message.getType());
        if (handler == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Unknown message or unhandleable message received: type = " + message.getType());
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "Message received of type " + message.getType() + " to be handled by " + handler);
            }
            handler.handleMessage(message, this);
        }
    }

    public void readError(I2CPMessageReader reader, Exception error) {
        this.propogateError("There was an error reading data", error);
        this.disconnect();
    }

    public Destination getMyDestination() {
        return this._myDestination;
    }

    public PrivateKey getDecryptionKey() {
        return this._privateKey;
    }

    public SigningPrivateKey getPrivateKey() {
        return this._signingPrivateKey;
    }

    I2CPMessageProducer getProducer() {
        return this._producer;
    }

    Properties getOptions() {
        return this._options;
    }

    SessionId getSessionId() {
        return this._sessionId;
    }

    void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public void setSessionListener(I2PSessionListener lsnr) {
        this._sessionListener = lsnr;
    }

    public boolean isClosed() {
        return this._closed;
    }

    void sendMessage(I2CPMessage message) throws I2PSessionException {
        if (this.isClosed() || this._writer == null) {
            throw new I2PSessionException("Already closed");
        }
        this._writer.addMessage(message);
    }

    void propogateError(String msg, Throwable error) {
        if (this._log.shouldLog(40)) {
            this._log.error(this.getPrefix() + "Error occurred: " + msg + " - " + error.getMessage());
        }
        if (this._log.shouldLog(40)) {
            this._log.error(this.getPrefix() + " cause", error);
        }
        if (this._sessionListener != null) {
            this._sessionListener.errorOccurred(this, msg, error);
        }
    }

    public void destroySession() {
        this.destroySession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySession(boolean sendDisconnect) {
        while (this._opening) {
            Object object = this._openingWait;
            synchronized (object) {
                try {
                    this._openingWait.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this._closed) {
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Destroy the session", new Exception("DestroySession()"));
        }
        this._closing = true;
        if (sendDisconnect && this._producer != null) {
            try {
                this._producer.disconnect(this);
            }
            catch (I2PSessionException ipe) {
                this.propogateError("Error destroying the session", ipe);
            }
        }
        this._availabilityNotifier.stopNotifying();
        this._closed = true;
        this._closing = false;
        this.closeSocket();
        if (this._sessionListener != null) {
            this._sessionListener.disconnected(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Closing the socket", new Exception("closeSocket"));
        }
        this._closed = true;
        if (this._reader != null) {
            this._reader.stopReading();
            this._reader = null;
        }
        if (this._writer != null) {
            this._writer.stopWriting();
            this._writer = null;
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException ioe) {
                this.propogateError("Caught an IO error closing the socket.  ignored", ioe);
            }
            finally {
                this._socket = null;
            }
        }
    }

    public void disconnected(I2CPMessageReader reader) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "Disconnected", new Exception("Disconnected"));
        }
        this.disconnect();
    }

    protected void disconnect() {
        if (this._closed || this._closing) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "Disconnect() called", new Exception("Disconnect"));
        }
        if (this.shouldReconnect()) {
            if (this.reconnect()) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getPrefix() + "I2CP reconnection successful");
                }
                return;
            }
            if (this._log.shouldLog(40)) {
                this._log.error(this.getPrefix() + "I2CP reconnection failed");
            }
        }
        if (this._log.shouldLog(40)) {
            this._log.error(this.getPrefix() + "Disconned from the router, and not trying to reconnect further.  I hope you're not hoping anything else will happen");
        }
        if (this._sessionListener != null) {
            this._sessionListener.disconnected(this);
        }
        this._closed = true;
        this.closeSocket();
    }

    protected boolean shouldReconnect() {
        return true;
    }

    protected boolean reconnect() {
        this.closeSocket();
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Reconnecting...");
        }
        int i = 0;
        while (true) {
            long delay = 10000 << i;
            ++i;
            if (delay > 320000L || delay <= 0L) {
                delay = 320000L;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            try {
                this.connect();
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getPrefix() + "Reconnected on attempt " + i);
                }
                return true;
            }
            catch (I2PSessionException ise) {
                if (!this._log.shouldLog(40)) continue;
                this._log.error(this.getPrefix() + "Error reconnecting on attempt " + i, ise);
                continue;
            }
            break;
        }
    }

    protected String getPrefix() {
        return "[" + (this._sessionId == null ? -1 : this._sessionId.getSessionId()) + "]: ";
    }

    public Destination lookupDest(Hash h) throws I2PSessionException {
        return null;
    }

    public int[] bandwidthLimits() throws I2PSessionException {
        return null;
    }

    protected void updateActivity() {
        this._lastActivity = this._context.clock().now();
        if (this._isReduced) {
            this._isReduced = false;
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Restoring original tunnel quantity");
            }
            try {
                this._producer.updateTunnels(this, 0);
            }
            catch (I2PSessionException ise) {
                this._log.error(this.getPrefix() + "bork restore from reduced");
            }
        }
    }

    public long lastActivity() {
        return this._lastActivity;
    }

    public void setReduced() {
        this._isReduced = true;
    }

    private void startIdleMonitor() {
        this._isReduced = false;
        boolean reduce = Boolean.valueOf(this._options.getProperty("i2cp.reduceOnIdle"));
        boolean close = Boolean.valueOf(this._options.getProperty("i2cp.closeOnIdle"));
        if (reduce || close) {
            this.updateActivity();
            SimpleScheduler.getInstance().addEvent(new SessionIdleTimer(this._context, this, reduce, close), 300000L);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append("Session: ");
        if (this._myDestination != null) {
            buf.append(this._myDestination.calculateHash().toBase64().substring(0, 4));
        } else {
            buf.append("[null dest]");
        }
        buf.append(this.getPrefix());
        return buf.toString();
    }

    protected class AvailabilityNotifier
    implements Runnable {
        private List _pendingIds = new ArrayList(2);
        private List _pendingSizes = new ArrayList(2);
        private boolean _alive;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopNotifying() {
            this._alive = false;
            AvailabilityNotifier availabilityNotifier = this;
            synchronized (availabilityNotifier) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void available(long msgId, int size) {
            AvailabilityNotifier availabilityNotifier = this;
            synchronized (availabilityNotifier) {
                this._pendingIds.add(new Long(msgId));
                this._pendingSizes.add(size);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._alive = true;
            while (this._alive) {
                Long msgId = null;
                Integer size = null;
                AvailabilityNotifier availabilityNotifier = this;
                synchronized (availabilityNotifier) {
                    if (this._pendingIds.isEmpty()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    if (!this._pendingIds.isEmpty()) {
                        msgId = (Long)this._pendingIds.remove(0);
                        size = (Integer)this._pendingSizes.remove(0);
                    }
                }
                if (msgId == null || size == null) continue;
                if (I2PSessionImpl.this._sessionListener != null) {
                    try {
                        long before = System.currentTimeMillis();
                        I2PSessionImpl.this._sessionListener.messageAvailable(I2PSessionImpl.this, msgId.intValue(), size.intValue());
                        long duration = System.currentTimeMillis() - before;
                        if (duration <= 100L || !I2PSessionImpl.this._log.shouldLog(20)) continue;
                        I2PSessionImpl.this._log.info("Message availability notification for " + msgId.intValue() + " took " + duration + " to " + I2PSessionImpl.this._sessionListener);
                    }
                    catch (Exception e) {
                        I2PSessionImpl.this._log.log(50, "Error notifying app of message availability", e);
                    }
                    continue;
                }
                I2PSessionImpl.this._log.log(50, "Unable to notify an app that " + msgId + " of size " + size + " is available!");
            }
        }
    }

    protected class VerifyUsage
    implements SimpleTimer.TimedEvent {
        private Long _msgId;

        public VerifyUsage(Long id) {
            this._msgId = id;
        }

        public void timeReached() {
            MessagePayloadMessage removed = I2PSessionImpl.this._availableMessages.remove(this._msgId);
            if (removed != null && !I2PSessionImpl.this.isClosed()) {
                I2PSessionImpl.this._log.error("Message NOT removed!  id=" + this._msgId + ": " + removed);
            }
        }
    }
}

