/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.sam.client.SAMEventHandler;
import net.i2p.sam.client.SAMReader;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class SAMStreamSend {
    private I2PAppContext _context;
    private Log _log;
    private String _samHost;
    private String _samPort;
    private String _destFile;
    private String _dataFile;
    private String _conOptions;
    private Socket _samSocket;
    private OutputStream _samOut;
    private InputStream _samIn;
    private SAMReader _reader;
    private SAMEventHandler _eventHandler;
    private Map<Integer, Sender> _remotePeers;

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: SAMStreamSend samHost samPort peerDestFile dataFile");
            return;
        }
        I2PAppContext ctx = new I2PAppContext();
        SAMStreamSend sender = new SAMStreamSend(ctx, args[0], args[1], args[2], args[3]);
        sender.startup();
    }

    public SAMStreamSend(I2PAppContext ctx, String samHost, String samPort, String destFile, String dataFile) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(SAMStreamSend.class);
        this._samHost = samHost;
        this._samPort = samPort;
        this._destFile = destFile;
        this._dataFile = dataFile;
        this._conOptions = "";
        this._eventHandler = new SendEventHandler(this._context);
        this._remotePeers = new HashMap<Integer, Sender>();
    }

    public void startup() {
        this._log.debug("Starting up");
        boolean ok = this.connect();
        this._log.debug("Connected: " + ok);
        if (ok) {
            this._reader = new SAMReader(this._context, this._samIn, this._eventHandler);
            this._reader.startReading();
            this._log.debug("Reader created");
            String ourDest = this.handshake();
            this._log.debug("Handshake complete.  we are " + ourDest);
            if (ourDest != null) {
                this.send();
            }
        }
    }

    private boolean connect() {
        try {
            this._samSocket = new Socket(this._samHost, Integer.parseInt(this._samPort));
            this._samOut = this._samSocket.getOutputStream();
            this._samIn = this._samSocket.getInputStream();
            return true;
        }
        catch (Exception e) {
            this._log.error("Unable to connect to SAM at " + this._samHost + ":" + this._samPort, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handshake() {
        OutputStream outputStream = this._samOut;
        synchronized (outputStream) {
            try {
                this._samOut.write("HELLO VERSION MIN=1.0 MAX=1.0\n".getBytes());
                this._samOut.flush();
                this._log.debug("Hello sent");
                boolean ok = this._eventHandler.waitForHelloReply();
                this._log.debug("Hello reply found: " + ok);
                if (!ok) {
                    throw new IOException("wtf, hello failed?");
                }
                String req = "SESSION CREATE STYLE=STREAM DESTINATION=TRANSIENT " + this._conOptions + "\n";
                this._samOut.write(req.getBytes());
                this._samOut.flush();
                this._log.debug("Session create sent");
                ok = this._eventHandler.waitForSessionCreateReply();
                this._log.debug("Session create reply found: " + ok);
                req = "NAMING LOOKUP NAME=ME\n";
                this._samOut.write(req.getBytes());
                this._samOut.flush();
                this._log.debug("Naming lookup sent");
                String destination = this._eventHandler.waitForNamingReply("ME");
                this._log.debug("Naming lookup reply found: " + destination);
                if (destination == null) {
                    this._log.error("No naming lookup reply found!");
                    return null;
                }
                this._log.info("We are " + destination);
                return destination;
            }
            catch (Exception e) {
                this._log.error("Error handshaking", e);
                return null;
            }
        }
    }

    private void send() {
        Sender sender = new Sender();
        boolean ok = sender.openConnection();
        if (ok) {
            I2PAppThread t = new I2PAppThread(sender, "Sender");
            t.start();
        }
    }

    private class Sender
    implements Runnable {
        private int _connectionId;
        private String _remoteDestination;
        private InputStream _in;
        private boolean _closed = false;
        private long _started;
        private long _totalSent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean openConnection() {
            try {
                FileInputStream fin = new FileInputStream(SAMStreamSend.this._destFile);
                byte[] dest = new byte[1024];
                int read = DataHelper.read(fin, dest);
                this._remoteDestination = new String(dest, 0, read);
                Map map = SAMStreamSend.this._remotePeers;
                synchronized (map) {
                    this._connectionId = SAMStreamSend.this._remotePeers.size() + 1;
                    SAMStreamSend.this._remotePeers.put(new Integer(this._connectionId), this);
                }
                SAMStreamSend.this._context.statManager().createRateStat("send." + this._connectionId + ".totalSent", "Data size sent", "swarm", new long[]{30000L, 60000L, 300000L});
                SAMStreamSend.this._context.statManager().createRateStat("send." + this._connectionId + ".started", "When we start", "swarm", new long[]{300000L});
                SAMStreamSend.this._context.statManager().createRateStat("send." + this._connectionId + ".lifetime", "How long we talk to a peer", "swarm", new long[]{300000L});
                byte[] msg = ("STREAM CONNECT ID=" + this._connectionId + " DESTINATION=" + this._remoteDestination + "\n").getBytes();
                OutputStream outputStream = SAMStreamSend.this._samOut;
                synchronized (outputStream) {
                    SAMStreamSend.this._samOut.write(msg);
                    SAMStreamSend.this._samOut.flush();
                }
                this._in = new FileInputStream(SAMStreamSend.this._dataFile);
                return true;
            }
            catch (IOException ioe) {
                SAMStreamSend.this._log.error("Unable to connect", ioe);
                return false;
            }
        }

        public int getConnectionId() {
            return this._connectionId;
        }

        public String getDestination() {
            return this._remoteDestination;
        }

        public void closed() {
            if (this._closed) {
                return;
            }
            this._closed = true;
            long lifetime = SAMStreamSend.this._context.clock().now() - this._started;
            SAMStreamSend.this._context.statManager().addRateData("send." + this._connectionId + ".lifetime", lifetime, lifetime);
            try {
                this._in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._started = SAMStreamSend.this._context.clock().now();
            SAMStreamSend.this._context.statManager().addRateData("send." + this._connectionId + ".started", 1L, 0L);
            byte[] data = new byte[1024];
            long lastSend = SAMStreamSend.this._context.clock().now();
            while (!this._closed) {
                try {
                    int read = this._in.read(data);
                    long now = SAMStreamSend.this._context.clock().now();
                    if (read == -1) {
                        SAMStreamSend.this._log.debug("EOF from the data for " + this._connectionId + " after " + (now - lastSend));
                        break;
                    }
                    if (read <= 0) continue;
                    SAMStreamSend.this._log.debug("Sending " + read + " on " + this._connectionId + " after " + (now - lastSend));
                    lastSend = now;
                    byte[] msg = ("STREAM SEND ID=" + this._connectionId + " SIZE=" + read + "\n").getBytes();
                    OutputStream outputStream = SAMStreamSend.this._samOut;
                    synchronized (outputStream) {
                        SAMStreamSend.this._samOut.write(msg);
                        SAMStreamSend.this._samOut.write(data, 0, read);
                        SAMStreamSend.this._samOut.flush();
                    }
                    this._totalSent += (long)read;
                    SAMStreamSend.this._context.statManager().addRateData("send." + this._connectionId + ".totalSent", this._totalSent, 0L);
                }
                catch (IOException ioe) {
                    SAMStreamSend.this._log.error("Error sending", ioe);
                }
            }
            byte[] msg = ("STREAM CLOSE ID=" + this._connectionId + "\n").getBytes();
            try {
                OutputStream now = SAMStreamSend.this._samOut;
                synchronized (now) {
                    SAMStreamSend.this._samOut.write(msg);
                    SAMStreamSend.this._samOut.flush();
                }
            }
            catch (IOException ioe) {
                SAMStreamSend.this._log.error("Error closing", ioe);
            }
            this.closed();
        }
    }

    private class SendEventHandler
    extends SAMEventHandler {
        public SendEventHandler(I2PAppContext ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamClosedReceived(String result, int id, String message) {
            Sender sender = null;
            Map map = SAMStreamSend.this._remotePeers;
            synchronized (map) {
                sender = (Sender)SAMStreamSend.this._remotePeers.remove(new Integer(id));
            }
            if (sender != null) {
                sender.closed();
                SAMStreamSend.this._log.debug("Connection " + sender.getConnectionId() + " closed to " + sender.getDestination());
            } else {
                SAMStreamSend.this._log.error("wtf, not connected to " + id + " but we were just closed?");
            }
        }
    }
}

