/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class SAMReader {
    private Log _log;
    private InputStream _inRaw;
    private SAMClientEventListener _listener;
    private boolean _live;

    public SAMReader(I2PAppContext context, InputStream samIn, SAMClientEventListener listener) {
        this._log = context.logManager().getLog(SAMReader.class);
        this._inRaw = samIn;
        this._listener = listener;
    }

    public void startReading() {
        this._live = true;
        I2PAppThread t = new I2PAppThread(new Runner(), "SAM reader");
        t.start();
    }

    public void stopReading() {
        this._live = false;
    }

    private void processEvent(String major, String minor, Properties params) {
        block46: {
            if ("HELLO".equals(major)) {
                if ("REPLY".equals(minor)) {
                    String result = params.getProperty("RESULT");
                    if ("OK".equals(result)) {
                        this._listener.helloReplyReceived(true);
                    } else {
                        this._listener.helloReplyReceived(false);
                    }
                } else {
                    this._listener.unknownMessageReceived(major, minor, params);
                }
            } else if ("SESSION".equals(major)) {
                if ("STATUS".equals(minor)) {
                    String result = params.getProperty("RESULT");
                    String dest = params.getProperty("DESTINATION");
                    String msg = params.getProperty("MESSAGE");
                    this._listener.sessionStatusReceived(result, dest, msg);
                } else {
                    this._listener.unknownMessageReceived(major, minor, params);
                }
            } else if ("STREAM".equals(major)) {
                if ("STATUS".equals(minor)) {
                    String result = params.getProperty("RESULT");
                    String id = params.getProperty("ID");
                    String msg = params.getProperty("MESSAGE");
                    if (id != null) {
                        try {
                            this._listener.streamStatusReceived(result, Integer.parseInt(id), msg);
                        }
                        catch (NumberFormatException nfe) {
                            this._listener.unknownMessageReceived(major, minor, params);
                        }
                    } else {
                        this._listener.unknownMessageReceived(major, minor, params);
                    }
                } else if ("CONNECTED".equals(minor)) {
                    String dest = params.getProperty("DESTINATION");
                    String id = params.getProperty("ID");
                    if (id != null) {
                        try {
                            this._listener.streamConnectedReceived(dest, Integer.parseInt(id));
                        }
                        catch (NumberFormatException nfe) {
                            this._listener.unknownMessageReceived(major, minor, params);
                        }
                    } else {
                        this._listener.unknownMessageReceived(major, minor, params);
                    }
                } else if ("CLOSED".equals(minor)) {
                    String result = params.getProperty("RESULT");
                    String id = params.getProperty("ID");
                    String msg = params.getProperty("MESSAGE");
                    if (id != null) {
                        try {
                            this._listener.streamClosedReceived(result, Integer.parseInt(id), msg);
                        }
                        catch (NumberFormatException nfe) {
                            this._listener.unknownMessageReceived(major, minor, params);
                        }
                    } else {
                        this._listener.unknownMessageReceived(major, minor, params);
                    }
                } else if ("RECEIVED".equals(minor)) {
                    String id = params.getProperty("ID");
                    String size = params.getProperty("SIZE");
                    if (id != null) {
                        try {
                            int idVal = Integer.parseInt(id);
                            int sizeVal = Integer.parseInt(size);
                            byte[] data = new byte[sizeVal];
                            int read = DataHelper.read(this._inRaw, data);
                            if (read != sizeVal) {
                                this._listener.unknownMessageReceived(major, minor, params);
                                break block46;
                            }
                            this._listener.streamDataReceived(idVal, data, 0, sizeVal);
                        }
                        catch (NumberFormatException nfe) {
                            this._listener.unknownMessageReceived(major, minor, params);
                        }
                        catch (IOException ioe) {
                            this._live = false;
                            this._listener.unknownMessageReceived(major, minor, params);
                        }
                    } else {
                        this._listener.unknownMessageReceived(major, minor, params);
                    }
                } else {
                    this._listener.unknownMessageReceived(major, minor, params);
                }
            } else if ("NAMING".equals(major)) {
                if ("REPLY".equals(minor)) {
                    String name = params.getProperty("NAME");
                    String result = params.getProperty("RESULT");
                    String value = params.getProperty("VALUE");
                    String msg = params.getProperty("MESSAGE");
                    this._listener.namingReplyReceived(name, result, value, msg);
                } else {
                    this._listener.unknownMessageReceived(major, minor, params);
                }
            } else if ("DEST".equals(major)) {
                if ("REPLY".equals(minor)) {
                    String pub = params.getProperty("PUB");
                    String priv = params.getProperty("PRIV");
                    this._listener.destReplyReceived(pub, priv);
                } else {
                    this._listener.unknownMessageReceived(major, minor, params);
                }
            } else {
                this._listener.unknownMessageReceived(major, minor, params);
            }
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        public void run() {
            Properties params = new Properties();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(80);
            while (SAMReader.this._live) {
                try {
                    int c = -1;
                    while ((c = SAMReader.this._inRaw.read()) != -1 && c != 10) {
                        baos.write(c);
                    }
                    if (c == -1) {
                        SAMReader.this._log.error("Error reading from the SAM bridge");
                        return;
                    }
                }
                catch (IOException ioe) {
                    SAMReader.this._log.error("Error reading from SAM", ioe);
                }
                String line = new String(baos.toByteArray());
                baos.reset();
                if (line == null) {
                    SAMReader.this._log.info("No more data from the SAM bridge");
                    break;
                }
                SAMReader.this._log.debug("Line read from the bridge: " + line);
                StringTokenizer tok = new StringTokenizer(line);
                if (tok.countTokens() < 2) {
                    SAMReader.this._log.error("Invalid SAM line: [" + line + "]");
                    SAMReader.this._live = false;
                    return;
                }
                String major = tok.nextToken();
                String minor = tok.nextToken();
                params.clear();
                while (tok.hasMoreTokens()) {
                    String pair = tok.nextToken();
                    int eq = pair.indexOf(61);
                    if (eq <= 0 || eq >= pair.length() - 1) continue;
                    String name = pair.substring(0, eq);
                    String val = pair.substring(eq + 1);
                    while (val.charAt(0) == '\"' && val.length() > 0) {
                        val = val.substring(1);
                    }
                    while (val.length() > 0 && val.charAt(val.length() - 1) == '\"') {
                        val = val.substring(0, val.length() - 1);
                    }
                    params.setProperty(name, val);
                }
                SAMReader.this.processEvent(major, minor, params);
            }
        }
    }

    public static interface SAMClientEventListener {
        public static final String SESSION_STATUS_OK = "OK";
        public static final String SESSION_STATUS_DUPLICATE_DEST = "DUPLICATE_DEST";
        public static final String SESSION_STATUS_I2P_ERROR = "I2P_ERROR";
        public static final String SESSION_STATUS_INVALID_KEY = "INVALID_KEY";
        public static final String STREAM_STATUS_OK = "OK";
        public static final String STREAM_STATUS_CANT_REACH_PEER = "CANT_REACH_PEER";
        public static final String STREAM_STATUS_I2P_ERROR = "I2P_ERROR";
        public static final String STREAM_STATUS_INVALID_KEY = "INVALID_KEY";
        public static final String STREAM_STATUS_TIMEOUT = "TIMEOUT";
        public static final String STREAM_CLOSED_OK = "OK";
        public static final String STREAM_CLOSED_CANT_REACH_PEER = "CANT_REACH_PEER";
        public static final String STREAM_CLOSED_I2P_ERROR = "I2P_ERROR";
        public static final String STREAM_CLOSED_PEER_NOT_FOUND = "PEER_NOT_FOUND";
        public static final String STREAM_CLOSED_TIMEOUT = "CLOSED";
        public static final String NAMING_REPLY_OK = "OK";
        public static final String NAMING_REPLY_INVALID_KEY = "INVALID_KEY";
        public static final String NAMING_REPLY_KEY_NOT_FOUND = "KEY_NOT_FOUND";

        public void helloReplyReceived(boolean var1);

        public void sessionStatusReceived(String var1, String var2, String var3);

        public void streamStatusReceived(String var1, int var2, String var3);

        public void streamConnectedReceived(String var1, int var2);

        public void streamClosedReceived(String var1, int var2, String var3);

        public void streamDataReceived(int var1, byte[] var2, int var3, int var4);

        public void namingReplyReceived(String var1, String var2, String var3, String var4);

        public void destReplyReceived(String var1, String var2);

        public void unknownMessageReceived(String var1, String var2, Properties var3);
    }
}

