/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import net.i2p.sam.SAMBridge;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public abstract class SAMHandler
implements Runnable {
    private static final Log _log = new Log(SAMHandler.class);
    protected I2PAppThread thread = null;
    protected SAMBridge bridge = null;
    private Object socketWLock = new Object();
    protected SocketChannel socket = null;
    protected int verMajor = 0;
    protected int verMinor = 0;
    protected Properties i2cpProps = null;
    private Object stopLock = new Object();
    private boolean stopHandler = false;

    protected SAMHandler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps) throws IOException {
        this.socket = s;
        this.verMajor = verMajor;
        this.verMinor = verMinor;
        this.i2cpProps = i2cpProps;
    }

    public final void startHandling() {
        this.thread = new I2PAppThread(this, "SAMHandler");
        this.thread.start();
    }

    public void setBridge(SAMBridge bridge) {
        this.bridge = bridge;
    }

    protected abstract void handle();

    protected final SocketChannel getClientSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeBytes(ByteBuffer data) throws IOException {
        Object object = this.socketWLock;
        synchronized (object) {
            SAMHandler.writeBytes(data, this.socket);
        }
    }

    public static void writeBytes(ByteBuffer data, SocketChannel out) throws IOException {
        while (data.hasRemaining()) {
            out.write(data);
        }
        out.socket().getOutputStream().flush();
    }

    protected Object getWriteLock() {
        return this.socketWLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean writeString(String str) {
        Object object = this.socketWLock;
        synchronized (object) {
            if (_log.shouldLog(10)) {
                _log.debug("Sending the client: [" + str + "]");
            }
            return SAMHandler.writeString(str, this.socket);
        }
    }

    public static boolean writeString(String str, SocketChannel out) {
        try {
            SAMHandler.writeBytes(ByteBuffer.wrap(str.getBytes("ISO-8859-1")), out);
        }
        catch (IOException e) {
            _log.debug("Caught IOException", e);
            return false;
        }
        return true;
    }

    protected final void closeClientSocket() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopHandling() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopHandler = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean shouldStop() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.stopHandler;
        }
    }

    public final String toString() {
        return "SAM handler (class: " + this.getClass().getName() + "; SAM version: " + this.verMajor + "." + this.verMinor + "; client: " + this.socket.socket().getInetAddress().toString() + ":" + this.socket.socket().getPort() + ")";
    }

    public final void run() {
        this.handle();
    }
}

