/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.seedless.server;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import net.i2p.seedless.classes.SeedlessException;
import net.i2p.seedless.classes.SeedlessServices;
import net.i2p.seedless.data.Base64;
import net.i2p.seedless.data.SetupServer;
import org.neodatis.odb.ODB;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.criteria.Criterion;
import org.neodatis.odb.core.query.criteria.W;

public class SeedlessServerCore {
    private static final String ANNOUNCE = "announce ";
    private static final String LOCATE = "locate ";
    private static final int ANNOUNCE_LEN = "announce ".length();
    private static final int LOCATE_LEN = "locate ".length();
    private String[] accepted;
    private long[] expires;
    private SetupServer config = null;
    private PrintWriter out = null;
    private String STag = null;
    private String b32addr = null;
    private ODB odb = null;

    public SeedlessServerCore(SetupServer config, String[] accepted, long[] expires, PrintWriter out, String STag, String b32addr, ODB odb) {
        this.config = config;
        this.accepted = accepted;
        this.expires = expires;
        this.out = out;
        this.STag = STag;
        this.b32addr = b32addr;
        this.odb = odb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void Process() throws UnsupportedEncodingException, SeedlessException {
        int i;
        int p = -1;
        String info = null;
        boolean announce = false;
        boolean us = false;
        Date now = new Date();
        long date = now.getTime();
        SeedlessServices service = null;
        Objects services = this.odb.query(SeedlessServices.class, W.le((String)"date", (long)date).and((Criterion)W.not((Criterion)W.like((String)"service", (String)"seedless")))).objects();
        while (services.hasNext()) {
            service = (SeedlessServices)services.next();
            this.odb.delete((Object)service);
            this.odb.commit();
        }
        if (this.STag == null) throw new SeedlessException("X-Seedless not set.");
        this.STag = this.STag.trim();
        if (this.STag.startsWith(ANNOUNCE)) {
            info = Base64.decodeToString(this.STag.substring(ANNOUNCE_LEN), "UTF-8");
            announce = true;
        } else if (this.STag.startsWith(LOCATE)) {
            info = Base64.decodeToString(this.STag.substring(LOCATE_LEN), "UTF-8");
        }
        if (info == null) throw new SeedlessException("Not Base64.");
        String[] data = info.split(" ", 2);
        if (data.length != 2) {
            throw new SeedlessException("Malformed request.");
        }
        String svc = data[0];
        String metadata = data[1].trim();
        int size = this.accepted.length;
        for (i = 0; i < size; ++i) {
            if (!this.accepted[i].equals(svc)) continue;
            p = i;
        }
        if (metadata.length() > 1024) {
            p = -2;
        }
        if (svc.length() > 20) {
            p = -3;
        }
        if (p == -1) {
            throw new SeedlessException("Service '" + svc + "' Not accepted on this server.");
        }
        if (p == -2) {
            throw new SeedlessException("Metadata to long.");
        }
        if (p == -3) {
            throw new SeedlessException("Service name to long.");
        }
        long sdate = this.expires[p];
        long fdate = sdate / 5L * 4L;
        if (sdate / 5L < 60L) {
            fdate = sdate - 60L;
        }
        long udate = date + sdate * 60000L;
        long xdate = date + fdate * 60000L;
        if (announce) {
            try {
                boolean doit = true;
                services = this.odb.query(SeedlessServices.class, W.equal((String)"service", (Object)svc).and(W.equal((String)"metadata", (Object)metadata)).and(W.equal((String)"dest", (Object)this.b32addr))).objects();
                if (services.hasNext()) {
                    service = (SeedlessServices)services.next();
                    service.date = udate;
                    if (us |= service.us) {
                        service.us = true;
                    }
                } else {
                    String[] ml;
                    if (svc.equals("seedless")) {
                        ml = metadata.contains(",") ? metadata.split(",") : new String[]{metadata};
                        for (i = 0; i < ml.length; ++i) {
                            int l = ml[i].length();
                            if (l <= 20 && l >= 1 && !ml[i].matches("(?s)(?u)\\A(.)(\\s)(.)*\\z")) continue;
                            doit = false;
                        }
                    }
                    if (svc.equals("torrent")) {
                        ml = metadata.split("\n");
                        if (ml.length != 3) {
                            doit = false;
                        } else if (ml[0].length() != 40) {
                            doit = false;
                        } else if (ml[1].length() != 28) {
                            doit = false;
                        } else if (!ml[2].equals("seed") && !ml[2].equals("leech")) {
                            doit = false;
                        } else if (ml[0].contains(" ") || ml[1].contains(" ") || ml[2].contains(" ")) {
                            doit = false;
                        }
                    }
                    service = us ? new SeedlessServices(svc, metadata, this.b32addr, date + this.expires[p] * 60000L, true) : new SeedlessServices(svc, metadata, this.b32addr, date + this.expires[p] * 60000L, false);
                }
                if (!doit) {
                    throw new SeedlessException("Seedless Service format incorrect.");
                }
                this.odb.store((Object)service);
                this.odb.commit();
                return;
            }
            catch (Exception e) {}
            return;
        }
        try {
            services = metadata.isEmpty() ? this.odb.query(SeedlessServices.class, W.equal((String)"service", (Object)svc).and(W.like((String)"metadata", (String)metadata).and(W.gt((String)"date", (long)xdate)))).objects() : this.odb.query(SeedlessServices.class, W.equal((String)"service", (Object)svc).and(W.like((String)"metadata", (String)metadata))).objects();
            while (services.hasNext()) {
                service = (SeedlessServices)services.next();
                this.out.println(Base64.encode(service.dest + " " + (service.date - date) / 60000L + " " + service.metadata, "UTF-8"));
            }
            return;
        }
        catch (Exception e) {
            return;
        }
    }
}

