/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.seedless.reuse.scrape;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.i2p.seedless.classes.DB;
import net.i2p.seedless.classes.DBException;
import net.i2p.seedless.classes.SeedlessServices;
import net.i2p.seedless.data.Base64;
import net.i2p.seedless.reuse.ProxyRequest;
import org.neodatis.odb.ODB;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.criteria.W;

public class Scrape
implements Runnable {
    private String url = null;
    private String weDo = null;
    private String proxyaddress;
    private long expires;
    private int proxyport;
    private String b32addr;
    private String what;
    private boolean success = false;
    private boolean testing = false;
    private static Pattern LALPHANUMERIC = Pattern.compile("[A-Za-z0-9,_-]+");
    private static Pattern LNUMERIC = Pattern.compile("[0-9,]+");
    private static Pattern LHEX = Pattern.compile("[a-f0-9]+");

    Scrape(String url, String proxyaddress, int proxyport, long expires, String b32addr, String what, String weDo) {
        this.url = url;
        this.proxyaddress = proxyaddress;
        this.proxyport = proxyport;
        this.expires = expires;
        this.b32addr = b32addr;
        this.what = what;
        this.weDo = weDo;
    }

    public boolean wasOK() {
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InputStream in;
        block109: {
            SeedlessServices service = null;
            SeedlessServices killService = null;
            HttpURLConnection request = null;
            BufferedReader data = null;
            in = null;
            int i = 0;
            String metadata = "";
            String us = "";
            ArrayList<String> metadatas = new ArrayList<String>();
            String newMetadata = null;
            String newb32 = null;
            Long newDate = null;
            DB db = null;
            ODB odb = null;
            int openattemps = 0;
            try {
                ProxyRequest proxy = new ProxyRequest();
                request = proxy.doURLRequest(this.url, this.weDo, this.proxyaddress, this.proxyport);
                if (request != null) {
                    try {
                        String line;
                        i = request.getResponseCode();
                        if (i == 200) {
                            us = request.getHeaderField("X-Seedless");
                            if (us == null) {
                                i = -200;
                            }
                        } else if (i == 406) {
                            System.out.println("Scrape on " + this.url + " Failed: " + this.weDo + " " + request.getResponseMessage());
                        }
                        in = request.getInputStream();
                        data = new BufferedReader(new InputStreamReader(in));
                        while ((line = data.readLine()) != null) {
                            if (i != 200) continue;
                            metadatas.add(line);
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (request != null) {
                        try {
                            request.disconnect();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    request = null;
                    if (data != null) {
                        // empty if block
                    }
                    try {
                        data.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    data = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    in = null;
                    if (i == 200) {
                        Iterator it = metadatas.iterator();
                        Date now = new Date();
                        long date = now.getTime();
                        while (it.hasNext()) {
                            try {
                                metadata = Base64.decodeToString((String)it.next(), "UTF-8");
                            }
                            catch (UnsupportedEncodingException ex) {
                                metadata = null;
                            }
                            newMetadata = null;
                            if (metadata != null) {
                                try {
                                    String[] ml;
                                    newb32 = metadata.split(" ", 3)[0];
                                    newDate = Long.parseLong(metadata.split(" ", 3)[1]);
                                    newMetadata = metadata.split(" ", 3)[2];
                                    if (this.what.equals("seedless")) {
                                        if (newMetadata.contains("\n") || newMetadata.contains(" ") || newMetadata.endsWith(",") || newMetadata.startsWith(",")) {
                                            System.out.println("Scrape seedless ',\\n ,' WARNING: Bad data from " + this.url);
                                            System.out.println("Scrape WARNING: Bad data -->" + metadata + "<--");
                                            newMetadata = null;
                                        } else if (LNUMERIC.matcher(newMetadata).matches()) {
                                            System.out.println("Scrape seedless LNUMERIC WARNING: Bad data from " + this.url);
                                            System.out.println("Scrape WARNING: Bad data -->" + metadata + "<--");
                                            newMetadata = null;
                                        } else if (!LALPHANUMERIC.matcher(newMetadata).matches()) {
                                            System.out.println("Scrape seedless LALPHANUMERIC WARNING: Bad data from " + this.url);
                                            System.out.println("Scrape WARNING: Bad data -->" + metadata + "<--");
                                            newMetadata = null;
                                        } else {
                                            ml = newMetadata.split(",");
                                            for (i = 0; i < ml.length; ++i) {
                                                int l = ml[i].length();
                                                if (l <= 20 && l >= 1 && !ml[i].contains(" ")) continue;
                                                System.out.println("Scrape seedless length WARNING: Bad data from " + this.url);
                                                System.out.println("Scrape WARNING: Bad data -->" + metadata + "<--");
                                                newMetadata = null;
                                            }
                                        }
                                    }
                                    if (this.what.equals("eepsite")) {
                                        if (!newMetadata.contains(" ")) {
                                            System.out.println("Scrape eepsite no space WARNING: Bad data from " + this.url);
                                            System.out.println("Scrape WARNING: Bad data -->" + metadata + "<--");
                                            newMetadata = null;
                                        }
                                        if (LNUMERIC.matcher(newMetadata).matches()) {
                                            System.out.println("Scrape eepsite LNUMERIC WARNING: Bad data from " + this.url);
                                            System.out.println("Scrape WARNING: Bad data -->" + metadata + "<--");
                                            newMetadata = null;
                                        }
                                    }
                                    if (this.what.equals("torrent")) {
                                        ml = newMetadata.split("\n");
                                        if (ml.length != 3) {
                                            newMetadata = null;
                                        } else if (ml[0].length() != 40) {
                                            newMetadata = null;
                                        } else if (ml[1].length() != 28) {
                                            newMetadata = null;
                                        } else if (!ml[2].equals("seed") && !ml[2].equals("leech")) {
                                            newMetadata = null;
                                        } else if (ml[0].length() != 40 || !LHEX.matcher(ml[0]).matches()) {
                                            newMetadata = null;
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    System.out.println("Scrape WARNING: Bad data from " + this.url);
                                    System.out.println("Scrape WARNING: Bad data -->" + metadata + "<--");
                                    newMetadata = null;
                                }
                            }
                            if (newMetadata == null) continue;
                            while (db == null) {
                                try {
                                    db = new DB(this.getClass().getName());
                                }
                                catch (DBException ex) {
                                    db = null;
                                    if (++openattemps > 10) {
                                        System.out.println(this.getClass().getName() + " No neodatis connection after 10 attempts! FAILING!");
                                        Object var26_33 = null;
                                        odb = null;
                                        try {
                                            if (db != null && !db.isClosed()) {
                                                db.close();
                                            }
                                        }
                                        catch (Exception ex2) {
                                            // empty catch block
                                        }
                                        db = null;
                                        if (request != null) {
                                            try {
                                                request.disconnect();
                                            }
                                            catch (Exception ex2) {
                                                // empty catch block
                                            }
                                        }
                                        request = null;
                                        if (data != null) {
                                            // empty if block
                                        }
                                        try {
                                            data.close();
                                        }
                                        catch (Exception ex2) {
                                            // empty catch block
                                        }
                                        data = null;
                                        if (in != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (Exception ex2) {
                                                // empty catch block
                                            }
                                        }
                                        in = null;
                                        return;
                                    }
                                    try {
                                        Thread.sleep(6000L);
                                    }
                                    catch (InterruptedException ex1) {
                                        Object var26_34 = null;
                                        odb = null;
                                        try {
                                            if (db != null && !db.isClosed()) {
                                                db.close();
                                            }
                                        }
                                        catch (Exception ex2) {
                                            // empty catch block
                                        }
                                        db = null;
                                        if (request != null) {
                                            try {
                                                request.disconnect();
                                            }
                                            catch (Exception ex2) {
                                                // empty catch block
                                            }
                                        }
                                        request = null;
                                        if (data != null) {
                                            // empty if block
                                        }
                                        try {
                                            data.close();
                                        }
                                        catch (Exception ex2) {
                                            // empty catch block
                                        }
                                        data = null;
                                        if (in != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (Exception ex2) {
                                                // empty catch block
                                            }
                                        }
                                        in = null;
                                        return;
                                    }
                                }
                            }
                            odb = db.getODB();
                            Objects services = odb.query(SeedlessServices.class, W.equal((String)"service", (Object)this.what).and(W.equal((String)"dest", (Object)newb32)).and(W.equal((String)"metadata", newMetadata))).objects();
                            if (!services.hasNext()) {
                                service = us.equals(newb32) ? new SeedlessServices(this.what, newMetadata, newb32, date + newDate * 60000L, true) : new SeedlessServices(this.what, newMetadata, newb32, date + newDate * 60000L, false);
                                odb.store((Object)service);
                                odb.commit();
                                if (this.testing) {
                                    System.out.println("Seedless  " + this.b32addr + ", provided " + metadata);
                                }
                            } else {
                                service = (SeedlessServices)services.next();
                                while (services.hasNext()) {
                                    killService = (SeedlessServices)services.next();
                                    odb.delete((Object)killService);
                                }
                                if (service.date < date + newDate * 60000L || us.equals(newb32) && !service.us) {
                                    service.date = date + newDate * 60000L;
                                    service.us = us.equals(this.b32addr);
                                    odb.store((Object)service);
                                    odb.commit();
                                    if (this.testing) {
                                        System.out.println("Seedless  " + this.b32addr + ", updated " + metadata);
                                    }
                                }
                            }
                            odb = null;
                            try {
                                if (db != null && !db.isClosed()) {
                                    db.close();
                                }
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            db = null;
                        }
                        this.success = true;
                    }
                }
                Object var26_35 = null;
                odb = null;
            }
            catch (Throwable throwable) {
                Object var26_36 = null;
                odb = null;
                try {
                    if (db != null && !db.isClosed()) {
                        db.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                db = null;
                if (request != null) {
                    try {
                        request.disconnect();
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                request = null;
                if (data != null) {
                    // empty if block
                }
                try {
                    data.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                data = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                in = null;
                throw throwable;
            }
            try {
                if (db != null && !db.isClosed()) {
                    db.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            db = null;
            if (request != null) {
                try {
                    request.disconnect();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            request = null;
            if (data != null) {
                // empty if block
            }
            try {
                data.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            data = null;
            if (in != null) {
                try {
                    in.close();
                    break block109;
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                {
                }
            }
        }
        in = null;
    }
}

