/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.seedless.reuse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.i2p.seedless.classes.DB;
import net.i2p.seedless.classes.DBException;
import net.i2p.seedless.classes.SeedlessServices;
import net.i2p.seedless.data.Base64;
import net.i2p.seedless.reuse.ProxyRequest;
import org.neodatis.odb.ODB;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.criteria.W;

public class Announcer
implements Runnable {
    private String metadata = " ";
    private String type = null;
    private final int DEFAULT_PROXY = 4488;
    private static final String QUERYSTRING = "/Seedless/seedless";
    private boolean spin;
    private String proxyaddress = "127.0.0.1";
    private int proxyport = 4488;
    private boolean server;
    private boolean testing = false;
    private Lock lock = new ReentrantLock();
    private boolean shortcircuit = false;
    private static final Object objMutex = new Object();

    public Announcer(String type, String metadata, String proxyaddress, int proxyport) {
        this.SetupAnnouncer(type, metadata, false, proxyaddress, proxyport);
    }

    public Announcer(String type, String metadata, boolean server, String proxyaddress, int proxyport) {
        this.SetupAnnouncer(type, metadata, server, proxyaddress, proxyport);
    }

    public void die() {
        this.spin = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeMeta(String metadata) {
        try {
            this.lock.lock();
            this.metadata = metadata;
            Object object = objMutex;
            synchronized (object) {
                this.shortcircuit = true;
                objMutex.notify();
            }
            Object var5_4 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private void SetupAnnouncer(String type, String metadata, boolean server, String proxyaddress, int proxyport) {
        this.spin = true;
        this.type = type;
        this.metadata = metadata;
        this.proxyaddress = proxyaddress;
        this.proxyport = proxyport;
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private synchronized long once() {
        DB db;
        Long elapsedTime;
        block52: {
            elapsedTime = -2L;
            BufferedReader data = null;
            InputStream in = null;
            boolean didsomething = false;
            db = null;
            int openattemps = 0;
            this.lock.lock();
            try {
                this.shortcircuit = false;
                while (db == null) {
                    try {
                        db = new DB(this.getClass().getName());
                    }
                    catch (DBException ex) {
                        db = null;
                        if (++openattemps > 10) {
                            System.out.println(this.getClass().getName() + " No neodatis connection after 10 attempts! FAILING!");
                            long l = -1L;
                            Object var20_15 = null;
                            this.lock.unlock();
                            Object odb = null;
                            try {
                                if (db != null && !db.isClosed()) {
                                    db.close();
                                }
                            }
                            catch (Exception ex2) {
                                // empty catch block
                            }
                            db = null;
                            return l;
                        }
                        try {
                            Thread.sleep(6000L);
                        }
                        catch (InterruptedException ex1) {
                            long l = -1L;
                            Object var20_16 = null;
                            this.lock.unlock();
                            Object odb = null;
                            try {
                                if (db != null && !db.isClosed()) {
                                    db.close();
                                }
                            }
                            catch (Exception ex2) {
                                // empty catch block
                            }
                            db = null;
                            return l;
                        }
                    }
                }
                ODB odb = db.getODB();
                if (this.testing) {
                    System.out.println("Announce started for " + this.type + " " + this.metadata);
                }
                Long timeNow = new Date().getTime();
                didsomething = false;
                Objects services = odb.query(SeedlessServices.class, W.equal((String)"service", (Object)"seedless").and(W.like((String)"metadata", (String)this.type))).objects();
                if (services.hasNext()) {
                    SeedlessServices service;
                    LinkedList<SeedlessServices> servicesC = new LinkedList<SeedlessServices>();
                    while (services.hasNext()) {
                        service = new SeedlessServices((SeedlessServices)services.next());
                        servicesC.add(service);
                    }
                    odb = null;
                    try {
                        if (db != null && !db.isClosed()) {
                            db.close();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    db = null;
                    int successful = Math.min(10, servicesC.size());
                    Collections.shuffle(servicesC, new Random());
                    Iterator servicesX = servicesC.iterator();
                    while (servicesX.hasNext() && successful > 0) {
                        HttpURLConnection request;
                        service = (SeedlessServices)servicesX.next();
                        String url = "http://" + service.dest + QUERYSTRING;
                        ProxyRequest proxy = new ProxyRequest();
                        try {
                            request = proxy.doURLRequest(url, "announce " + Base64.encode(this.type + " " + this.metadata, "UTF-8"), this.proxyaddress, this.proxyport);
                        }
                        catch (UnsupportedEncodingException ex) {
                            request = proxy.doURLRequest(url, "announce " + Base64.encode(this.type + " " + this.metadata), this.proxyaddress, this.proxyport);
                        }
                        if (request == null) continue;
                        try {
                            if (request.getResponseCode() != 200) continue;
                            --successful;
                            didsomething = true;
                            in = request.getInputStream();
                            data = new BufferedReader(new InputStreamReader(in));
                            while (data.readLine() != null) {
                            }
                            try {
                                request.disconnect();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            request = null;
                            try {
                                data.close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            data = null;
                            try {
                                in.close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            in = null;
                        }
                        catch (IOException ioe) {
                            if (request != null) {
                                try {
                                    request.disconnect();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                request = null;
                            }
                            if (request != null) {
                                try {
                                    data.close();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                data = null;
                            }
                            if (request == null) continue;
                            try {
                                in.close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            in = null;
                        }
                    }
                    elapsedTime = new Date().getTime() - timeNow;
                    if (elapsedTime > 3000000L) {
                        elapsedTime = 3000000L;
                    }
                    if (!didsomething) {
                        System.out.println("No contacts made, for " + this.type);
                        elapsedTime = 3000000L;
                    }
                    if (this.testing) {
                        System.out.println("Announcer Sleeping  " + (3600000L - elapsedTime) / 60000L + " minutes for " + this.type);
                    }
                } else {
                    try {
                        if (db != null && !db.isClosed()) {
                            db.close();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    db = null;
                    System.out.println("No service for " + this.type + " Announcer yet, Sleeping 10 minutes.");
                    elapsedTime = 600000L;
                }
                Object var20_17 = null;
                this.lock.unlock();
                odb = null;
            }
            catch (Throwable throwable) {
                Object var20_18 = null;
                this.lock.unlock();
                Object odb = null;
                try {
                    if (db != null && !db.isClosed()) {
                        db.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                db = null;
                throw throwable;
            }
            try {
                if (db != null && !db.isClosed()) {
                    db.close();
                }
                break block52;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            {
            }
        }
        db = null;
        return elapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.spin) {
            Long elapsedTime = this.once();
            if (elapsedTime < 0L) {
                return;
            }
            Long timeLeft = 3600000L - elapsedTime;
            if (timeLeft <= 0L || !this.spin || this.shortcircuit) continue;
            Object object = objMutex;
            synchronized (object) {
                try {
                    objMutex.wait(timeLeft);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
    }
}

