/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.seedless.data;

public class Base32 {
    private static final char[] ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '2', '3', '4', '5', '6', '7'};
    private static final byte[] DECODABET = new byte[]{26, 27, 28, 29, 30, 31, -9, -9, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9};
    private static final byte BAD_ENCODING = -9;
    private static final byte[] emask = new byte[]{31, 1, 3, 7, 15};
    private static final byte[] dmask = new byte[]{-8, 124, 62, 31, 15, 7, 3, 1};

    private Base32() {
    }

    public static String encode(String source) {
        return source != null ? Base32.encode(source.getBytes()) : "";
    }

    public static String encode(byte[] source) {
        StringBuilder buf = new StringBuilder((source.length + 7) * 8 / 5);
        Base32.encodeBytes(source, buf);
        return buf.toString();
    }

    private static void encodeBytes(byte[] source, StringBuilder out) {
        int usedbits = 0;
        int i = 0;
        while (i < source.length) {
            int fivebits;
            if (usedbits < 3) {
                fivebits = source[i] >> 3 - usedbits & 0x1F;
                usedbits += 5;
            } else if (usedbits == 3) {
                fivebits = source[i++] & 0x1F;
                usedbits = 0;
            } else {
                fivebits = source[i++] << usedbits - 3 & 0x1F;
                if (i < source.length) {
                    fivebits |= source[i] >> 8 - (usedbits -= 3) & emask[usedbits];
                }
            }
            out.append(ALPHABET[fivebits]);
        }
    }

    public static String decodeToString(String s) {
        byte[] b = Base32.decode(s);
        if (b == null) {
            return null;
        }
        return new String(b);
    }

    public static byte[] decode(String s) {
        return Base32.decode(s.getBytes());
    }

    private static byte[] decode(byte[] source) {
        int len58 = source.length <= 1 ? source.length : source.length * 5 / 8;
        byte[] outBuff = new byte[len58];
        int outBuffPosn = 0;
        int usedbits = 0;
        for (int i = 0; i < source.length; ++i) {
            int fivebits = (source[i] & 0x80) != 0 || source[i] < 50 || source[i] > 122 ? -9 : DECODABET[source[i] - 50];
            if (fivebits >= 0) {
                if (usedbits == 0) {
                    outBuff[outBuffPosn] = (byte)(fivebits << 3 & 0xF8);
                    usedbits = 5;
                    continue;
                }
                if (usedbits < 3) {
                    int n = outBuffPosn;
                    outBuff[n] = (byte)(outBuff[n] | fivebits << 3 - usedbits & dmask[usedbits]);
                    usedbits += 5;
                    continue;
                }
                if (usedbits == 3) {
                    int n = outBuffPosn++;
                    outBuff[n] = (byte)(outBuff[n] | fivebits);
                    usedbits = 0;
                    continue;
                }
                int n = outBuffPosn++;
                outBuff[n] = (byte)(outBuff[n] | fivebits >> usedbits - 3 & dmask[usedbits]);
                byte next = (byte)(fivebits << 11 - usedbits);
                if (outBuffPosn < len58) {
                    outBuff[outBuffPosn] = next;
                    usedbits -= 3;
                    continue;
                }
                if (next == 0) continue;
                return null;
            }
            return null;
        }
        return outBuff;
    }
}

