/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.seedless;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class SetupServer {
    private static final String CONFIG_FILE = "Seedless.config";
    private String[] accepted;
    private long[] expires;

    public SetupServer() {
        File cfg = new File(CONFIG_FILE);
        FileInputStream fi = null;
        PrintStream fo = null;
        Boolean OK = false;
        Boolean broken = false;
        this.accepted = new String[1];
        this.accepted[0] = "";
        this.expires = new long[1];
        this.expires[0] = 0L;
        int i = 0;
        try {
            fi = new FileInputStream(cfg);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fi, "UTF-8"));
            while (br.ready()) {
                String line = br.readLine().trim();
                this.accepted[i] = line.split(" ", 2)[0];
                if (this.accepted[i].length() > 20) {
                    this.accepted[i] = this.accepted[i].substring(20);
                    broken = true;
                }
                this.expires[i] = Integer.parseInt(line.split(" ", 2)[1]);
                if (this.expires[i] < 120L) {
                    System.out.println("Detected to low of a TimeToLive for " + this.accepted[i] + ", fixing it to 120 minutes.");
                    this.expires[i] = 120L;
                    broken = true;
                }
                ++i;
                this.accepted = this.expand(this.accepted, 1);
                this.expires = this.expand(this.expires, 1);
            }
            if (i > 0) {
                this.accepted = this.collapse(this.accepted, 1);
                this.expires = this.collapse(this.expires, 1);
                OK = true;
            } else {
                this.accepted = new String[2];
                this.expires = new long[2];
                this.accepted[0] = "seedless";
                this.expires[0] = 720L;
                this.accepted[1] = "eepsite";
                this.expires[1] = 720L;
            }
        }
        catch (FileNotFoundException fnfe) {
            this.accepted = new String[2];
            this.expires = new long[2];
            this.accepted[0] = "seedless";
            this.expires[0] = 720L;
            this.accepted[1] = "eepsite";
            this.expires[1] = 720L;
        }
        catch (IOException ioe) {
            this.accepted = new String[2];
            this.expires = new long[2];
            this.accepted[0] = "seedless";
            this.expires[0] = 720L;
            this.accepted[1] = "eepsite";
            this.expires[1] = 720L;
        }
        try {
            fi.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!OK.booleanValue() || broken.booleanValue()) {
            try {
                fo = new PrintStream(cfg, "UTF-8");
                for (i = 0; i < this.accepted.length; ++i) {
                    fo.println(this.accepted[i] + " " + this.expires[i]);
                }
                fo.close();
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public long[] getExpires() {
        return this.expires;
    }

    public String[] getAccepted() {
        return this.accepted;
    }

    private String[] resize(String[] array, int size) {
        String[] temp = new String[size];
        int amount = size;
        if (size > array.length) {
            amount = array.length;
        }
        System.arraycopy(array, 0, temp, 0, amount);
        for (int j = array.length; j < size; ++j) {
            temp[j] = "";
        }
        return temp;
    }

    private String[] expand(String[] array, int amount) {
        return this.resize(array, array.length + amount);
    }

    private String[] collapse(String[] array, int amount) {
        return this.resize(array, array.length - amount);
    }

    private long[] resize(long[] array, int size) {
        long[] temp = new long[size];
        int amount = size;
        if (size > array.length) {
            amount = array.length;
        }
        System.arraycopy(array, 0, temp, 0, amount);
        for (int j = array.length; j < size; ++j) {
            temp[j] = 0L;
        }
        return temp;
    }

    private long[] expand(long[] array, int amount) {
        return this.resize(array, array.length + amount);
    }

    private long[] collapse(long[] array, int amount) {
        return this.resize(array, array.length - amount);
    }
}

