/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionManager;
import net.i2p.client.streaming.Packet;
import net.i2p.client.streaming.PacketLocal;
import net.i2p.data.Destination;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

public class ConnectionHandler {
    private I2PAppContext _context;
    private Log _log;
    private ConnectionManager _manager;
    private LinkedBlockingQueue<Packet> _synQueue;
    private boolean _active;
    private int _acceptTimeout;
    private static final int DEFAULT_ACCEPT_TIMEOUT = 3000;
    private static final int MAX_QUEUE_SIZE = 64;

    public ConnectionHandler(I2PAppContext context, ConnectionManager mgr) {
        this._context = context;
        this._log = context.logManager().getLog(ConnectionHandler.class);
        this._manager = mgr;
        this._synQueue = new LinkedBlockingQueue(64);
        this._active = false;
        this._acceptTimeout = 3000;
    }

    public void setActive(boolean active) {
        if (this._log.shouldLog(10)) {
            this._log.debug("setActive(" + active + ") called");
        }
        this._active = active;
        if (!active) {
            try {
                this._synQueue.put(new PoisonPacket());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean getActive() {
        return this._active;
    }

    public void receiveNewSyn(Packet packet) {
        boolean success;
        if (!this._active) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping new SYN request, as we're not listening");
            }
            if (packet.isFlagSet(1)) {
                this.sendReset(packet);
            }
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Receive new SYN: " + packet + ": timeout in " + this._acceptTimeout);
        }
        if (success = this._synQueue.offer(packet)) {
            SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new TimeoutSyn(packet), (long)this._acceptTimeout);
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping new SYN request, as the queue is full");
            }
            if (packet.isFlagSet(1)) {
                this.sendReset(packet);
            }
        }
    }

    public Connection accept(long timeoutMs) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Accept(" + timeoutMs + ") called");
        }
        long expiration = timeoutMs + this._context.clock().now();
        while (timeoutMs <= 0L || expiration >= this._context.clock().now()) {
            if (!this._active) {
                Packet packet;
                while ((packet = this._synQueue.poll()) != null && packet.getOptionalDelay() != 65536) {
                    this.sendReset(packet);
                }
                return null;
            }
            Packet syn = null;
            while (this._active && syn == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Accept(" + timeoutMs + "): active=" + this._active + " queue: " + this._synQueue.size());
                }
                if (timeoutMs <= 0L) {
                    try {
                        syn = this._synQueue.take();
                    }
                    catch (InterruptedException ie) {}
                    continue;
                }
                long remaining = expiration - this._context.clock().now();
                if (remaining < 1L) break;
                try {
                    syn = this._synQueue.poll(remaining, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                    break;
                }
            }
            if (syn == null) continue;
            if (syn.getOptionalDelay() == 65536) {
                return null;
            }
            if (syn.isFlagSet(1)) {
                Destination from = syn.getOptionalFrom();
                if (from == null) {
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn("Dropping SYN packet with no FROM: " + syn);
                    continue;
                }
                Connection oldcon = this._manager.getConnectionByOutboundId(syn.getReceiveStreamId());
                if (oldcon != null && from.equals((Object)oldcon.getRemotePeer())) {
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn("Dropping dup SYN: " + syn);
                    continue;
                }
                Connection con = this._manager.receiveConnection(syn);
                if (con == null) continue;
                return con;
            }
            this.reReceivePacket(syn);
        }
        return null;
    }

    private void reReceivePacket(Packet packet) {
        Connection con = this._manager.getConnectionByOutboundId(packet.getReceiveStreamId());
        if (con != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Found con for queued non-syn packet: " + packet);
            }
            this._manager.getPacketHandler().receivePacketDirect(packet, false);
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("Did not find con for queued non-syn packet, dropping: " + packet);
            }
            packet.releasePayload();
        }
    }

    private void sendReset(Packet packet) {
        boolean ok = packet.verifySignature(this._context, packet.getOptionalFrom(), null);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Received a spoofed SYN packet: they said they were " + packet.getOptionalFrom());
            }
            return;
        }
        PacketLocal reply = new PacketLocal(this._context, packet.getOptionalFrom());
        reply.setFlag(4);
        reply.setFlag(8);
        reply.setAckThrough(packet.getSequenceNum());
        reply.setSendStreamId(packet.getReceiveStreamId());
        reply.setReceiveStreamId(0L);
        reply.setOptionalFrom(this._manager.getSession().getMyDestination());
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending RST: " + reply + " because of " + packet);
        }
        this._manager.getPacketQueue().enqueue(reply);
    }

    private static class PoisonPacket
    extends Packet {
        public static final int POISON_MAX_DELAY_REQUEST = 65536;

        public PoisonPacket() {
            this.setOptionalDelay(65536);
        }
    }

    private class TimeoutSyn
    implements SimpleTimer.TimedEvent {
        private Packet _synPacket;

        public TimeoutSyn(Packet packet) {
            this._synPacket = packet;
        }

        public void timeReached() {
            boolean removed = ConnectionHandler.this._synQueue.remove(this._synPacket);
            if (removed) {
                if (this._synPacket.isFlagSet(1)) {
                    ConnectionHandler.this.sendReset(this._synPacket);
                } else {
                    ConnectionHandler.this.reReceivePacket(this._synPacket);
                }
            }
        }
    }
}

