/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.ClientPeerSelector;
import net.i2p.router.tunnel.pool.ExploratoryPeerSelector;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TestJob;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TunnelPoolManager
implements TunnelManagerFacade {
    private RouterContext _context;
    private Log _log;
    private final Map<Hash, TunnelPool> _clientInboundPools;
    private final Map<Hash, TunnelPool> _clientOutboundPools;
    private TunnelPool _inboundExploratory;
    private TunnelPool _outboundExploratory;
    private final BuildExecutor _executor;
    private boolean _isShutdown;
    private static final int DEFAULT_MAX_PCT_TUNNELS = 33;

    public TunnelPoolManager(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelPoolManager.class);
        this._clientInboundPools = new ConcurrentHashMap<Hash, TunnelPool>(4);
        this._clientOutboundPools = new ConcurrentHashMap<Hash, TunnelPool>(4);
        this._isShutdown = false;
        this._executor = new BuildExecutor(ctx, this);
        I2PThread execThread = new I2PThread((Runnable)this._executor, "BuildExecutor");
        execThread.setDaemon(true);
        execThread.start();
        ctx.statManager().createRateStat("tunnel.testSuccessTime", "How long do successful tunnel tests take?", "Tunnels", new long[]{60000L, 600000L, 3600000L, 10800000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.participatingTunnels", "How many tunnels are we participating in?", "Tunnels", new long[]{60000L, 600000L, 3600000L, 10800000L, 86400000L});
    }

    @Override
    public TunnelInfo selectInboundTunnel() {
        TunnelPool pool = this._inboundExploratory;
        if (pool == null) {
            return null;
        }
        TunnelInfo info = pool.selectTunnel();
        if (info == null) {
            this._inboundExploratory.buildFallback();
            info = this._inboundExploratory.selectTunnel();
        }
        return info;
    }

    @Override
    public TunnelInfo selectInboundTunnel(Hash destination) {
        if (destination == null) {
            return this.selectInboundTunnel();
        }
        TunnelPool pool = this._clientInboundPools.get(destination);
        if (pool != null) {
            return pool.selectTunnel();
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Want the inbound tunnel for " + destination.calculateHash().toBase64() + " but there isn't a pool?");
        }
        return null;
    }

    @Override
    public TunnelInfo selectOutboundTunnel() {
        TunnelPool pool = this._outboundExploratory;
        if (pool == null) {
            return null;
        }
        TunnelInfo info = pool.selectTunnel();
        if (info == null) {
            pool.buildFallback();
            info = pool.selectTunnel();
        }
        return info;
    }

    @Override
    public TunnelInfo selectOutboundTunnel(Hash destination) {
        if (destination == null) {
            return this.selectOutboundTunnel();
        }
        TunnelPool pool = this._clientOutboundPools.get(destination);
        if (pool != null) {
            return pool.selectTunnel();
        }
        return null;
    }

    @Override
    public TunnelInfo getTunnelInfo(TunnelId id) {
        TunnelInfo info = null;
        for (TunnelPool pool : this._clientInboundPools.values()) {
            info = pool.getTunnel(id);
            if (info == null) continue;
            return info;
        }
        info = this._inboundExploratory.getTunnel(id);
        if (info != null) {
            return info;
        }
        info = this._outboundExploratory.getTunnel(id);
        if (info != null) {
            return info;
        }
        return null;
    }

    @Override
    public int getFreeTunnelCount() {
        if (this._inboundExploratory == null) {
            return 0;
        }
        return this._inboundExploratory.size();
    }

    @Override
    public int getOutboundTunnelCount() {
        if (this._outboundExploratory == null) {
            return 0;
        }
        return this._outboundExploratory.size();
    }

    @Override
    public int getInboundClientTunnelCount() {
        int count = 0;
        for (TunnelPool pool : this._clientInboundPools.values()) {
            count += pool.listTunnels().size();
        }
        return count;
    }

    @Override
    public int getOutboundClientTunnelCount() {
        int count = 0;
        for (TunnelPool pool : this._clientOutboundPools.values()) {
            count += pool.listTunnels().size();
        }
        return count;
    }

    @Override
    public int getOutboundClientTunnelCount(Hash destination) {
        TunnelPool pool = this._clientOutboundPools.get(destination);
        if (pool != null) {
            return pool.getTunnelCount();
        }
        return 0;
    }

    @Override
    public int getParticipatingCount() {
        return this._context.tunnelDispatcher().getParticipatingCount();
    }

    @Override
    public long getLastParticipatingExpiration() {
        return this._context.tunnelDispatcher().getLastParticipatingExpiration();
    }

    @Override
    public double getShareRatio() {
        int part = this.getParticipatingCount();
        if (part <= 0) {
            return 0.0;
        }
        ArrayList<TunnelPool> pools = new ArrayList<TunnelPool>();
        this.listPools(pools);
        int count = 0;
        for (int i = 0; i < pools.size(); ++i) {
            TunnelPool pool = (TunnelPool)pools.get(i);
            count += pool.size() * pool.getSettings().getLength();
        }
        if (count <= 0) {
            return 100.0;
        }
        return Math.min((double)part / (double)count, 100.0);
    }

    @Override
    public boolean isValidTunnel(Hash client, TunnelInfo tunnel) {
        if (tunnel.getExpiration() < this._context.clock().now()) {
            return false;
        }
        TunnelPool pool = tunnel.isInbound() ? this._clientInboundPools.get(client) : this._clientOutboundPools.get(client);
        if (pool == null) {
            return false;
        }
        return pool.listTunnels().contains(tunnel);
    }

    @Override
    public TunnelPoolSettings getInboundSettings() {
        return this._inboundExploratory.getSettings();
    }

    @Override
    public TunnelPoolSettings getOutboundSettings() {
        return this._outboundExploratory.getSettings();
    }

    @Override
    public void setInboundSettings(TunnelPoolSettings settings) {
        this._inboundExploratory.setSettings(settings);
    }

    @Override
    public void setOutboundSettings(TunnelPoolSettings settings) {
        this._outboundExploratory.setSettings(settings);
    }

    @Override
    public TunnelPoolSettings getInboundSettings(Hash client) {
        TunnelPool pool = this._clientInboundPools.get(client);
        if (pool != null) {
            return pool.getSettings();
        }
        return null;
    }

    @Override
    public TunnelPoolSettings getOutboundSettings(Hash client) {
        TunnelPool pool = this._clientOutboundPools.get(client);
        if (pool != null) {
            return pool.getSettings();
        }
        return null;
    }

    @Override
    public void setInboundSettings(Hash client, TunnelPoolSettings settings) {
        TunnelPoolManager.setSettings(this._clientInboundPools, client, settings);
    }

    @Override
    public void setOutboundSettings(Hash client, TunnelPoolSettings settings) {
        TunnelPoolManager.setSettings(this._clientOutboundPools, client, settings);
    }

    private static void setSettings(Map<Hash, TunnelPool> pools, Hash client, TunnelPoolSettings settings) {
        TunnelPool pool = pools.get(client);
        if (pool != null) {
            settings.setDestination(client);
            pool.setSettings(settings);
        }
    }

    @Override
    public void restart() {
        this.shutdown();
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildTunnels(Destination client, ClientTunnelSettings settings) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Building tunnels for the client " + client.calculateHash().toBase64() + ": " + settings);
        }
        Hash dest = client.calculateHash();
        settings.getInboundSettings().setDestination(dest);
        settings.getOutboundSettings().setDestination(dest);
        TunnelPool inbound = null;
        TunnelPool outbound = null;
        TunnelPoolManager tunnelPoolManager = this;
        synchronized (tunnelPoolManager) {
            inbound = this._clientInboundPools.get(dest);
            if (inbound == null) {
                inbound = new TunnelPool(this._context, this, settings.getInboundSettings(), new ClientPeerSelector());
                this._clientInboundPools.put(dest, inbound);
            } else {
                inbound.setSettings(settings.getInboundSettings());
            }
            outbound = this._clientOutboundPools.get(dest);
            if (outbound == null) {
                outbound = new TunnelPool(this._context, this, settings.getOutboundSettings(), new ClientPeerSelector());
                this._clientOutboundPools.put(dest, outbound);
            } else {
                outbound.setSettings(settings.getOutboundSettings());
            }
        }
        inbound.startup();
        SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new DelayedStartup(outbound), 3000L);
    }

    public synchronized void removeTunnels(Hash destination) {
        if (destination == null) {
            return;
        }
        if (this._context.clientManager().isLocal(destination) && this._log.shouldLog(50)) {
            this._log.log(50, "wtf, why are you removing the pool for " + destination.toBase64(), (Throwable)new Exception("i did it"));
        }
        TunnelPool inbound = this._clientInboundPools.remove(destination);
        TunnelPool outbound = this._clientOutboundPools.remove(destination);
        if (inbound != null) {
            inbound.shutdown();
        }
        if (outbound != null) {
            outbound.shutdown();
        }
    }

    void buildComplete(PooledTunnelCreatorConfig cfg) {
        if (cfg.getLength() > 1 && !this._context.router().gracefulShutdownInProgress() && !Boolean.valueOf(this._context.getProperty("router.disableTunnelTesting")).booleanValue()) {
            TunnelPool pool = cfg.getTunnelPool();
            if (pool == null) {
                this._log.error("How does this not have a pool?  " + cfg, (Throwable)new Exception("baf"));
                pool = cfg.getDestination() != null ? (cfg.isInbound() ? this._clientInboundPools.get(cfg.getDestination()) : this._clientOutboundPools.get(cfg.getDestination())) : (cfg.isInbound() ? this._inboundExploratory : this._outboundExploratory);
                cfg.setTunnelPool(pool);
            }
            this._context.jobQueue().addJob(new TestJob(this._context, cfg, pool));
        }
    }

    void buildComplete() {
    }

    @Override
    public void startup() {
        this._isShutdown = false;
        if (!this._executor.isRunning()) {
            I2PThread t = new I2PThread((Runnable)this._executor, "BuildExecutor");
            t.setDaemon(true);
            t.start();
        }
        ExploratoryPeerSelector selector = new ExploratoryPeerSelector();
        TunnelPoolSettings inboundSettings = new TunnelPoolSettings();
        inboundSettings.setIsExploratory(true);
        inboundSettings.setIsInbound(true);
        this._inboundExploratory = new TunnelPool(this._context, this, inboundSettings, selector);
        this._inboundExploratory.startup();
        TunnelPoolSettings outboundSettings = new TunnelPoolSettings();
        outboundSettings.setIsExploratory(true);
        outboundSettings.setIsInbound(false);
        this._outboundExploratory = new TunnelPool(this._context, this, outboundSettings, selector);
        SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new DelayedStartup(this._outboundExploratory), 3000L);
        this._context.jobQueue().addJob(new BootstrapPool(this._context, this._inboundExploratory));
        this._context.jobQueue().addJob(new BootstrapPool(this._context, this._outboundExploratory));
    }

    @Override
    public void shutdown() {
        if (this._inboundExploratory != null) {
            this._inboundExploratory.shutdown();
        }
        if (this._outboundExploratory != null) {
            this._outboundExploratory.shutdown();
        }
        this._isShutdown = true;
    }

    @Override
    public void listPools(List<TunnelPool> out) {
        out.addAll(this._clientInboundPools.values());
        out.addAll(this._clientOutboundPools.values());
        if (this._inboundExploratory != null) {
            out.add(this._inboundExploratory);
        }
        if (this._outboundExploratory != null) {
            out.add(this._outboundExploratory);
        }
    }

    void tunnelFailed() {
        this._executor.repoll();
    }

    BuildExecutor getExecutor() {
        return this._executor;
    }

    boolean isShutdown() {
        return this._isShutdown;
    }

    @Override
    public int getInboundBuildQueueSize() {
        return this._executor.getInboundBuildQueueSize();
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
    }

    private int countTunnelsPerPeer(ObjectCounter<Hash> lc) {
        ArrayList<TunnelPool> pools = new ArrayList<TunnelPool>();
        this.listPools(pools);
        int tunnelCount = 0;
        for (TunnelPool tp : pools) {
            for (TunnelInfo info : tp.listTunnels()) {
                if (info.getLength() <= 1) continue;
                ++tunnelCount;
                for (int j = 0; j < info.getLength(); ++j) {
                    Hash peer = info.getPeer(j);
                    if (this._context.routerHash().equals((Object)peer)) continue;
                    lc.increment((Object)peer);
                }
            }
        }
        return tunnelCount;
    }

    @Override
    public Set<Hash> selectPeersInTooManyTunnels() {
        ObjectCounter lc = new ObjectCounter();
        int tunnelCount = this.countTunnelsPerPeer((ObjectCounter<Hash>)lc);
        HashSet<Hash> rv = new HashSet<Hash>();
        if (tunnelCount >= 4 && this._context.router().getUptime() > 600000L) {
            int max = this._context.getProperty("router.maxTunnelPercentage", 33);
            for (Hash h : lc.objects()) {
                if (lc.count((Object)h) <= 0 || (lc.count((Object)h) + 1) * 100 / (tunnelCount + 1) <= max) continue;
                rv.add(h);
            }
        }
        return rv;
    }

    @Override
    public Map<Hash, TunnelPool> getInboundClientPools() {
        return new HashMap<Hash, TunnelPool>(this._clientInboundPools);
    }

    @Override
    public Map<Hash, TunnelPool> getOutboundClientPools() {
        return new HashMap<Hash, TunnelPool>(this._clientOutboundPools);
    }

    @Override
    public TunnelPool getInboundExploratoryPool() {
        return this._inboundExploratory;
    }

    @Override
    public TunnelPool getOutboundExploratoryPool() {
        return this._outboundExploratory;
    }

    private static class BootstrapPool
    extends JobImpl {
        private TunnelPool _pool;

        public BootstrapPool(RouterContext ctx, TunnelPool pool) {
            super(ctx);
            this._pool = pool;
            this.getTiming().setStartAfter(ctx.clock().now() + 30000L);
        }

        public String getName() {
            return "Bootstrap tunnel pool";
        }

        public void runJob() {
            this._pool.buildFallback();
        }
    }

    private static class DelayedStartup
    implements SimpleTimer.TimedEvent {
        private TunnelPool pool;

        public DelayedStartup(TunnelPool p) {
            this.pool = p;
        }

        public void timeReached() {
            this.pool.startup();
        }
    }
}

