/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientPeerSelector
extends TunnelPeerSelector {
    ClientPeerSelector() {
    }

    @Override
    public List<Hash> selectPeers(RouterContext ctx, TunnelPoolSettings settings) {
        int length = this.getLength(ctx, settings);
        if (length < 0) {
            return null;
        }
        if (length == 0 && settings.getLength() + settings.getLengthVariance() > 0) {
            return null;
        }
        HashSet<Hash> matches = new HashSet<Hash>(length);
        if (length > 0 && this.shouldSelectExplicit(settings)) {
            return this.selectExplicit(ctx, settings, length);
        }
        Set<Hash> exclude = this.getExclude(ctx, settings.isInbound(), settings.isExploratory());
        ctx.profileOrganizer().selectFastPeers(length, exclude, matches, settings.getIPRestriction());
        matches.remove(ctx.routerHash());
        ArrayList<Hash> rv = new ArrayList<Hash>(matches);
        if (rv.size() > 1) {
            this.orderPeers(rv, settings.getRandomKey());
        }
        if (settings.isInbound()) {
            rv.add(0, ctx.routerHash());
        } else {
            rv.add(ctx.routerHash());
        }
        return rv;
    }
}

