/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.VariableTunnelBuildMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.tunnel.BuildMessageGenerator;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.ExpireJob;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;

class BuildRequestor {
    private static final List<Integer> ORDER;
    private static final int PRIORITY = 500;
    static final int REQUEST_TIMEOUT = 13000;
    private static final int FIRST_HOP_TIMEOUT = 10000;
    private static final int BUILD_MSG_TIMEOUT = 60000;
    private static final String MIN_VARIABLE_VERSION = "0.7.12";
    private static final boolean SEND_VARIABLE = true;
    private static final int SHORT_RECORDS = 5;
    private static final int LONG_RECORDS = 8;
    private static final VersionComparator _versionComparator;
    private static final List<Integer> SHORT_ORDER;

    BuildRequestor() {
    }

    private static boolean usePairedTunnels(RouterContext ctx) {
        String val = ctx.getProperty("router.usePairedTunnels");
        return val == null || Boolean.valueOf(val) != false;
    }

    private static void prepare(RouterContext ctx, PooledTunnelCreatorConfig cfg) {
        for (int i = 0; i < cfg.getLength(); ++i) {
            if (!cfg.isInbound() && i == 0) {
                if (cfg.getLength() <= 1) {
                    cfg.getConfig(i).setSendTunnelId(DataHelper.toLong((int)4, (long)ctx.random().nextLong(0xFFFFFFFEL)));
                }
            } else {
                cfg.getConfig(i).setReceiveTunnelId(DataHelper.toLong((int)4, (long)ctx.random().nextLong(0xFFFFFFFEL)));
            }
            if (i > 0) {
                cfg.getConfig(i - 1).setSendTunnelId(cfg.getConfig(i).getReceiveTunnelId());
            }
            byte[] iv = new byte[16];
            ctx.random().nextBytes(iv);
            cfg.getConfig(i).setReplyIV(new ByteArray(iv));
            cfg.getConfig(i).setReplyKey(ctx.keyGenerator().generateSessionKey());
        }
    }

    public static void request(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
        BuildRequestor.prepare(ctx, cfg);
        if (cfg.getLength() <= 1) {
            BuildRequestor.buildZeroHop(ctx, pool, cfg, exec);
            return;
        }
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        cfg.setTunnelPool(pool);
        TunnelInfo pairedTunnel = null;
        pairedTunnel = pool.getSettings().isExploratory() || !BuildRequestor.usePairedTunnels(ctx) ? (pool.getSettings().isInbound() ? ctx.tunnelManager().selectOutboundTunnel() : ctx.tunnelManager().selectInboundTunnel()) : (pool.getSettings().isInbound() ? ctx.tunnelManager().selectOutboundTunnel(pool.getSettings().getDestination()) : ctx.tunnelManager().selectInboundTunnel(pool.getSettings().getDestination()));
        if (pairedTunnel == null) {
            if (log.shouldLog(30)) {
                log.warn("Couldn't find a paired tunnel for " + cfg + ", fall back on exploratory tunnels for pairing");
            }
            if (!pool.getSettings().isExploratory() && BuildRequestor.usePairedTunnels(ctx)) {
                pairedTunnel = pool.getSettings().isInbound() ? ctx.tunnelManager().selectOutboundTunnel() : ctx.tunnelManager().selectInboundTunnel();
            }
        }
        if (pairedTunnel == null) {
            if (log.shouldLog(40)) {
                log.error("Tunnel build failed, as we couldn't find a paired tunnel for " + cfg);
            }
            exec.buildComplete(cfg, pool);
            return;
        }
        long beforeCreate = System.currentTimeMillis();
        TunnelBuildMessage msg = BuildRequestor.createTunnelBuildMessage(ctx, pool, cfg, pairedTunnel, exec);
        long createTime = System.currentTimeMillis() - beforeCreate;
        if (msg == null) {
            if (log.shouldLog(40)) {
                log.error("Tunnel build failed, as we couldn't create the tunnel build message for " + cfg);
            }
            exec.buildComplete(cfg, pool);
            return;
        }
        long beforeDispatch = System.currentTimeMillis();
        if (cfg.isInbound()) {
            if (log.shouldLog(20)) {
                log.info("Sending the tunnel build request " + msg.getUniqueId() + " out the tunnel " + pairedTunnel + " to " + cfg.getPeer(0).toBase64() + " for " + cfg + " waiting for the reply of " + cfg.getReplyMessageId());
            }
            ctx.tunnelDispatcher().dispatchOutbound(msg, pairedTunnel.getSendTunnelId(0), cfg.getPeer(0));
        } else {
            if (log.shouldLog(20)) {
                log.info("Sending the tunnel build request directly to " + cfg.getPeer(1).toBase64() + " for " + cfg + " waiting for the reply of " + cfg.getReplyMessageId() + " with msgId=" + msg.getUniqueId());
            }
            OutNetMessage outMsg = new OutNetMessage(ctx);
            msg.setMessageExpiration(ctx.clock().now() + 60000L + ctx.random().nextLong(20000L));
            outMsg.setExpiration(ctx.clock().now() + 10000L);
            outMsg.setMessage(msg);
            outMsg.setPriority(500);
            RouterInfo peer = ctx.netDb().lookupRouterInfoLocally(cfg.getPeer(1));
            if (peer == null) {
                if (log.shouldLog(40)) {
                    log.error("Could not find the next hop to send the outbound request to: " + cfg);
                }
                exec.buildComplete(cfg, pool);
                return;
            }
            outMsg.setTarget(peer);
            outMsg.setOnFailedSendJob(new TunnelBuildFirstHopFailJob(ctx, pool, cfg, exec));
            ctx.outNetMessagePool().add(outMsg);
        }
        if (log.shouldLog(10)) {
            log.debug("Tunnel build message " + msg.getUniqueId() + " created in " + createTime + "ms and dispatched in " + (System.currentTimeMillis() - beforeDispatch));
        }
    }

    private static boolean supportsVariable(RouterContext ctx, Hash h) {
        RouterInfo ri = ctx.netDb().lookupRouterInfoLocally(h);
        if (ri == null) {
            return false;
        }
        String v = ri.getOption("router.version");
        if (v == null) {
            return false;
        }
        return _versionComparator.compare(v, MIN_VARIABLE_VERSION) >= 0;
    }

    private static TunnelBuildMessage createTunnelBuildMessage(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, TunnelInfo pairedTunnel, BuildExecutor exec) {
        ArrayList<Integer> order;
        TunnelBuildMessage msg;
        int i;
        boolean useVariable;
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        long replyTunnel = 0L;
        Hash replyRouter = null;
        boolean bl = useVariable = cfg.getLength() <= 5;
        if (cfg.isInbound()) {
            replyRouter = ctx.routerHash();
            if (useVariable) {
                if (!BuildRequestor.supportsVariable(ctx, pairedTunnel.getPeer(pairedTunnel.getLength() - 1))) {
                    useVariable = false;
                } else {
                    for (i = 0; i < cfg.getLength() - 1; ++i) {
                        if (BuildRequestor.supportsVariable(ctx, cfg.getPeer(i))) continue;
                        useVariable = false;
                        break;
                    }
                }
            }
        } else {
            replyTunnel = pairedTunnel.getReceiveTunnelId(0).getTunnelId();
            replyRouter = pairedTunnel.getPeer(0);
            if (useVariable) {
                if (!BuildRequestor.supportsVariable(ctx, replyRouter)) {
                    useVariable = false;
                } else {
                    for (i = 1; i < cfg.getLength() - 1; ++i) {
                        if (BuildRequestor.supportsVariable(ctx, cfg.getPeer(i))) continue;
                        useVariable = false;
                        break;
                    }
                }
            }
        }
        if (useVariable) {
            msg = new VariableTunnelBuildMessage(ctx, 5);
            order = new ArrayList<Integer>(SHORT_ORDER);
            if (log.shouldLog(20)) {
                log.info("Using new VTBM");
            }
        } else {
            msg = new TunnelBuildMessage(ctx);
            order = new ArrayList<Integer>(ORDER);
        }
        Collections.shuffle(order, (Random)ctx.random());
        cfg.setReplyOrder(order);
        if (log.shouldLog(10)) {
            log.debug("Build order: " + order + " for " + cfg);
        }
        for (int i2 = 0; i2 < msg.getRecordCount(); ++i2) {
            int hop = (Integer)order.get(i2);
            PublicKey key = null;
            if (!BuildMessageGenerator.isBlank(cfg, hop)) {
                Hash peer = cfg.getPeer(hop);
                RouterInfo peerInfo = ctx.netDb().lookupRouterInfoLocally(peer);
                if (peerInfo == null) {
                    if (log.shouldLog(40)) {
                        log.error("Peer selected for hop " + i2 + "/" + hop + " was not found locally: " + peer.toBase64() + " for " + cfg);
                    }
                    return null;
                }
                key = peerInfo.getIdentity().getPublicKey();
            }
            if (log.shouldLog(10)) {
                log.debug(cfg.getReplyMessageId() + ": record " + i2 + "/" + hop + " has key " + key);
            }
            BuildMessageGenerator.createRecord(i2, hop, msg, cfg, replyRouter, replyTunnel, ctx, key);
        }
        BuildMessageGenerator.layeredEncrypt(ctx, msg, cfg, order);
        return msg;
    }

    private static void buildZeroHop(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        if (log.shouldLog(10)) {
            log.debug("Build zero hop tunnel " + cfg);
        }
        exec.buildComplete(cfg, pool);
        if (cfg.isInbound()) {
            ctx.tunnelDispatcher().joinInbound(cfg);
        } else {
            ctx.tunnelDispatcher().joinOutbound(cfg);
        }
        pool.addTunnel(cfg);
        exec.buildSuccessful(cfg);
        ExpireJob expireJob = new ExpireJob(ctx, cfg, pool);
        cfg.setExpireJob(expireJob);
        ctx.jobQueue().addJob(expireJob);
    }

    static {
        int i;
        ORDER = new ArrayList<Integer>(BuildMessageGenerator.ORDER.length);
        for (i = 0; i < BuildMessageGenerator.ORDER.length; ++i) {
            ORDER.add(i);
        }
        _versionComparator = new VersionComparator();
        SHORT_ORDER = new ArrayList<Integer>(5);
        for (i = 0; i < 5; ++i) {
            SHORT_ORDER.add(i);
        }
    }

    private static class TunnelBuildFirstHopFailJob
    extends JobImpl {
        TunnelPool _pool;
        PooledTunnelCreatorConfig _cfg;
        BuildExecutor _exec;

        private TunnelBuildFirstHopFailJob(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
            super(ctx);
            this._cfg = cfg;
            this._exec = exec;
            this._pool = pool;
        }

        public String getName() {
            return "Timeout contacting first peer for OB tunnel";
        }

        public void runJob() {
            this._exec.buildComplete(this._cfg, this._pool);
            this.getContext().profileManager().tunnelTimedOut(this._cfg.getPeer(1));
            this.getContext().statManager().addRateData("tunnel.buildFailFirstHop", 1L, 0L);
        }
    }
}

