/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.PumpedTunnelGateway;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.util.I2PThread;

public class TunnelGatewayPumper
implements Runnable {
    private RouterContext _context;
    private final BlockingQueue<PumpedTunnelGateway> _wantsPumping;
    private boolean _stop;
    private static final int PUMPERS = 4;
    private static final int POISON_PTG = -99999;

    public TunnelGatewayPumper(RouterContext ctx) {
        this._context = ctx;
        this._wantsPumping = new LinkedBlockingQueue<PumpedTunnelGateway>();
        this._stop = false;
        for (int i = 0; i < 4; ++i) {
            new I2PThread((Runnable)this, "Tunnel GW pumper " + i + '/' + 4, true).start();
        }
    }

    public void stopPumping() {
        int i;
        this._stop = true;
        this._wantsPumping.clear();
        PoisonPTG poison = new PoisonPTG(this._context);
        for (i = 0; i < 4; ++i) {
            this._wantsPumping.offer(poison);
        }
        for (i = 1; i <= 5 && !this._wantsPumping.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._wantsPumping.clear();
    }

    public void wantsPumping(PumpedTunnelGateway gw) {
        if (!this._stop) {
            this._wantsPumping.offer(gw);
        }
    }

    public void run() {
        PumpedTunnelGateway gw = null;
        ArrayList<TunnelGateway.Pending> queueBuf = new ArrayList<TunnelGateway.Pending>(32);
        while (!this._stop) {
            try {
                gw = this._wantsPumping.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (gw == null) continue;
            if (gw.getMessagesSent() == -99999) break;
            gw.pump(queueBuf);
            gw = null;
        }
    }

    private static class PoisonPTG
    extends PumpedTunnelGateway {
        public PoisonPTG(RouterContext ctx) {
            super(ctx, null, null, null, null);
        }

        public int getMessagesSent() {
            return -99999;
        }
    }
}

