/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class OutboundMessageDistributor {
    private RouterContext _context;
    private int _priority;
    private Log _log;
    private static final int MAX_DISTRIBUTE_TIME = 10000;

    public OutboundMessageDistributor(RouterContext ctx, int priority) {
        this._context = ctx;
        this._priority = priority;
        this._log = ctx.logManager().getLog(OutboundMessageDistributor.class);
    }

    public void distribute(I2NPMessage msg, Hash target) {
        this.distribute(msg, target, null);
    }

    public void distribute(I2NPMessage msg, Hash target, TunnelId tunnel) {
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(target);
        if (info == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("outbound distributor to " + target.toBase64().substring(0, 4) + "." + (tunnel != null ? tunnel.getTunnelId() + "" : "") + ": no info locally, searching...");
            }
            this._context.netDb().lookupRouterInfo(target, new DistributeJob(this._context, msg, target, tunnel), null, 10000L);
            return;
        }
        this.distribute(msg, info, tunnel);
    }

    public void distribute(I2NPMessage msg, RouterInfo target, TunnelId tunnel) {
        I2NPMessage m = msg;
        if (tunnel != null) {
            TunnelGatewayMessage t = new TunnelGatewayMessage(this._context);
            t.setMessage(msg);
            t.setTunnelId(tunnel);
            t.setMessageExpiration(m.getMessageExpiration());
            m = t;
        }
        if (this._context.routerHash().equals((Object)target.getIdentity().calculateHash())) {
            if (this._log.shouldLog(10)) {
                this._log.debug("queueing inbound message to ourselves: " + m);
            }
            this._context.inNetMessagePool().add(m, null, null);
            return;
        }
        OutNetMessage out = new OutNetMessage(this._context);
        out.setExpiration(this._context.clock().now() + 10000L);
        out.setTarget(target);
        out.setMessage(m);
        out.setPriority(this._priority);
        if (this._log.shouldLog(10)) {
            this._log.debug("queueing outbound message to " + target.getIdentity().calculateHash().toBase64().substring(0, 4));
        }
        this._context.outNetMessagePool().add(out);
    }

    private class DistributeJob
    extends JobImpl {
        private I2NPMessage _message;
        private Hash _target;
        private TunnelId _tunnel;

        public DistributeJob(RouterContext ctx, I2NPMessage msg, Hash target, TunnelId id) {
            super(ctx);
            this._message = msg;
            this._target = target;
            this._tunnel = id;
        }

        public String getName() {
            return "Distribute outbound message";
        }

        public void runJob() {
            RouterInfo info = this.getContext().netDb().lookupRouterInfoLocally(this._target);
            if (info != null) {
                OutboundMessageDistributor.this._log.debug("outbound distributor to " + this._target.toBase64().substring(0, 4) + "." + (this._tunnel != null ? this._tunnel.getTunnelId() + "" : "") + ": found on search");
                OutboundMessageDistributor.this.distribute(this._message, info, this._tunnel);
            } else {
                OutboundMessageDistributor.this._log.error("outbound distributor to " + this._target.toBase64().substring(0, 4) + "." + (this._tunnel != null ? this._tunnel.getTunnelId() + "" : "") + ": NOT found on search");
            }
        }
    }
}

