/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.ByteArray;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.DummyValidator;
import net.i2p.router.tunnel.IVValidator;
import net.i2p.router.tunnel.OutboundGatewayProcessor;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

public class InboundEndpointProcessor {
    private final RouterContext _context;
    private final Log _log;
    private final TunnelCreatorConfig _config;
    private final IVValidator _validator;
    static final boolean USE_ENCRYPTION = true;
    private static final ByteCache _cache = ByteCache.getInstance((int)128, (int)16);

    public InboundEndpointProcessor(RouterContext ctx, TunnelCreatorConfig cfg) {
        this(ctx, cfg, DummyValidator.getInstance());
    }

    public InboundEndpointProcessor(RouterContext ctx, TunnelCreatorConfig cfg, IVValidator validator) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundEndpointProcessor.class);
        this._config = cfg;
        this._validator = validator;
    }

    public Hash getDestination() {
        return this._config.getDestination();
    }

    public TunnelCreatorConfig getConfig() {
        return this._config;
    }

    public boolean retrievePreprocessedData(byte[] orig, int offset, int length, Hash prev) {
        Hash last = this._config.getPeer(this._config.getLength() - 2);
        if (!last.equals((Object)prev)) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid previous peer - attempted hostile loop?  from " + prev + ", expected " + last);
            }
            return false;
        }
        ByteArray ba = _cache.acquire();
        byte[] iv = ba.getData();
        System.arraycopy(orig, offset, iv, 0, iv.length);
        boolean ok = this._validator.receiveIV(iv, 0, orig, offset + 16);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid IV received");
            }
            _cache.release(ba);
            return false;
        }
        this.decrypt(this._context, this._config, iv, orig, offset, length);
        _cache.release(ba);
        if (this._config.getLength() > 0) {
            int rtt = 0;
            if (this._log.shouldLog(10)) {
                this._log.debug("Received a " + length + "byte message through tunnel " + this._config);
            }
            for (int i = 0; i < this._config.getLength(); ++i) {
                this._context.profileManager().tunnelDataPushed(this._config.getPeer(i), rtt, length);
            }
            this._config.incrementVerifiedBytesTransferred(length);
        }
        return true;
    }

    private void decrypt(RouterContext ctx, TunnelCreatorConfig cfg, byte[] iv, byte[] orig, int offset, int length) {
        Log log = ctx.logManager().getLog(OutboundGatewayProcessor.class);
        ByteArray ba = _cache.acquire();
        byte[] cur = ba.getData();
        for (int i = cfg.getLength() - 2; i >= 0; --i) {
            OutboundGatewayProcessor.decrypt(ctx, iv, orig, offset, length, cur, cfg.getConfig(i));
            if (!log.shouldLog(10)) continue;
        }
        _cache.release(ba);
    }
}

